/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.fetch.privacy;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.browser.Fingerprint;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.measure.ByteUnit;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.crawl.fetch.FetchResult;
import ai.platon.pulsar.crawl.fetch.FetchTask;
import ai.platon.pulsar.crawl.fetch.driver.WebDriver;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContext;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContextId;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContextIdGenerator;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContextIdGeneratorFactory;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010(\u001a\u00020)H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\bH\u0016J\b\u0010+\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0007H&J\u0010\u0010.\u001a\u00020\b2\u0006\u0010/\u001a\u000200H&J\u0010\u00101\u001a\u00020\b2\u0006\u0010/\u001a\u000200H&J\u0010\u00102\u001a\u00020\b2\u0006\u0010-\u001a\u00020\u0007H&J\b\u00103\u001a\u00020)H\u0002JC\u00104\u001a\u0002052\u0006\u00106\u001a\u0002072(\u00108\u001a$\b\u0001\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020:\u0012\n\u0012\b\u0012\u0004\u0012\u0002050;\u0012\u0006\u0012\u0004\u0018\u00010<09H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010=R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0018R\u0016\u0010\u001a\u001a\n \u0011*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\b0%\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006>"}, d2={"Lai/platon/pulsar/crawl/fetch/privacy/PrivacyManager;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "activeContexts", "Ljava/util/concurrent/ConcurrentHashMap;", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextId;", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContext;", "getActiveContexts", "()Ljava/util/concurrent/ConcurrentHashMap;", "availableMemory", "", "getAvailableMemory", "()J", "cleaningService", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "isActive", "", "()Z", "isClosed", "logger", "Lorg/slf4j/Logger;", "memoryToReserve", "", "privacyContextIdGenerator", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextIdGenerator;", "getPrivacyContextIdGenerator", "()Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextIdGenerator;", "privacyContextIdGeneratorFactory", "Lai/platon/pulsar/crawl/fetch/privacy/PrivacyContextIdGeneratorFactory;", "zombieContexts", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "getZombieContexts", "()Ljava/util/concurrent/ConcurrentLinkedDeque;", "close", "", "privacyContext", "closeZombieContexts", "computeIfAbsent", "id", "computeIfNecessary", "fingerprint", "Lai/platon/pulsar/common/browser/Fingerprint;", "computeNextContext", "createUnmanagedContext", "reportZombieContexts", "run", "Lai/platon/pulsar/crawl/fetch/FetchResult;", "task", "Lai/platon/pulsar/crawl/fetch/FetchTask;", "fetchFun", "Lkotlin/Function3;", "Lai/platon/pulsar/crawl/fetch/driver/WebDriver;", "Lkotlin/coroutines/Continuation;", "", "(Lai/platon/pulsar/crawl/fetch/FetchTask;Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "pulsar-skeleton"})
public abstract class PrivacyManager
implements AutoCloseable {
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    @NotNull
    private final AtomicBoolean closed;
    private final double memoryToReserve;
    @NotNull
    private final PrivacyContextIdGeneratorFactory privacyContextIdGeneratorFactory;
    @NotNull
    private final ConcurrentLinkedDeque<PrivacyContext> zombieContexts;
    @NotNull
    private final ConcurrentHashMap<PrivacyContextId, PrivacyContext> activeContexts;
    private final ScheduledExecutorService cleaningService;

    public PrivacyManager(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.logger = LoggerFactory.getLogger(PrivacyManager.class);
        this.closed = new AtomicBoolean();
        this.memoryToReserve = ByteUnit.GIB.toBytes(2.0);
        this.privacyContextIdGeneratorFactory = new PrivacyContextIdGeneratorFactory(this.conf);
        this.zombieContexts = new ConcurrentLinkedDeque();
        this.activeContexts = new ConcurrentHashMap();
        this.cleaningService = Executors.newScheduledThreadPool(1);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    private final boolean isClosed() {
        return this.closed.get();
    }

    private final long getAvailableMemory() {
        return AppMetrics.Companion.getAvailableMemory();
    }

    @NotNull
    public PrivacyContextIdGenerator getPrivacyContextIdGenerator() {
        return this.privacyContextIdGeneratorFactory.getGenerator();
    }

    public final boolean isActive() {
        return !this.closed.get() && AppContext.INSTANCE.isActive();
    }

    @NotNull
    public final ConcurrentLinkedDeque<PrivacyContext> getZombieContexts() {
        return this.zombieContexts;
    }

    @NotNull
    public final ConcurrentHashMap<PrivacyContextId, PrivacyContext> getActiveContexts() {
        return this.activeContexts;
    }

    @Nullable
    public abstract Object run(@NotNull FetchTask var1, @NotNull Function3<? super FetchTask, ? super WebDriver, ? super Continuation<? super FetchResult>, ? extends Object> var2, @NotNull Continuation<? super FetchResult> var3);

    @NotNull
    public abstract PrivacyContext computeNextContext(@NotNull Fingerprint var1);

    @NotNull
    public abstract PrivacyContext computeIfNecessary(@NotNull Fingerprint var1);

    @NotNull
    public abstract PrivacyContext computeIfAbsent(@NotNull PrivacyContextId var1);

    @NotNull
    public abstract PrivacyContext createUnmanagedContext(@NotNull PrivacyContextId var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(@NotNull PrivacyContext privacyContext) {
        Intrinsics.checkNotNullParameter((Object)privacyContext, (String)"privacyContext");
        PrivacyContextId id = privacyContext.getId();
        ConcurrentHashMap<PrivacyContextId, PrivacyContext> concurrentHashMap = this.activeContexts;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (concurrentHashMap) {
            boolean bl3 = false;
            if (this.getActiveContexts().containsKey(id)) {
                this.getActiveContexts().remove(id);
                this.getZombieContexts().add(privacyContext);
                if ((double)this.getAvailableMemory() > this.memoryToReserve) {
                    this.cleaningService.schedule(() -> PrivacyManager.close$lambda-1$lambda-0(this), 5L, TimeUnit.SECONDS);
                } else {
                    this.closeZombieContexts();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Object object;
            this.logger.info("Closing privacy contexts");
            Object object2 = this.activeContexts.values();
            Intrinsics.checkNotNullExpressionValue(object2, (String)"activeContexts.values");
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PrivacyContext it = (PrivacyContext)element$iv;
                boolean bl = false;
                this.getZombieContexts().add(it);
            }
            this.activeContexts.clear();
            object2 = this.cleaningService;
            boolean bl = false;
            try {
                object = Result.Companion;
                Object $this$close_u24lambda_u2d3 = object2;
                boolean bl2 = false;
                $this$close_u24lambda_u2d3.shutdown();
                Unit unit = Unit.INSTANCE;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            object2 = object;
            bl = false;
            boolean bl5 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Throwable throwable2 = throwable;
                boolean bl6 = false;
                boolean bl7 = false;
                Throwable throwable3 = throwable2;
                boolean bl8 = false;
                Throwable it = throwable3;
                boolean bl9 = false;
                this.logger.warn(ExceptionsKt.stringify$default((Throwable)it, null, null, (int)3, null));
            }
            this.closeZombieContexts();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void closeZombieContexts() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.zombieContexts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PrivacyContext it = (PrivacyContext)element$iv$iv;
            boolean bl = false;
            if (!(!it.getClosed().get())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List pendingContexts = (List)destination$iv$iv;
        if (this.isClosed()) {
            this.zombieContexts.clear();
        }
        Collection collection = pendingContexts;
        boolean bl = false;
        if (!collection.isEmpty()) {
            pendingContexts.parallelStream().forEach(arg_0 -> PrivacyManager.closeZombieContexts$lambda-8(this, arg_0));
            this.reportZombieContexts();
        }
    }

    private final void reportZombieContexts() {
        Collection collection = this.zombieContexts;
        boolean bl = false;
        if (!collection.isEmpty()) {
            String prefix = "The latest context throughput: ";
            String postfix = " (success/sec)";
            String string = CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)this.zombieContexts, (int)15), (CharSequence)", ", (CharSequence)prefix, (CharSequence)postfix, (int)0, null, (Function1)reportZombieContexts.1.INSTANCE, (int)24, null);
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string;
            boolean bl4 = false;
            this.logger.info(it);
        }
    }

    private static final void close$lambda-1$lambda-0(PrivacyManager this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.closeZombieContexts();
    }

    private static final void closeZombieContexts$lambda-8(PrivacyManager this$0, PrivacyContext it) {
        block2: {
            boolean bl;
            boolean bl2;
            Object object;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            boolean bl3 = false;
            try {
                object = Result.Companion;
                boolean bl4 = false;
                it.close();
                Unit unit = Unit.INSTANCE;
                bl2 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                bl = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            Object object2 = object;
            boolean bl5 = false;
            boolean bl6 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block2;
            Throwable throwable2 = throwable;
            bl2 = false;
            bl = false;
            Throwable throwable3 = throwable2;
            boolean bl7 = false;
            Throwable it2 = throwable3;
            boolean bl8 = false;
            this$0.logger.warn(ExceptionsKt.stringify$default((Throwable)it2, null, null, (int)3, null));
        }
    }
}

