/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.filter;

import ai.platon.pulsar.common.DomUtil;
import com.google.gson.annotations.Expose;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.collections4.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0013\u001a\u00020\u0005H\u0016R.\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR.\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\n\u00a8\u0006\u0014"}, d2={"Lai/platon/pulsar/crawl/filter/BlockFilter;", "", "()V", "allow", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "getAllow", "()Ljava/util/HashSet;", "setAllow", "(Ljava/util/HashSet;)V", "disallow", "getDisallow", "setDisallow", "isAllowed", "", "node", "Lorg/w3c/dom/Node;", "isDisallowed", "toString", "pulsar-skeleton"})
public final class BlockFilter {
    @Expose
    @NotNull
    private HashSet<String> allow = new HashSet();
    @Expose
    @NotNull
    private HashSet<String> disallow = new HashSet();

    @NotNull
    public final HashSet<String> getAllow() {
        return this.allow;
    }

    public final void setAllow(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.allow = hashSet;
    }

    @NotNull
    public final HashSet<String> getDisallow() {
        return this.disallow;
    }

    public final void setDisallow(@NotNull HashSet<String> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.disallow = hashSet;
    }

    public final boolean isDisallowed(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Set simpleSelectors = DomUtil.getSimpleSelectors((Node)node);
        Collection collection = this.disallow;
        boolean bl = false;
        return !collection.isEmpty() && CollectionUtils.containsAny((Collection)this.disallow, (Collection)simpleSelectors);
    }

    public final boolean isAllowed(@NotNull Node node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Set simpleSelectors = DomUtil.getSimpleSelectors((Node)node);
        return this.allow.isEmpty() || CollectionUtils.containsAny((Collection)this.allow, (Collection)simpleSelectors);
    }

    @NotNull
    public String toString() {
        return "\n\tallow" + this.allow + "\n\tdisallow" + this.disallow;
    }
}

