/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.filter;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.filter.ChainedUrlNormalizer;
import ai.platon.pulsar.crawl.filter.UrlNormalizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\n\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B%\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0016\u001a\u00020\tJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0019\u001a\u00020\t2\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\b\u0010\u001a\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00070\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001c"}, d2={"Lai/platon/pulsar/crawl/filter/ChainedUrlNormalizer;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "urlNormalizers", "", "Lai/platon/pulsar/crawl/filter/UrlNormalizer;", "scope", "", "(Ljava/util/List;Ljava/lang/String;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "maxLoops", "", "getScope", "()Ljava/lang/String;", "scopedUrlNormalizers", "", "getUrlNormalizers", "()Ljava/util/List;", "findByClassName", "name", "getURLNormalizers", "normalize", "url", "toString", "Companion", "pulsar-skeleton"})
public final class ChainedUrlNormalizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<UrlNormalizer> urlNormalizers;
    @NotNull
    private final String scope;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Map<String, UrlNormalizer> scopedUrlNormalizers;
    private final int maxLoops;
    @NotNull
    public static final String SCOPE_DEFAULT = "default";
    @NotNull
    public static final String SCOPE_PARTITION = "partition";
    @NotNull
    public static final String SCOPE_GENERATE_HOST_COUNT = "generate_host_count";
    @NotNull
    public static final String SCOPE_INJECT = "inject";
    @NotNull
    public static final String SCOPE_FETCHER = "fetcher";
    @NotNull
    public static final String SCOPE_CRAWLDB = "crawldb";
    @NotNull
    public static final String SCOPE_LINKDB = "linkdb";
    @NotNull
    public static final String SCOPE_INDEXER = "index";
    @NotNull
    public static final String SCOPE_OUTLINK = "outlink";

    public ChainedUrlNormalizer(@NotNull List<? extends UrlNormalizer> urlNormalizers, @NotNull String scope, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(urlNormalizers, (String)"urlNormalizers");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.urlNormalizers = urlNormalizers;
        this.scope = scope;
        this.conf = conf;
        this.scopedUrlNormalizers = new HashMap();
        this.maxLoops = this.conf.getInt("urlnormalizer.loop.count", 1);
    }

    public /* synthetic */ ChainedUrlNormalizer(List list, String string, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = SCOPE_DEFAULT;
        }
        this(list, string, immutableConfig);
    }

    @NotNull
    public final List<UrlNormalizer> getUrlNormalizers() {
        return this.urlNormalizers;
    }

    @NotNull
    public final String getScope() {
        return this.scope;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public ChainedUrlNormalizer(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        boolean bl = false;
        this(CollectionsKt.emptyList(), SCOPE_DEFAULT, conf);
    }

    @NotNull
    public final List<UrlNormalizer> getURLNormalizers(@NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.urlNormalizers;
    }

    @Nullable
    public final UrlNormalizer findByClassName(@NotNull String name) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$firstOrNull$iv = this.urlNormalizers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                UrlNormalizer it = (UrlNormalizer)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getClass().getSimpleName(), (Object)name) || Intrinsics.areEqual((Object)it.getClass().getName(), (Object)name))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @JvmOverloads
    @Nullable
    public final String normalize(@NotNull String url, @NotNull String scope) {
        String target;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        String tmp = target = url;
        int n = 0;
        int n2 = this.maxLoops;
        if (n < n2) {
            do {
                int k = n++;
                for (UrlNormalizer normalizer : this.urlNormalizers) {
                    if (target == null) {
                        return null;
                    }
                    target = normalizer.normalize(target, scope);
                }
                if (Intrinsics.areEqual((Object)tmp, (Object)target)) break;
                tmp = target;
            } while (n < n2);
        }
        return target;
    }

    public static /* synthetic */ String normalize$default(ChainedUrlNormalizer chainedUrlNormalizer, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = SCOPE_DEFAULT;
        }
        return chainedUrlNormalizer.normalize(string, string2);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.urlNormalizers, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
    }

    @JvmOverloads
    @Nullable
    public final String normalize(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return ChainedUrlNormalizer.normalize$default(this, url, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lai/platon/pulsar/crawl/filter/ChainedUrlNormalizer$Companion;", "", "()V", "SCOPE_CRAWLDB", "", "SCOPE_DEFAULT", "SCOPE_FETCHER", "SCOPE_GENERATE_HOST_COUNT", "SCOPE_INDEXER", "SCOPE_INJECT", "SCOPE_LINKDB", "SCOPE_OUTLINK", "SCOPE_PARTITION", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

