/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.filter;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.filter.ChainedUrlNormalizer;
import ai.platon.pulsar.crawl.filter.CrawlFilter;
import ai.platon.pulsar.crawl.filter.CrawlUrlFilters;
import ai.platon.pulsar.persist.HyperlinkPersistable;
import ai.platon.pulsar.persist.metadata.PageCategory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 92\u00020\u0001:\u00019B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B3\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u0010\u0010%\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$J\u000e\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(J\u000e\u0010&\u001a\u00020\"2\u0006\u0010)\u001a\u00020\rJ\u000e\u0010*\u001a\u00020\r2\u0006\u0010)\u001a\u00020\rJ\u0018\u0010*\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r2\b\b\u0002\u0010\f\u001a\u00020\rJ\u001a\u0010+\u001a\u0004\u0018\u00010\r2\u0006\u0010)\u001a\u00020\r2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0010\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020\"2\b\u0010/\u001a\u0004\u0018\u00010\rJ\u0010\u00100\u001a\u00020\"2\b\u00101\u001a\u0004\u0018\u00010\rJ\u0010\u00102\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\rJ\u0006\u00103\u001a\u00020\rJ\b\u00104\u001a\u00020\rH\u0016J\u0010\u00105\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\rJ\u0010\u00106\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\rJ\u0010\u00107\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\rJ\u0010\u00108\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0019\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001f\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006:"}, d2={"Lai/platon/pulsar/crawl/filter/CrawlFilters;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "crawlFilters", "", "Lai/platon/pulsar/crawl/filter/CrawlFilter;", "urlNormalizers", "Lai/platon/pulsar/crawl/filter/ChainedUrlNormalizer;", "urlFilters", "Lai/platon/pulsar/crawl/filter/CrawlUrlFilters;", "scope", "", "(Ljava/util/List;Lai/platon/pulsar/crawl/filter/ChainedUrlNormalizer;Lai/platon/pulsar/crawl/filter/CrawlUrlFilters;Ljava/lang/String;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getCrawlFilters", "()Ljava/util/List;", "maxReversedKeyRange", "", "getMaxReversedKeyRange", "()[Ljava/lang/String;", "reversedKeyRanges", "", "getReversedKeyRanges", "()Ljava/util/Map;", "getScope", "()Ljava/lang/String;", "getUrlFilters", "()Lai/platon/pulsar/crawl/filter/CrawlUrlFilters;", "getUrlNormalizers", "()Lai/platon/pulsar/crawl/filter/ChainedUrlNormalizer;", "isAllowed", "", "node", "Lorg/w3c/dom/Node;", "isDisallowed", "isNormalizedValid", "hyperlink", "Lai/platon/pulsar/persist/HyperlinkPersistable;", "url", "normalizeToEmpty", "normalizeToNull", "temporaryUrlFilter", "url_", "testKeyRangeSatisfied", "reversedUrl", "testTextSatisfied", "text", "testUrlSatisfied", "toJson", "toString", "veryLikelyBeDetailUrl", "veryLikelyBeIndexUrl", "veryLikelyBeMediaUrl", "veryLikelyBeSearchUrl", "Companion", "pulsar-skeleton"})
public final class CrawlFilters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<CrawlFilter> crawlFilters;
    @NotNull
    private final ChainedUrlNormalizer urlNormalizers;
    @NotNull
    private final CrawlUrlFilters urlFilters;
    @NotNull
    private final String scope;
    @NotNull
    private final ImmutableConfig conf;
    private static final Logger LOG = LoggerFactory.getLogger(CrawlFilters.class);
    @NotNull
    public static final String CRAWL_FILTER_RULES = "crawl.filter.rules";

    public CrawlFilters(@NotNull List<CrawlFilter> crawlFilters, @NotNull ChainedUrlNormalizer urlNormalizers, @NotNull CrawlUrlFilters urlFilters, @NotNull String scope, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(crawlFilters, (String)"crawlFilters");
        Intrinsics.checkNotNullParameter((Object)urlNormalizers, (String)"urlNormalizers");
        Intrinsics.checkNotNullParameter((Object)urlFilters, (String)"urlFilters");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.crawlFilters = crawlFilters;
        this.urlNormalizers = urlNormalizers;
        this.urlFilters = urlFilters;
        this.scope = scope;
        this.conf = conf;
    }

    @NotNull
    public final List<CrawlFilter> getCrawlFilters() {
        return this.crawlFilters;
    }

    @NotNull
    public final ChainedUrlNormalizer getUrlNormalizers() {
        return this.urlNormalizers;
    }

    @NotNull
    public final CrawlUrlFilters getUrlFilters() {
        return this.urlFilters;
    }

    @NotNull
    public final String getScope() {
        return this.scope;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public CrawlFilters(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        boolean bl = false;
        this(CollectionsKt.emptyList(), new ChainedUrlNormalizer(conf), new CrawlUrlFilters(conf), "default", conf);
    }

    public final boolean isNormalizedValid(@NotNull HyperlinkPersistable hyperlink) {
        Intrinsics.checkNotNullParameter((Object)hyperlink, (String)"hyperlink");
        String string = hyperlink.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"hyperlink.url");
        return this.isNormalizedValid(string);
    }

    public final boolean isNormalizedValid(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        CharSequence charSequence = this.normalizeToEmpty(url);
        boolean bl = false;
        return charSequence.length() > 0;
    }

    @NotNull
    public final String normalizeToEmpty(@NotNull String url, @NotNull String scope) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        return this.normalizeToEmpty(url);
    }

    public static /* synthetic */ String normalizeToEmpty$default(CrawlFilters crawlFilters, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "default";
        }
        return crawlFilters.normalizeToEmpty(string, string2);
    }

    @NotNull
    public final String normalizeToEmpty(@NotNull String url) {
        String normUrl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = normUrl = CrawlFilters.normalizeToNull$default(this, url, null, 2, null);
        return string == null ? "" : string;
    }

    @Nullable
    public final String normalizeToNull(@NotNull String url, @NotNull String scope) {
        String filteredUrl;
        block6: {
            block5: {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
                CharSequence charSequence = url;
                boolean bl = false;
                if (charSequence.length() == 0) {
                    return null;
                }
                filteredUrl = this.temporaryUrlFilter(url);
                if (filteredUrl == null) break block5;
                CharSequence charSequence2 = filteredUrl;
                boolean bl2 = false;
                if (!(charSequence2.length() == 0)) break block6;
            }
            return null;
        }
        if ((filteredUrl = this.urlNormalizers.normalize(filteredUrl, scope)) != null) {
            filteredUrl = this.urlFilters.filter(filteredUrl);
        }
        return filteredUrl;
    }

    public static /* synthetic */ String normalizeToNull$default(CrawlFilters crawlFilters, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "default";
        }
        return crawlFilters.normalizeToNull(string, string2);
    }

    private final String temporaryUrlFilter(String url_) {
        boolean bl;
        String url;
        block3: {
            url = null;
            url = url_;
            String[] $this$any$iv = CrawlFilter.Companion.getMEDIA_URL_SUFFIXES();
            boolean $i$f$any = false;
            String[] stringArray = $this$any$iv;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = stringArray[i];
                boolean bl2 = false;
                if (!StringsKt.endsWith$default((String)url, (String)it, (boolean)false, (int)2, null)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        if (bl) {
            url = "";
        }
        if (this.veryLikelyBeSearchUrl(url) || this.veryLikelyBeMediaUrl(url)) {
            url = "";
        }
        return url;
    }

    public final boolean testUrlSatisfied(@Nullable String url) {
        if (url == null) {
            return false;
        }
        for (CrawlFilter filter : this.crawlFilters) {
            if (filter.testUrlSatisfied(url)) continue;
            return false;
        }
        return true;
    }

    public final boolean testTextSatisfied(@Nullable String text) {
        if (text == null) {
            return false;
        }
        for (CrawlFilter filter : this.crawlFilters) {
            if (filter.testTextSatisfied(text)) continue;
            return false;
        }
        return true;
    }

    public final boolean testKeyRangeSatisfied(@Nullable String reversedUrl) {
        if (reversedUrl == null) {
            return false;
        }
        for (CrawlFilter filter : this.crawlFilters) {
            if (!filter.testKeyRangeSatisfied(reversedUrl)) continue;
            return true;
        }
        return true;
    }

    @NotNull
    public final Map<String, String> getReversedKeyRanges() {
        Map keyRanges = new HashMap();
        for (CrawlFilter filter : this.crawlFilters) {
            String reversedStartKey = filter.getReversedStartKey();
            String reversedEndKey = filter.getReversedEndKey();
            if (reversedStartKey == null) continue;
            Map map2 = keyRanges;
            boolean bl = false;
            map2.put(reversedStartKey, reversedEndKey);
        }
        return keyRanges;
    }

    @NotNull
    public final String[] getMaxReversedKeyRange() {
        String[] stringArray = new String[]{null, null};
        String[] keyRange = stringArray;
        for (CrawlFilter filter : this.crawlFilters) {
            String reversedStartKey = filter.getReversedStartKey();
            String reversedEndKey = filter.getReversedEndKey();
            if (reversedStartKey != null) {
                if (keyRange[0] == null) {
                    keyRange[0] = reversedStartKey;
                } else if (CrawlFilter.Companion.keyLessEqual(reversedStartKey, keyRange[0])) {
                    keyRange[0] = reversedStartKey;
                }
            }
            if (reversedEndKey == null) continue;
            if (keyRange[1] == null) {
                keyRange[1] = reversedEndKey;
                continue;
            }
            if (!CrawlFilter.Companion.keyGreaterEqual(reversedEndKey, keyRange[1])) continue;
            keyRange[1] = reversedEndKey;
        }
        return keyRange;
    }

    public final boolean isAllowed(@Nullable Node node) {
        if (node == null) {
            return false;
        }
        if (this.crawlFilters.isEmpty()) {
            return true;
        }
        for (CrawlFilter filter : this.crawlFilters) {
            if (!filter.isAllowed(node)) continue;
            return true;
        }
        return false;
    }

    public final boolean isDisallowed(@Nullable Node node) {
        if (node == null) {
            return true;
        }
        if (this.isAllowed(node)) {
            return false;
        }
        for (CrawlFilter filter : this.crawlFilters) {
            if (!filter.isDisallowed(node)) continue;
            return true;
        }
        return false;
    }

    public final boolean veryLikelyBeDetailUrl(@Nullable String url) {
        if (url == null) {
            return false;
        }
        PageCategory pageType = CrawlFilter.Companion.guessPageCategory(url);
        if (pageType == PageCategory.DETAIL) {
            return true;
        }
        for (CrawlFilter filter : this.crawlFilters) {
            if (!filter.isDetailUrl(url)) continue;
            return true;
        }
        return false;
    }

    public final boolean veryLikelyBeIndexUrl(@Nullable String url) {
        if (url == null) {
            return false;
        }
        PageCategory pageType = CrawlFilter.Companion.guessPageCategory(url);
        if (pageType.isIndex()) {
            return true;
        }
        for (CrawlFilter filter : this.crawlFilters) {
            if (!filter.isIndexUrl(url)) continue;
            return true;
        }
        return false;
    }

    public final boolean veryLikelyBeMediaUrl(@Nullable String url) {
        if (url == null) {
            return false;
        }
        PageCategory pageType = CrawlFilter.Companion.guessPageCategory(url);
        if (pageType == PageCategory.MEDIA) {
            return true;
        }
        for (CrawlFilter filter : this.crawlFilters) {
            if (!filter.isMediaUrl(url)) continue;
            return true;
        }
        return false;
    }

    public final boolean veryLikelyBeSearchUrl(@Nullable String url) {
        if (url == null) {
            return false;
        }
        PageCategory pageType = CrawlFilter.Companion.guessPageCategory(url);
        if (pageType == PageCategory.SEARCH) {
            return true;
        }
        for (CrawlFilter filter : this.crawlFilters) {
            if (!filter.isSearchUrl(url)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public final String toJson() {
        Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
        String string = gson.toJson((Object)this);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(this)");
        return string;
    }

    @NotNull
    public String toString() {
        return this.toJson();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lai/platon/pulsar/crawl/filter/CrawlFilters$Companion;", "", "()V", "CRAWL_FILTER_RULES", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

