/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.filter;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.filter.CrawlUrlFilter;
import ai.platon.pulsar.crawl.filter.CrawlUrlFilters;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0013H\u0016R\u0019\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/crawl/filter/CrawlUrlFilters;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "urlFilters", "", "Lai/platon/pulsar/crawl/filter/CrawlUrlFilter;", "(Ljava/util/List;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getUrlFilters", "()Ljava/util/List;", "filter", "", "url", "toString", "pulsar-skeleton"})
public final class CrawlUrlFilters {
    @NotNull
    private final List<CrawlUrlFilter> urlFilters;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger LOG;

    public CrawlUrlFilters(@NotNull List<? extends CrawlUrlFilter> urlFilters, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(urlFilters, (String)"urlFilters");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.urlFilters = urlFilters;
        this.conf = conf;
        this.LOG = LoggerFactory.getLogger(CrawlUrlFilters.class);
    }

    @NotNull
    public final List<CrawlUrlFilter> getUrlFilters() {
        return this.urlFilters;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public final Logger getLOG() {
        return this.LOG;
    }

    public CrawlUrlFilters(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        boolean bl = false;
        this(CollectionsKt.emptyList(), conf);
    }

    @Nullable
    public final String filter(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String u = url;
        for (CrawlUrlFilter urlFilter : this.urlFilters) {
            if (u == null || (u = urlFilter.filter(u)) != null) continue;
            this.LOG.debug("Url is deleted by {} | {}", (Object)urlFilter.getClass().getSimpleName(), (Object)url);
            break;
        }
        return u;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.urlFilters, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
    }
}

