/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.impl;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.event.AbstractEventEmitter;
import ai.platon.pulsar.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.context.PulsarContexts;
import ai.platon.pulsar.crawl.CrawlEvent;
import ai.platon.pulsar.crawl.Crawler;
import ai.platon.pulsar.crawl.PageEvent;
import ai.platon.pulsar.crawl.common.url.ListenableUrl;
import ai.platon.pulsar.crawl.event.UrlAwareWebPageEventHandler;
import ai.platon.pulsar.crawl.impl.AbstractCrawler;
import ai.platon.pulsar.crawl.impl.CrawlEvents;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.session.PulsarSession;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 ,2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001,B\u0019\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\"\u001a\u00020#H\u0002J\b\u0010$\u001a\u00020#H\u0016J\b\u0010%\u001a\u00020#H\u0002J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u001aH\u0016J\u001a\u0010(\u001a\u00020#2\u0006\u0010'\u001a\u00020\u001a2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010+\u001a\u00020#2\u0006\u0010'\u001a\u00020\u001aH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R.\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u001b0\u0019X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006-"}, d2={"Lai/platon/pulsar/crawl/impl/AbstractCrawler;", "Lai/platon/pulsar/crawl/Crawler;", "Lai/platon/pulsar/common/event/AbstractEventEmitter;", "Lai/platon/pulsar/crawl/impl/CrawlEvents;", "session", "Lai/platon/pulsar/session/PulsarSession;", "autoClose", "", "(Lai/platon/pulsar/session/PulsarSession;Z)V", "getAutoClose", "()Z", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "id", "", "getId", "()I", "isActive", "name", "", "getName", "()Ljava/lang/String;", "retryDelayPolicy", "Lkotlin/Function2;", "Lai/platon/pulsar/common/urls/UrlAware;", "Ljava/time/Duration;", "getRetryDelayPolicy", "()Lkotlin/jvm/functions/Function2;", "setRetryDelayPolicy", "(Lkotlin/jvm/functions/Function2;)V", "getSession", "()Lai/platon/pulsar/session/PulsarSession;", "attach", "", "close", "detach", "onLoad", "url", "onLoaded", "page", "Lai/platon/pulsar/persist/WebPage;", "onWillLoad", "Companion", "pulsar-skeleton"})
public abstract class AbstractCrawler
extends AbstractEventEmitter<CrawlEvents>
implements Crawler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PulsarSession session;
    private final boolean autoClose;
    private final int id;
    @NotNull
    private Function2<? super Integer, ? super UrlAware, Duration> retryDelayPolicy;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private static final AtomicInteger instanceSequencer = new AtomicInteger();

    public AbstractCrawler(@NotNull PulsarSession session, boolean autoClose) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.autoClose = autoClose;
        this.id = instanceSequencer.incrementAndGet();
        this.retryDelayPolicy = retryDelayPolicy.1.INSTANCE;
        this.closed = new AtomicBoolean();
        this.attach();
    }

    public /* synthetic */ AbstractCrawler(PulsarSession pulsarSession, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pulsarSession = PulsarContexts.createSession();
        }
        if ((n & 2) != 0) {
            bl = true;
        }
        this(pulsarSession, bl);
    }

    @NotNull
    public final PulsarSession getSession() {
        return this.session;
    }

    public final boolean getAutoClose() {
        return this.autoClose;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.simpleName");
        return string;
    }

    @Override
    @NotNull
    public Function2<Integer, UrlAware, Duration> getRetryDelayPolicy() {
        return this.retryDelayPolicy;
    }

    @Override
    public void setRetryDelayPolicy(@NotNull Function2<? super Integer, ? super UrlAware, Duration> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.retryDelayPolicy = function2;
    }

    @NotNull
    public final AtomicBoolean getClosed() {
        return this.closed;
    }

    public boolean isActive() {
        return !this.closed.get() && AppContext.INSTANCE.isActive();
    }

    @Override
    public void onWillLoad(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (url instanceof ListenableUrl) {
            ((ListenableUrl)url).getEvent().getCrawlEvent().getOnWillLoad().invoke(url);
        }
    }

    @Override
    public void onLoad(@NotNull UrlAware url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (url instanceof ListenableUrl) {
            ((ListenableUrl)url).getEvent().getCrawlEvent().getOnLoad().invoke(url);
        }
    }

    @Override
    public void onLoaded(@NotNull UrlAware url, @Nullable WebPage page) {
        UrlAwareWebPageEventHandler urlAwareWebPageEventHandler;
        CrawlEvent crawlEvent;
        PageEvent pageEvent;
        WebPage webPage;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (url instanceof ListenableUrl) {
            ((ListenableUrl)url).getEvent().getCrawlEvent().getOnLoaded().invoke(url, page);
        }
        if ((webPage = page) != null && (pageEvent = WebPageExKt.getEvent(webPage)) != null && (crawlEvent = pageEvent.getCrawlEvent()) != null && (urlAwareWebPageEventHandler = crawlEvent.getOnLoaded()) != null) {
            urlAwareWebPageEventHandler.invoke(url, page);
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.detach();
            if (this.autoClose) {
                this.session.close();
            }
        }
    }

    private final void attach() {
        this.on((Object)CrawlEvents.willLoad, (Function1)new Function1<UrlAware, Unit>(this){
            final /* synthetic */ AbstractCrawler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull UrlAware url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                this.this$0.onWillLoad(url);
            }
        });
        this.on((Object)CrawlEvents.load, (Function1)new Function1<UrlAware, Unit>(this){
            final /* synthetic */ AbstractCrawler this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull UrlAware url) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                this.this$0.onLoad(url);
            }
        });
        this.on((Object)CrawlEvents.loaded, (Function2)new Function2<UrlAware, WebPage, Unit>(this){
            final /* synthetic */ AbstractCrawler this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull UrlAware url, @Nullable WebPage page) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                this.this$0.onLoaded(url, page);
            }
        });
    }

    private final void detach() {
        this.off((Object)CrawlEvents.willLoad);
        this.off((Object)CrawlEvents.load);
        this.off((Object)CrawlEvents.loaded);
    }

    public AbstractCrawler() {
        this(null, false, 3, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/crawl/impl/AbstractCrawler$Companion;", "", "()V", "instanceSequencer", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

