/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.impl;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.AppPaths;
import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.FileCommand;
import ai.platon.pulsar.common.FlowState;
import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.common.IllegalApplicationContextStateException;
import ai.platon.pulsar.common.LangKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.Strings;
import ai.platon.pulsar.common.collect.ConcurrentLoadingIterable;
import ai.platon.pulsar.common.collect.DelayUrl;
import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.measure.ByteUnit;
import ai.platon.pulsar.common.measure.ByteUnitConverter;
import ai.platon.pulsar.common.message.LoadStatusFormatter;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.metrics.MultiMetric;
import ai.platon.pulsar.common.options.LoadOptions;
import ai.platon.pulsar.common.proxy.ProxyEntry;
import ai.platon.pulsar.common.proxy.ProxyException;
import ai.platon.pulsar.common.proxy.ProxyInsufficientBalanceException;
import ai.platon.pulsar.common.proxy.ProxyPool;
import ai.platon.pulsar.common.proxy.ProxyVendorUntrustedException;
import ai.platon.pulsar.common.urls.DegenerateUrl;
import ai.platon.pulsar.common.urls.UrlAware;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.context.PulsarContexts;
import ai.platon.pulsar.crawl.common.GlobalCache;
import ai.platon.pulsar.crawl.common.url.ListenableUrl;
import ai.platon.pulsar.crawl.fetch.privacy.PrivacyContext;
import ai.platon.pulsar.crawl.impl.AbstractCrawler;
import ai.platon.pulsar.crawl.impl.CrawlEvents;
import ai.platon.pulsar.crawl.impl.CriticalWarning;
import ai.platon.pulsar.crawl.impl.StreamingCrawler;
import ai.platon.pulsar.crawl.impl.StreamingCrawlerMetrics;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.session.PulsarSession;
import com.codahale.metrics.Gauge;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 \u0080\u00012\u00020\u0001:\u0002\u0080\u0001B1\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010X\u001a\u00020YH\u0016J\u0019\u0010Z\u001a\u00020Y2\u0006\u0010[\u001a\u00020\u0019H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\\J\b\u0010]\u001a\u00020YH\u0016J\u0010\u0010^\u001a\u00020Y2\u0006\u0010_\u001a\u00020`H\u0002J \u0010a\u001a\u00020\b2\u0006\u0010b\u001a\u00020&2\u0006\u0010c\u001a\u00020\u00042\u0006\u0010d\u001a\u00020\u001dH\u0002J\u0018\u0010e\u001a\u00020Y2\u0006\u0010c\u001a\u00020\u00042\u0006\u0010d\u001a\u00020\u001dH\u0002J\b\u0010f\u001a\u00020YH\u0002J\b\u0010g\u001a\u00020YH\u0002J\u0011\u0010h\u001a\u00020YH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ\u0018\u0010j\u001a\u00020\"2\u0006\u0010c\u001a\u00020\u00042\u0006\u0010k\u001a\u00020lH\u0002J\u0010\u0010m\u001a\u00020Y2\u0006\u0010n\u001a\u00020\u0019H\u0002J\u0011\u0010o\u001a\u00020YH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ\b\u0010p\u001a\u00020YH\u0002J\u001a\u0010q\u001a\u00020Y2\u0006\u0010c\u001a\u00020\u00042\b\u0010_\u001a\u0004\u0018\u00010`H\u0002J\u001a\u0010r\u001a\u00020Y2\u0006\u0010c\u001a\u00020\u00042\b\u0010_\u001a\u0004\u0018\u00010`H\u0002J\u0011\u0010s\u001a\u00020YH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010iJ\u001b\u0010t\u001a\u0004\u0018\u00010`2\u0006\u0010c\u001a\u00020\u0004H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010uJ\u001b\u0010v\u001a\u0004\u0018\u00010`2\u0006\u0010c\u001a\u00020\u0004H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010uJ\u0006\u0010w\u001a\u00020YJ\b\u0010x\u001a\u00020YH\u0016J\u0019\u0010x\u001a\u00020Y2\u0006\u0010y\u001a\u00020zH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010{J\u0019\u0010|\u001a\u00020Y2\u0006\u0010c\u001a\u00020\u0004H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010uJ)\u0010}\u001a\u00020\"2\u0006\u0010n\u001a\u00020\u00192\u0006\u0010c\u001a\u00020\u00042\u0006\u0010y\u001a\u00020zH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010~J\u0019\u0010\u007f\u001a\u00020Y2\u0006\u0010y\u001a\u00020zH\u0084@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010{R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010$\u001a\u001e\u0012\u0004\u0012\u00020&\u0012\u0014\u0012\u0012\u0012\u000e\b\u0001\u0012\n \u001e*\u0004\u0018\u00010(0(0'0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0019\u0010-\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010 R\u0014\u0010/\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0017R\u0014\u00100\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0017R\u0011\u00101\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0017R\u001a\u00102\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u0016\u00107\u001a\n \u001e*\u0004\u0018\u00010808X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010;\u001a\n \u001e*\u0004\u0018\u00010<0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010\u0017R\u0016\u0010A\u001a\n \u001e*\u0004\u0018\u00010B0BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010C\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u001bR\u0011\u0010E\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u001bR\u0019\u0010G\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010 R\u000e\u0010I\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010L\u001a\n \u001e*\u0004\u0018\u00010<0<X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010M\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bN\u0010\u000eR\u0014\u0010O\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bP\u0010\u0012R\u0016\u0010Q\u001a\u0004\u0018\u00010<8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010W\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0081\u0001"}, d2={"Lai/platon/pulsar/crawl/impl/StreamingCrawler;", "Lai/platon/pulsar/crawl/impl/AbstractCrawler;", "urls", "Lkotlin/sequences/Sequence;", "Lai/platon/pulsar/common/urls/UrlAware;", "session", "Lai/platon/pulsar/session/PulsarSession;", "noProxy", "", "autoClose", "(Lkotlin/sequences/Sequence;Lai/platon/pulsar/session/PulsarSession;ZZ)V", "availableMemory", "", "getAvailableMemory", "()J", "availableMemoryGiB", "", "getAvailableMemoryGiB", "()D", "conf", "Lai/platon/pulsar/common/config/VolatileConfig;", "enableSmartRetry", "getEnableSmartRetry", "()Z", "fetchConcurrency", "", "getFetchConcurrency", "()I", "fetchTaskTimeout", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getFetchTaskTimeout", "()Ljava/time/Duration;", "flowState", "Lai/platon/pulsar/common/FlowState;", "forceQuit", "gauges", "", "", "Lcom/codahale/metrics/Gauge;", "", "globalCache", "Lai/platon/pulsar/crawl/common/GlobalCache;", "getGlobalCache", "()Lai/platon/pulsar/crawl/common/GlobalCache;", "idleTime", "getIdleTime", "isActive", "isIdle", "isOutOfWork", "jobName", "getJobName", "()Ljava/lang/String;", "setJobName", "(Ljava/lang/String;)V", "lastActiveTime", "Ljava/time/Instant;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "logger", "Lorg/slf4j/Logger;", "memoryToReserve", "memoryToReserveLarge", "getMemoryToReserveLarge", "getNoProxy", "notBusy", "Ljava/util/concurrent/locks/Condition;", "numMaxActiveTabs", "getNumMaxActiveTabs", "numPrivacyContexts", "getNumPrivacyContexts", "outOfWorkTimeout", "getOutOfWorkTimeout", "proxyOutOfService", "proxyPool", "Lai/platon/pulsar/common/proxy/ProxyPool;", "taskLogger", "totalMemory", "getTotalMemory", "totalMemoryGiB", "getTotalMemoryGiB", "tracer", "getTracer", "()Lorg/slf4j/Logger;", "getUrls", "()Lkotlin/sequences/Sequence;", "setUrls", "(Lkotlin/sequences/Sequence;)V", "await", "", "checkEmptyUrlSequence", "idleSeconds", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "collectStatAfterLoad", "page", "Lai/platon/pulsar/persist/WebPage;", "doLaterIfProcessing", "urlSpec", "url", "delay", "fetchDelayed", "generateFinishCommand", "generateFinishCommandUnix", "handleContextLeaks", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleException", "e", "", "handleMemoryShortage", "j", "handleProxyOutOfService", "handleProxyOutOfService0", "handleRetry", "handleRetry0", "handleWrongDistrict", "loadWithMinorExceptionHandled", "(Lai/platon/pulsar/common/urls/UrlAware;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "loadWithTimeout", "quit", "run", "scope", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runLoadTask", "runWithStatusCheck", "(ILai/platon/pulsar/common/urls/UrlAware;Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "startCrawlLoop", "Companion", "pulsar-skeleton"})
public class StreamingCrawler
extends AbstractCrawler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Sequence<? extends UrlAware> urls;
    private final boolean noProxy;
    private final Logger logger;
    private final Logger taskLogger;
    @NotNull
    private final VolatileConfig conf;
    private final double memoryToReserve;
    @Nullable
    private final ProxyPool proxyPool;
    private int proxyOutOfService;
    private final Duration outOfWorkTimeout;
    private Instant lastActiveTime;
    @NotNull
    private final ReentrantLock lock;
    private final Condition notBusy;
    private boolean forceQuit;
    @NotNull
    private volatile FlowState flowState;
    @NotNull
    private String jobName;
    @NotNull
    private final Map<String, Gauge<? extends Object>> gauges;
    @NotNull
    private static final AtomicInteger globalRunningInstances = new AtomicInteger();
    @NotNull
    private static final AtomicInteger globalRunningTasks = new AtomicInteger();
    @NotNull
    private static final AtomicInteger globalKilledTasks = new AtomicInteger();
    @NotNull
    private static final AtomicInteger globalTasks = new AtomicInteger();
    @NotNull
    private static final StreamingCrawlerMetrics globalMetrics = new StreamingCrawlerMetrics();
    @NotNull
    private static final ConcurrentSkipListSet<String> globalLoadingUrls = new ConcurrentSkipListSet();
    private static Duration contextLeakWaitingTime = Duration.ZERO;
    private static Duration proxyVendorWaitingTime = Duration.ZERO;
    @Nullable
    private static CriticalWarning criticalWarning;
    @NotNull
    private static String lastUrl;
    @NotNull
    private static String lastHtmlIntegrity;
    @NotNull
    private static String lastFetchError;
    @NotNull
    private static final AtomicBoolean isIllegalApplicationState;
    @NotNull
    private static MultiMetric wrongDistrict;

    public StreamingCrawler(@NotNull Sequence<? extends UrlAware> urls, @NotNull PulsarSession session, boolean noProxy, boolean autoClose) {
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(session, autoClose);
        this.urls = urls;
        this.noProxy = noProxy;
        this.logger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(StreamingCrawler.class));
        this.taskLogger = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(StreamingCrawler.class), (String)".Task");
        this.conf = session.getSessionConfig();
        this.memoryToReserve = this.getTotalMemoryGiB() >= 14.0 ? ByteUnit.GIB.toBytes(3.0) : (this.getTotalMemoryGiB() >= 30.0 ? this.getMemoryToReserveLarge() : AppConstants.BROWSER_TAB_REQUIRED_MEMORY);
        this.proxyPool = this.noProxy ? null : (ProxyPool)session.getContext().getBeanOrNull(Reflection.getOrCreateKotlinClass(ProxyPool.class));
        this.outOfWorkTimeout = Duration.ofMinutes(10L);
        this.lastActiveTime = Instant.now();
        this.lock = new ReentrantLock();
        this.notBusy = this.lock.newCondition();
        this.flowState = FlowState.CONTINUE;
        this.jobName = "crawler-" + RandomStringUtils.randomAlphanumeric((int)5);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"idleTime", () -> StreamingCrawler.gauges$lambda-1(this)), TuplesKt.to((Object)"numPrivacyContexts", () -> StreamingCrawler.gauges$lambda-2(this)), TuplesKt.to((Object)"numMaxActiveTabs", () -> StreamingCrawler.gauges$lambda-3(this)), TuplesKt.to((Object)"fetchConcurrency", () -> StreamingCrawler.gauges$lambda-4(this))};
        this.gauges = MapsKt.mapOf((Pair[])pairArray);
        AppMetrics.Companion.getReg().registerAll(this, this.getId() + ".g", this.gauges);
        if (this.getGlobalCache() != null) {
            Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)"pageCacheSize", () -> StreamingCrawler._init_$lambda-5(this)), TuplesKt.to((Object)"documentCacheSize", () -> StreamingCrawler._init_$lambda-6(this))};
            Map cacheGauges = MapsKt.mapOf((Pair[])pairArray2);
            AppMetrics.Companion.getReg().registerAll(this, this.getId() + ".g", cacheGauges);
        }
        this.generateFinishCommand();
    }

    public /* synthetic */ StreamingCrawler(Sequence sequence, PulsarSession pulsarSession, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            pulsarSession = PulsarContexts.createSession();
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = true;
        }
        this((Sequence<? extends UrlAware>)sequence, pulsarSession, bl, bl2);
    }

    @NotNull
    public final Sequence<UrlAware> getUrls() {
        return this.urls;
    }

    public final void setUrls(@NotNull Sequence<? extends UrlAware> sequence) {
        Intrinsics.checkNotNullParameter(sequence, (String)"<set-?>");
        this.urls = sequence;
    }

    public final boolean getNoProxy() {
        return this.noProxy;
    }

    private final Logger getTracer() {
        Logger logger = this.logger;
        boolean bl = false;
        boolean bl2 = false;
        Logger it = logger;
        boolean bl3 = false;
        return it.isTraceEnabled() ? logger : null;
    }

    public final int getNumPrivacyContexts() {
        return this.conf.getInt("privacy.context.number", 2);
    }

    public final int getNumMaxActiveTabs() {
        return this.conf.getInt("browser.max.active.tabs", AppContext.INSTANCE.getNCPU());
    }

    public final int getFetchConcurrency() {
        return this.getNumPrivacyContexts() * this.getNumMaxActiveTabs();
    }

    private final long getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    private final double getTotalMemoryGiB() {
        return ByteUnit.BYTE.toGiB((double)this.getTotalMemory());
    }

    private final long getAvailableMemory() {
        return AppMetrics.Companion.getAvailableMemory();
    }

    private final double getAvailableMemoryGiB() {
        return ByteUnit.BYTE.toGiB((double)this.getAvailableMemory());
    }

    private final double getMemoryToReserveLarge() {
        return this.conf.getDouble("browser.memory.to.reserve", AppConstants.DEFAULT_BROWSER_RESERVED_MEMORY);
    }

    private final GlobalCache getGlobalCache() {
        return this.getSession().getGlobalCache();
    }

    public final Duration getOutOfWorkTimeout() {
        return this.outOfWorkTimeout;
    }

    public final Duration getFetchTaskTimeout() {
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(10)");
        return this.conf.getDuration("fetch.task.timeout", duration);
    }

    public final Duration getIdleTime() {
        return Duration.between(this.lastActiveTime, Instant.now());
    }

    public final boolean isOutOfWork() {
        return this.getIdleTime().compareTo(this.outOfWorkTimeout) > 0;
    }

    private final boolean getEnableSmartRetry() {
        return this.conf.getBoolean("crawl.smart.retry", true);
    }

    private final boolean isIdle() {
        return !this.urls.iterator().hasNext() && globalLoadingUrls.isEmpty() && this.getIdleTime().compareTo(Duration.ofSeconds(5L)) > 0;
    }

    @Override
    public boolean isActive() {
        return super.isActive() && !this.forceQuit && !isIllegalApplicationState.get();
    }

    @NotNull
    public final String getJobName() {
        return this.jobName;
    }

    public final void setJobName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.jobName = string;
    }

    public void run() {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StreamingCrawler this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = SupervisorKt.supervisorScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ StreamingCrawler this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$supervisorScope = (CoroutineScope)this.L$0;
                                        this.label = 1;
                                        Object object3 = this.this$0.run($this$supervisorScope, (Continuation<? super Unit>)((Continuation)this));
                                        if (object3 != object2) return Unit.INSTANCE;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Nullable
    public Object run(@NotNull CoroutineScope scope, @NotNull Continuation<? super Unit> $completion) {
        return StreamingCrawler.run$suspendImpl(this, scope, $completion);
    }

    static /* synthetic */ Object run$suspendImpl(StreamingCrawler this_, CoroutineScope scope, Continuation $completion) {
        Object object = this_.startCrawlLoop(scope, (Continuation<? super Unit>)$completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() {
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            this.notBusy.await();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void quit() {
        this.forceQuit = true;
    }

    @Override
    public void close() {
        this.quit();
        super.close();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected final Object startCrawlLoop(@NotNull CoroutineScope var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof startCrawlLoop.1)) ** GOTO lbl-1000
        var30_3 = var2_2;
        if ((var30_3.label & -2147483648) != 0) {
            var30_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingCrawler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.startCrawlLoop(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var31_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.logger.info("Starting {} #{} ...", (Object)this.getName(), (Object)Boxing.boxInt((int)this.getId()));
                StreamingCrawler.globalRunningInstances.incrementAndGet();
                startTime = Instant.now();
                idleSeconds = new Ref.IntRef();
lbl17:
                // 2 sources

                while (this.isActive()) {
                    ++idleSeconds.element;
                    $continuation.L$0 = this;
                    $continuation.L$1 = scope;
                    $continuation.L$2 = startTime;
                    $continuation.L$3 = idleSeconds;
                    $continuation.L$4 = null;
                    $continuation.label = 1;
                    v0 = this.checkEmptyUrlSequence(idleSeconds.element, (Continuation<? super Unit>)$continuation);
                    if (v0 == var31_5) {
                        return var31_5;
                    }
                    ** GOTO lbl37
                }
                break;
            }
            case 1: {
                idleSeconds = (Ref.IntRef)$continuation.L$3;
                startTime = (Instant)$continuation.L$2;
                scope = (CoroutineScope)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl37:
                // 2 sources

                $this$forEachIndexed$iv = this.getUrls();
                $i$f$forEachIndexed = false;
                index$iv = 0;
                var8_11 = $this$forEachIndexed$iv.iterator();
lbl41:
                // 5 sources

                while (var8_11.hasNext()) {
                    item$iv = var8_11.next();
                    var10_13 = index$iv++;
                    var11_14 = false;
                    if (var10_13 < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    var12_15 = (UrlAware)item$iv;
                    j = var10_13;
                    $i$a$-forEachIndexed-StreamingCrawler$startCrawlLoop$2 = false;
                    idleSeconds.element = 0;
                    StreamingCrawler.globalTasks.incrementAndGet();
                    if (!this.isActive()) {
                        StreamingCrawler.globalMetrics.getDrops().mark();
                        return Unit.INSTANCE;
                    }
                    var15_18 = this.getTracer();
                    if (var15_18 != null) {
                        var16_19 = new Object[]{StreamingCrawler.globalTasks, Boxing.boxInt((int)StreamingCrawler.globalLoadingUrls.size()), StreamingCrawler.globalRunningTasks, url.getConfiguredUrl()};
                        var15_18.trace("{}. {}/{} running tasks, processing {}", var16_19);
                    }
                    var17_20 = AppMetrics.Companion.getFreeSpace();
                    var18_21 = false;
                    var19_23 = var17_20.iterator();
                    if (!var19_23.hasNext()) {
                        v1 = null;
                    } else {
                        it = ((Number)var19_23.next()).longValue();
                        $i$a$-maxOfOrNull-StreamingCrawler$startCrawlLoop$2$freeSpace$1 = false;
                        var20_24 = ByteUnitConverter.INSTANCE.convert(it, "G");
                        while (var19_23.hasNext()) {
                            it = ((Number)var19_23.next()).longValue();
                            $i$a$-maxOfOrNull-StreamingCrawler$startCrawlLoop$2$freeSpace$1 = false;
                            var23_27 = ByteUnitConverter.INSTANCE.convert(it, "G");
                            var25_29 = false;
                            var20_24 = Math.max(var20_24, var23_27);
                        }
                        v1 = Boxing.boxDouble((double)var20_24);
                    }
                    var26_30 = v1;
                    v2 = freeSpace = var26_30 == null ? 0.0 : var26_30;
                    if (freeSpace < 10.0) {
                        this.logger.error("Disk space is full!");
                        StreamingCrawler.criticalWarning = CriticalWarning.OUT_OF_DISK_STORAGE;
                        return Unit.INSTANCE;
                    }
                    if (url.isNil()) {
                        StreamingCrawler.globalMetrics.getDrops().mark();
                        continue;
                    }
                    urlSpec = (String)UrlUtils.splitUrlArgs((String)url.getUrl()).getFirst();
                    if (LangKt.alwaysFalse()) {
                        var17_20 = Duration.ofSeconds(10L);
                        Intrinsics.checkNotNullExpressionValue((Object)var17_20, (String)"ofSeconds(10)");
                        if (this.doLaterIfProcessing(urlSpec, (UrlAware)url, (Duration)var17_20)) continue;
                    }
                    StreamingCrawler.globalLoadingUrls.add(urlSpec);
                    $continuation.L$0 = this;
                    $continuation.L$1 = scope;
                    $continuation.L$2 = startTime;
                    $continuation.L$3 = idleSeconds;
                    $continuation.L$4 = var8_11;
                    $continuation.I$0 = index$iv;
                    $continuation.label = 2;
                    v3 = this.runWithStatusCheck(1 + j, (UrlAware)url, scope, (Continuation<? super FlowState>)$continuation);
                    if (v3 == var31_5) {
                        return var31_5;
                    }
                    ** GOTO lbl117
                }
                ** GOTO lbl17
            }
            case 2: {
                $i$f$forEachIndexed = false;
                $i$a$-forEachIndexed-StreamingCrawler$startCrawlLoop$2 = false;
                index$iv = $continuation.I$0;
                var8_11 = (Iterator)$continuation.L$4;
                idleSeconds = (Ref.IntRef)$continuation.L$3;
                startTime = (Instant)$continuation.L$2;
                scope = (CoroutineScope)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl117:
                // 2 sources

                if ((state = (FlowState)v3) != FlowState.CONTINUE) {
                    return Unit.INSTANCE;
                }
                var19_23 = this.getUrls().iterator();
                v4 = var18_22 = var19_23 instanceof ConcurrentLoadingIterable.LoadingIterator != false ? (ConcurrentLoadingIterable.LoadingIterator)var19_23 : null;
                if (var18_22 == null) ** GOTO lbl41
                var18_22.tryLoad();
                ** GOTO lbl41
            }
        }
        StreamingCrawler.globalRunningInstances.decrementAndGet();
        var5_8 = new Object[3];
        var5_8[0] = Boxing.boxLong((long)StreamingCrawler.globalMetrics.getTasks().getCounter().getCount());
        var5_8[1] = this.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)startTime, (String)"startTime");
        var5_8[2] = DateTimesKt.readable((Duration)DateTimes.elapsedTime$default((DateTimes)DateTimes.INSTANCE, (Instant)startTime, null, (int)2, null));
        this.logger.info("All done. Total {} tasks are processed in session {} in {}", var5_8);
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private final Object checkEmptyUrlSequence(int var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof checkEmptyUrlSequence.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingCrawler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StreamingCrawler.access$checkEmptyUrlSequence(this.this$0, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (this.getUrls().iterator().hasNext()) {
                    return Unit.INSTANCE;
                }
                v0 = idleSeconds < 1000 ? 120 : (reportPeriod = idleSeconds < 10000 ? 300 : 6000);
                if (idleSeconds % reportPeriod == false) {
                    this.logger.debug("The url sequence is empty. {} {}", (Object)Boxing.boxInt((int)StreamingCrawler.globalLoadingUrls.size()), (Object)this.getIdleTime());
                }
                $continuation.L$0 = this;
                $continuation.label = 1;
                v1 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                if (v1 == var10_5) {
                    return var10_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl27:
                // 2 sources

                if (this.isIdle()) {
                    var4_7 = this.lock;
                    var5_8 = false;
                    var6_9 = false;
                    var4_7.lock();
                    try {
                        $i$a$-withLock-StreamingCrawler$checkEmptyUrlSequence$2 = false;
                        this.notBusy.signalAll();
                        var6_10 = Unit.INSTANCE;
                    }
                    finally {
                        var4_7.unlock();
                    }
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object runWithStatusCheck(int var1_1, UrlAware var2_2, CoroutineScope var3_3, Continuation<? super FlowState> var4_4) {
        if (!(var4_4 instanceof runWithStatusCheck.1)) ** GOTO lbl-1000
        var12_5 = var4_4;
        if ((var12_5.label & -2147483648) != 0) {
            var12_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_4){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingCrawler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StreamingCrawler.access$runWithStatusCheck(this.this$0, 0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var13_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.lastActiveTime = Instant.now();
lbl13:
                // 3 sources

                while (this.isActive() && StreamingCrawler.globalRunningTasks.get() >= this.getFetchConcurrency()) {
                    if (j % 120 == 0) {
                        v0 = j + ". Long time to run " + StreamingCrawler.globalRunningTasks + " tasks | " + this.lastActiveTime + " -> {}";
                        var5_8 = this.getIdleTime();
                        Intrinsics.checkNotNullExpressionValue((Object)var5_8, (String)"idleTime");
                        this.logger.info(v0, (Object)DateTimesKt.readable((Duration)var5_8));
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = url;
                    $continuation.L$2 = scope;
                    $continuation.I$0 = j;
                    $continuation.label = 1;
                    v1 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                    if (v1 != var13_7) continue;
                    return var13_7;
                }
                break;
            }
            case 1: {
                j = $continuation.I$0;
                scope = (CoroutineScope)$continuation.L$2;
                url = (UrlAware)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl13
            }
        }
        k = 0;
lbl37:
        // 3 sources

        while (this.isActive() && (double)this.getAvailableMemory() < this.memoryToReserve) {
            var6_10 = k;
            k = var6_10 + 1;
            if (var6_10 % 20 == 0) {
                this.handleMemoryShortage(k);
            }
            StreamingCrawler.criticalWarning = CriticalWarning.OUT_OF_MEMORY;
            $continuation.L$0 = this;
            $continuation.L$1 = url;
            $continuation.L$2 = scope;
            $continuation.I$0 = k;
            $continuation.label = 2;
            v2 = DelayKt.delay((long)1000L, (Continuation)$continuation);
            if (v2 != var13_7) continue;
            return var13_7;
        }
        {
            break;
            case 2: {
                k = $continuation.I$0;
                scope = (CoroutineScope)$continuation.L$2;
                url = (UrlAware)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
                ** GOTO lbl37
            }
        }
        contextLeaksRate = PrivacyContext.Companion.getGlobalMetrics().getContextLeaks().getMeter().getFifteenMinuteRate();
        if (this.isActive() && contextLeaksRate >= 0.0833333358168602) {
            StreamingCrawler.criticalWarning = CriticalWarning.FAST_CONTEXT_LEAK;
            $continuation.L$0 = this;
            $continuation.L$1 = url;
            $continuation.L$2 = scope;
            $continuation.label = 3;
            v3 = this.handleContextLeaks((Continuation<? super Unit>)$continuation);
            if (v3 == var13_7) {
                return var13_7;
            }
        }
        ** GOTO lbl79
        {
            case 3: {
                scope = (CoroutineScope)$continuation.L$2;
                url = (UrlAware)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl79:
                // 2 sources

                if (this.isActive() && StreamingCrawler.wrongDistrict.getHourlyCounter().getCount() > 60L) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = url;
                    $continuation.L$2 = scope;
                    $continuation.label = 4;
                    v4 = this.handleWrongDistrict((Continuation<? super Unit>)$continuation);
                    if (v4 == var13_7) {
                        return var13_7;
                    }
                }
                ** GOTO lbl94
            }
            case 4: {
                scope = (CoroutineScope)$continuation.L$2;
                url = (UrlAware)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl94:
                // 2 sources

                if (this.isActive() && this.proxyOutOfService > 0) {
                    StreamingCrawler.criticalWarning = CriticalWarning.NO_PROXY;
                    $continuation.L$0 = this;
                    $continuation.L$1 = url;
                    $continuation.L$2 = scope;
                    $continuation.label = 5;
                    v5 = this.handleProxyOutOfService((Continuation<? super Unit>)$continuation);
                    if (v5 == var13_7) {
                        return var13_7;
                    }
                }
                ** GOTO lbl111
            }
            case 5: {
                scope = (CoroutineScope)$continuation.L$2;
                url = (UrlAware)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl111:
                // 2 sources

                if (this.isActive() && FileCommand.check$default((FileCommand)FileCommand.INSTANCE, (String)"finish-job", null, null, (int)6, null)) {
                    this.logger.info("Find finish-job command, quit streaming crawler ...");
                    this.flowState = FlowState.BREAK;
                    return this.flowState;
                }
                if (!this.isActive()) {
                    this.flowState = FlowState.BREAK;
                    return this.flowState;
                }
                StreamingCrawler.criticalWarning = null;
                context = Dispatchers.getDefault().plus((CoroutineContext)new CoroutineName("w"));
                urlSpec = (String)UrlUtils.splitUrlArgs((String)url.getUrl()).getFirst();
                isAppActive = this.isActive();
                StreamingCrawler.globalRunningTasks.incrementAndGet();
                BuildersKt.launch$default((CoroutineScope)scope, (CoroutineContext)context, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(isAppActive != false, this, url, urlSpec, null){
                    int label;
                    final /* synthetic */ boolean $isAppActive;
                    final /* synthetic */ StreamingCrawler this$0;
                    final /* synthetic */ UrlAware $url;
                    final /* synthetic */ String $urlSpec;
                    {
                        this.$isAppActive = $isAppActive;
                        this.this$0 = $receiver;
                        this.$url = $url;
                        this.$urlSpec = $urlSpec;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                if (!this.$isAppActive) {
                                    return Unit.INSTANCE;
                                }
                                StreamingCrawler.access$getGlobalMetrics$cp().getTasks().mark();
                                this.label = 1;
                                Object object3 = StreamingCrawler.access$runLoadTask(this.this$0, this.$url, (Continuation)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                Object object3;
                                try {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    object3 = $result;
                                    return Unit.INSTANCE;
                                }
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                                finally {
                                    StreamingCrawler.access$setLastActiveTime$p(this.this$0, Instant.now());
                                    StreamingCrawler.access$getGlobalLoadingUrls$cp().remove(this.$urlSpec);
                                    StreamingCrawler.access$getGlobalRunningTasks$cp().decrementAndGet();
                                    StreamingCrawler.access$getGlobalMetrics$cp().getFinishes().mark();
                                }
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                return this.flowState;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object runLoadTask(UrlAware var1_1, Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof runLoadTask.1)) ** GOTO lbl-1000
        var5_3 = var2_2;
        if ((var5_3.label & -2147483648) != 0) {
            var5_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingCrawler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StreamingCrawler.access$runLoadTask(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.emit((Object)CrawlEvents.willLoad, url);
                if (!(url instanceof ListenableUrl) || !(url instanceof DegenerateUrl)) ** GOTO lbl20
                this.emit((Object)CrawlEvents.load, url);
                this.emit((Object)CrawlEvents.loaded, url, null);
                ** GOTO lbl39
lbl20:
                // 1 sources

                $continuation.L$0 = this;
                $continuation.L$1 = url;
                $continuation.label = 1;
                v0 = this.loadWithTimeout(url, (Continuation<? super WebPage>)$continuation);
                if (v0 == var6_5) {
                    return var6_5;
                }
                ** GOTO lbl32
            }
            case 1: {
                url = (UrlAware)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl32:
                // 2 sources

                page = (WebPage)v0;
                if (this.getEnableSmartRetry()) {
                    this.handleRetry(url, page);
                }
                if (page != null) {
                    this.collectStatAfterLoad(page);
                }
                this.emit((Object)CrawlEvents.loaded, url, page);
lbl39:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadWithTimeout(UrlAware var1_1, Continuation<? super WebPage> var2_2) {
        if (!(var2_2 instanceof loadWithTimeout.1)) ** GOTO lbl-1000
        var9_3 = var2_2;
        if ((var9_3.label & -2147483648) != 0) {
            var9_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingCrawler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StreamingCrawler.access$loadWithTimeout(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                page = null;
                timeout = this.getFetchTaskTimeout().plusSeconds(30L).toMillis();
                $continuation.L$0 = this;
                $continuation.L$1 = url;
                $continuation.J$0 = timeout;
                $continuation.label = 1;
                v0 = TimeoutKt.withTimeout((long)timeout, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super WebPage>, Object>(this, url, null){
                    int label;
                    final /* synthetic */ StreamingCrawler this$0;
                    final /* synthetic */ UrlAware $url;
                    {
                        this.this$0 = $receiver;
                        this.$url = $url;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = StreamingCrawler.access$loadWithMinorExceptionHandled(this.this$0, this.$url, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super WebPage> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v0 != var10_5) goto lbl23
lbl22:
                // 1 sources

                return var10_5;
lbl23:
                // 1 sources

                ** GOTO lbl33
            }
            case 1: {
                timeout = $continuation.J$0;
                page = null;
                url = (UrlAware)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl33:
                    // 2 sources

                    page = (WebPage)v0;
                }
                catch (TimeoutCancellationException var6_8) {
                    StreamingCrawler.globalMetrics.getTimeouts().mark();
                    var7_10 = new Object[]{Boxing.boxLong((long)StreamingCrawler.globalMetrics.getTimeouts().getCount()), Boxing.boxLong((long)timeout), url};
                    this.logger.info("{}. Task timeout ({}) to load page, thrown by [withTimeout] | {}", var7_10);
                }
                catch (Throwable e) {
                    if (!Intrinsics.areEqual((Object)e.getClass().getName(), (Object)"kotlinx.coroutines.JobCancellationException")) ** GOTO lbl47
                    if (StreamingCrawler.isIllegalApplicationState.compareAndSet(false, true)) {
                        this.logger.warn("Coroutine was cancelled, quit... (JobCancellationException)");
                    }
                    this.flowState = FlowState.BREAK;
                    ** GOTO lbl53
lbl47:
                    // 1 sources

                    var7_11 = e.getClass().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)var7_11, (String)"e.javaClass.name");
                    if (!StringsKt.contains$default((CharSequence)var7_11, (CharSequence)"DriverLaunchException", (boolean)false, (int)2, null)) ** GOTO lbl52
                    this.logger.warn(e.getMessage());
                    ** GOTO lbl53
lbl52:
                    // 1 sources

                    this.logger.warn("[Unexpected]", e);
                }
lbl53:
                // 5 sources

                return page;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void collectStatAfterLoad(WebPage page) {
        Object object;
        Object object2 = page.getProtocolStatus();
        boolean bl = false;
        boolean bl2 = false;
        ProtocolStatus it = object2;
        boolean bl3 = false;
        Object object3 = object = !it.isSuccess() ? object2 : null;
        String string = object == null ? "" : (lastFetchError = (object2 = object.toString()) == null ? "" : object2);
        if (!page.getProtocolStatus().isSuccess()) {
            return;
        }
        object = page.getConfiguredUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.configuredUrl");
        lastUrl = object;
        lastHtmlIntegrity = page.getHtmlIntegrity().toString();
        if (page.getHtmlIntegrity() == HtmlIntegrity.WRONG_DISTRICT) {
            wrongDistrict.mark();
        } else {
            wrongDistrict.reset();
        }
        if (page.isFetched()) {
            globalMetrics.getFetchSuccesses().mark();
        }
        globalMetrics.getSuccesses().mark();
    }

    private final void handleRetry(UrlAware url, WebPage page) {
        if (!this.isActive()) {
            return;
        }
        if (page == null) {
            this.handleRetry0(url, page);
        } else if (page.getProtocolStatus().isRetry()) {
            this.handleRetry0(url, page);
        } else if (page.getCrawlStatus().isRetry()) {
            this.handleRetry0(url, page);
        } else if (page.getCrawlStatus().isGone()) {
            globalMetrics.getGone().mark();
            this.taskLogger.info("{}", (Object)new LoadStatusFormatter(page, "Gone", false, false, false, false, 60, null));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Object loadWithMinorExceptionHandled(UrlAware var1_1, Continuation<? super WebPage> var2_2) throws Exception {
        if (!(var2_2 instanceof loadWithMinorExceptionHandled.1)) ** GOTO lbl-1000
        var14_3 = var2_2;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingCrawler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StreamingCrawler.access$loadWithMinorExceptionHandled(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = url.getArgs();
                options = PulsarSession.DefaultImpls.options$default(this.getSession(), var4_6 == null ? "" : var4_6, null, 2, null);
                if (options.isDead()) {
                    StreamingCrawler.globalKilledTasks.incrementAndGet();
                    return null;
                }
                var4_7 = false;
                var5_10 = Result.Companion;
                $i$a$-runCatching-StreamingCrawler$loadWithMinorExceptionHandled$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = url;
                $continuation.label = 1;
                v0 = this.getSession().loadDeferred(url, options, (Continuation<? super WebPage>)$continuation);
                ** if (v0 != var15_5) goto lbl29
lbl28:
                // 1 sources

                return var15_5;
lbl29:
                // 1 sources

                ** GOTO lbl38
            }
            case 1: {
                $i$a$-runCatching-StreamingCrawler$loadWithMinorExceptionHandled$2 = false;
                url = (UrlAware)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl38:
                    // 2 sources

                    var6_13 = (WebPage)v0;
                    var7_17 = false;
                    var5_10 = Result.constructor-impl((Object)var6_13);
                }
                catch (Throwable var6_14) {
                    var7_18 = Result.Companion;
                    var8_19 = false;
                    var5_10 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var6_14));
                }
                var4_8 = var5_10;
                var5_11 = false;
                var6_15 = false;
                v1 = Result.exceptionOrNull-impl((Object)var4_8);
                if (v1 != null) {
                    var6_16 = v1;
                    var7_17 = false;
                    var8_19 = false;
                    var9_20 = var6_16;
                    var10_21 = false;
                    it = var9_20;
                    $i$a$-onFailure-StreamingCrawler$loadWithMinorExceptionHandled$3 = false;
                    this.flowState = this.handleException(url, it);
                }
                var5_11 = false;
                return Result.isFailure-impl((Object)var4_8) != false ? null : var4_8;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final FlowState handleException(UrlAware url, Throwable e) throws Exception {
        if (this.flowState == FlowState.BREAK) {
            return this.flowState;
        }
        if (!this.isActive()) {
            this.logger.debug("Process is closing");
            return FlowState.BREAK;
        }
        Throwable throwable = e;
        if (throwable instanceof IllegalApplicationContextStateException) {
            if (isIllegalApplicationState.compareAndSet(false, true)) {
                this.logger.warn("\n!!!Illegal application context, quit ... | {}", (Object)e.getMessage());
            }
            return FlowState.BREAK;
        }
        if (throwable instanceof IllegalStateException) {
            this.logger.warn("Illegal state", e);
        } else if (throwable instanceof ProxyInsufficientBalanceException) {
            StreamingCrawler streamingCrawler = this;
            int n = streamingCrawler.proxyOutOfService;
            streamingCrawler.proxyOutOfService = n + 1;
            this.logger.warn("{}. {}", (Object)this.proxyOutOfService, (Object)e.getMessage());
        } else {
            if (throwable instanceof ProxyVendorUntrustedException) {
                this.logger.warn("Proxy is untrusted | {}", (Object)e.getMessage());
                return FlowState.BREAK;
            }
            if (throwable instanceof ProxyException) {
                this.logger.warn("[Unexpected] proxy exception | {}", (Object)ExceptionsKt.brief$default((Throwable)e, null, null, (int)3, null));
            } else if (throwable instanceof TimeoutCancellationException) {
                this.logger.warn("[Timeout] Coroutine was cancelled, thrown by [withTimeout]. {} | {}", (Object)ExceptionsKt.brief$default((Throwable)e, null, null, (int)3, null), (Object)url);
            } else {
                if (throwable instanceof CancellationException) {
                    if (isIllegalApplicationState.compareAndSet(false, true)) {
                        this.logger.warn("Streaming crawler job was canceled, quit ...", e);
                    }
                    return FlowState.BREAK;
                }
                throw e;
            }
        }
        return FlowState.CONTINUE;
    }

    private final boolean doLaterIfProcessing(String urlSpec, UrlAware url, Duration delay) {
        if (globalLoadingUrls.contains(urlSpec) || this.getGlobalCache().getFetchingCache().contains(urlSpec)) {
            this.logger.debug("Task is in process, do it {} later | {}", (Object)DateTimesKt.readable((Duration)delay), (Object)url.getConfiguredUrl());
            this.fetchDelayed(url, delay);
            return true;
        }
        return false;
    }

    private final void handleRetry0(UrlAware url, WebPage page) {
        Duration duration;
        int n;
        WebPage webPage = page;
        int nextRetryNumber = 1 + (webPage == null ? 0 : (n = webPage.getFetchRetries()));
        if (page != null && nextRetryNumber > page.getMaxRetries()) {
            globalMetrics.getGone().mark();
            this.taskLogger.info("{}", (Object)new LoadStatusFormatter(page, "Gone (unexpected)", false, false, false, false, 60, null));
            return;
        }
        WebPage webPage2 = page;
        if (webPage2 == null) {
            duration = null;
        } else {
            Duration duration2 = webPage2.getRetryDelay();
            if (duration2 == null) {
                duration = null;
            } else {
                Duration duration3 = duration2;
                boolean bl = false;
                boolean bl2 = false;
                Duration it = duration3;
                boolean bl3 = false;
                duration = !it.isZero() ? duration3 : null;
            }
        }
        Duration duration4 = duration;
        Duration duration5 = duration4 == null ? (Duration)this.getRetryDelayPolicy().invoke((Object)nextRetryNumber, (Object)url) : duration4;
        Intrinsics.checkNotNullExpressionValue(duration5, (String)"page?.retryDelay?.takeIf\u2026icy(nextRetryNumber, url)");
        Duration delay = duration5;
        this.fetchDelayed(url, delay);
        globalMetrics.getRetries().mark();
        if (page != null) {
            String prefix = "Trying " + nextRetryNumber + "th " + DateTimesKt.readable((Duration)delay) + " later";
            this.taskLogger.info("{}", (Object)new LoadStatusFormatter(page, prefix, false, false, false, false, 60, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void fetchDelayed(UrlAware url, Duration delay) {
        boolean bl;
        boolean bl2;
        String string;
        Queue delayCache = this.getGlobalCache().getUrlPool().getDelayCache();
        UrlAware urlAware = url;
        String string2 = url.getArgs();
        if (string2 == null) {
            string = null;
        } else {
            void it;
            String string3 = string2;
            bl2 = false;
            bl = false;
            String string4 = string3;
            UrlAware urlAware2 = urlAware;
            boolean bl3 = false;
            String[] stringArray = new String[]{"refresh"};
            String string5 = LoadOptions.Companion.eraseOptions((String)it, stringArray);
            urlAware = urlAware2;
            string = string5;
        }
        urlAware.setArgs(string);
        string2 = url.getArgs();
        boolean bl4 = !(string2 == null ? false : StringsKt.contains$default((CharSequence)string2, (CharSequence)"refresh", (boolean)false, (int)2, null));
        boolean bl5 = false;
        bl2 = false;
        bl2 = false;
        bl = false;
        if (!bl4) {
            boolean bl6 = false;
            String string6 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string6.toString());
        }
        delayCache.add(new DelayUrl(url, delay));
    }

    private final void handleMemoryShortage(int j) {
        Object[] objectArray = new Object[]{globalRunningTasks, Strings.readableBytes((long)this.getAvailableMemory()), Strings.readableBytes((long)((long)this.memoryToReserve)), Strings.readableBytes((long)(this.getAvailableMemory() - (long)this.memoryToReserve))};
        this.logger.info(j + ".\tnumRunning: {}, availableMemory: {}, memoryToReserve: {}, shortage: {}", objectArray);
        this.getSession().getGlobalCache().clearPDCaches();
        System.gc();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object handleContextLeaks(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof handleContextLeaks.1)) ** GOTO lbl-1000
        var13_2 = var1_1;
        if ((var13_2.label & -2147483648) != 0) {
            var13_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                double D$0;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingCrawler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StreamingCrawler.access$handleContextLeaks(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                contextLeaks = PrivacyContext.Companion.getGlobalMetrics().getContextLeaks();
                contextLeaksRate = contextLeaks.getMeter().getFifteenMinuteRate();
                k = new Ref.IntRef();
lbl15:
                // 2 sources

                while (this.isActive() && contextLeaksRate >= 0.0833333358168602) {
                    ++k.element;
                    if (k.element >= 600) break block0;
                    var7_9 = this.logger;
                    var8_10 = false;
                    var9_11 = false;
                    var10_12 = var7_9;
                    $i$a$-takeIf-StreamingCrawler$handleContextLeaks$2 = false;
                    v0 /* !! */  = var6_8 = k.element % 60 == 0 != false ? var7_9 : null;
                    if (var6_8 != null) {
                        var6_8.warn("Context leaks too fast: {} leaks/seconds, available memory: {}", Boxing.boxDouble((double)contextLeaksRate), Strings.readableBytes((long)this.getAvailableMemory()));
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = contextLeaks;
                    $continuation.L$2 = k;
                    $continuation.D$0 = contextLeaksRate;
                    $continuation.label = 1;
                    v1 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                    if (v1 == var14_4) {
                        return var14_4;
                    }
                    ** GOTO lbl43
                }
                break;
            }
            case 1: {
                contextLeaksRate = $continuation.D$0;
                k = (Ref.IntRef)$continuation.L$2;
                contextLeaks = (MultiMetric)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                contextLeaks.inc(-1);
                contextLeaks.inc(1);
                var6_8 = StreamingCrawler.Companion;
                StreamingCrawler.contextLeakWaitingTime = StreamingCrawler.contextLeakWaitingTime.plus(Duration.ofSeconds(1L));
                ** GOTO lbl15
            }
        }
        StreamingCrawler.contextLeakWaitingTime = Duration.ZERO;
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleProxyOutOfService(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof handleProxyOutOfService.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingCrawler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StreamingCrawler.access$handleProxyOutOfService(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
lbl12:
                // 2 sources

                while (this.isActive() && this.proxyOutOfService > 0) {
                    $continuation.L$0 = this;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                    if (v0 == var5_4) {
                        return var5_4;
                    }
                    ** GOTO lbl24
                }
                break;
            }
            case 1: {
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                var2_5 = StreamingCrawler.Companion;
                StreamingCrawler.proxyVendorWaitingTime = StreamingCrawler.proxyVendorWaitingTime.plus(Duration.ofSeconds(1L));
                this.handleProxyOutOfService0();
                ** GOTO lbl12
            }
        }
        StreamingCrawler.proxyVendorWaitingTime = Duration.ZERO;
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void handleProxyOutOfService0() {
        StreamingCrawler streamingCrawler = this;
        ++streamingCrawler.proxyOutOfService;
        if (streamingCrawler.proxyOutOfService % 180 == 0) {
            this.logger.warn("Proxy out of service, check it again ...");
            ProxyPool p = this.proxyPool;
            if (p != null) {
                Object object;
                ProxyPool proxyPool = p;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    ProxyPool $this$handleProxyOutOfService0_u24lambda_u2d17 = proxyPool;
                    boolean bl2 = false;
                    $this$handleProxyOutOfService0_u24lambda_u2d17 = $this$handleProxyOutOfService0_u24lambda_u2d17.take();
                    bl2 = false;
                    object = Result.constructor-impl((Object)$this$handleProxyOutOfService0_u24lambda_u2d17);
                }
                catch (Throwable $this$handleProxyOutOfService0_u24lambda_u2d17) {
                    Result.Companion bl2 = Result.Companion;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$handleProxyOutOfService0_u24lambda_u2d17));
                }
                proxyPool = object;
                bl = false;
                boolean bl4 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)proxyPool);
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    boolean $this$handleProxyOutOfService0_u24lambda_u2d17 = false;
                    boolean bl2 = false;
                    Throwable throwable3 = throwable2;
                    boolean bl5 = false;
                    Throwable it = throwable3;
                    boolean bl6 = false;
                    if (!(it instanceof ProxyInsufficientBalanceException)) {
                        this.proxyOutOfService = 0;
                    } else {
                        this.logger.warn("Proxy account insufficient balance");
                    }
                }
                bl = false;
                boolean bl7 = false;
                if (Result.isSuccess-impl((Object)proxyPool)) {
                    ProxyEntry it = (ProxyEntry)proxyPool;
                    boolean bl8 = false;
                    this.proxyOutOfService = 0;
                }
            } else {
                this.proxyOutOfService = 0;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final Object handleWrongDistrict(Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof handleWrongDistrict.1)) ** GOTO lbl-1000
        var11_2 = var1_1;
        if ((var11_2.label & -2147483648) != 0) {
            var11_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ StreamingCrawler this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return StreamingCrawler.access$handleWrongDistrict(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                k = new Ref.IntRef();
lbl13:
                // 3 sources

                while (StreamingCrawler.wrongDistrict.getHourlyCounter().getCount() > 60L) {
                    StreamingCrawler.criticalWarning = CriticalWarning.WRONG_DISTRICT;
                    var4_7 /* !! */  = this.logger;
                    var5_8 = false;
                    var6_9 = false;
                    var7_10 = var4_7 /* !! */ ;
                    $i$a$-takeIf-StreamingCrawler$handleWrongDistrict$2 = false;
                    var9_12 = k.element;
                    k.element = var9_12 + 1;
                    v0 /* !! */  = var3_6 = var9_12 % 20 == 0 != false ? var4_7 /* !! */  : null;
                    if (var3_6 != null) {
                        var4_7 /* !! */  = StreamingCrawler.criticalWarning;
                        var3_6.warn("{}", (Object)(var4_7 /* !! */  == null ? "" : var4_7 /* !! */ .getMessage()));
                    }
                    $continuation.L$0 = this;
                    $continuation.L$1 = k;
                    $continuation.label = 1;
                    v1 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                    if (v1 != var12_4) continue;
                    return var12_4;
                }
                break;
            }
            case 1: {
                k = (Ref.IntRef)$continuation.L$1;
                this = (StreamingCrawler)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                ** GOTO lbl13
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void generateFinishCommand() {
        if (SystemUtils.IS_OS_UNIX) {
            this.generateFinishCommandUnix();
        }
    }

    private final void generateFinishCommandUnix() {
        Path finishScriptPath = AppPaths.INSTANCE.getSCRIPT_DIR().resolve("finish-crawler.sh");
        String cmd = "#bin\necho finish-job " + this.jobName + " >> " + AppPaths.INSTANCE.getPATH_LOCAL_COMMAND();
        try {
            String string = cmd;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            string = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE};
            Files.write(finishScriptPath, byArray, (OpenOption[])string);
            Files.setPosixFilePermissions(finishScriptPath, PosixFilePermissions.fromString("rwxrw-r--"));
        }
        catch (IOException e) {
            this.logger.error(e.toString());
        }
    }

    private static final String gauges$lambda-1(StreamingCrawler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Duration duration = this$0.getIdleTime();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"idleTime");
        return DateTimesKt.readable((Duration)duration);
    }

    private static final Integer gauges$lambda-2(StreamingCrawler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getNumPrivacyContexts();
    }

    private static final Integer gauges$lambda-3(StreamingCrawler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getNumMaxActiveTabs();
    }

    private static final Integer gauges$lambda-4(StreamingCrawler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getFetchConcurrency();
    }

    private static final Integer _init_$lambda-5(StreamingCrawler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getGlobalCache().getPageCache().getSize();
    }

    private static final Integer _init_$lambda-6(StreamingCrawler this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getGlobalCache().getDocumentCache().getSize();
    }

    private static final Integer _init_$lambda-21() {
        return globalRunningInstances.get();
    }

    private static final Integer _init_$lambda-22() {
        return globalRunningTasks.get();
    }

    private static final Integer _init_$lambda-23() {
        return globalKilledTasks.get();
    }

    private static final Duration _init_$lambda-24() {
        return contextLeakWaitingTime;
    }

    private static final Duration _init_$lambda-25() {
        return proxyVendorWaitingTime;
    }

    private static final String _init_$lambda-27() {
        Object object;
        CriticalWarning criticalWarning = StreamingCrawler.criticalWarning;
        if (criticalWarning == null) {
            object = "";
        } else {
            String string;
            String string2 = string = criticalWarning.getMessage();
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            String string3 = "!!! WARNING !!! " + it;
            object = string3 == null ? "" : string3;
        }
        return object;
    }

    private static final String _init_$lambda-28() {
        return lastUrl;
    }

    private static final String _init_$lambda-29() {
        return lastHtmlIntegrity;
    }

    private static final String _init_$lambda-30() {
        return lastFetchError;
    }

    public static final /* synthetic */ Object access$checkEmptyUrlSequence(StreamingCrawler $this, int idleSeconds, Continuation $completion) {
        return $this.checkEmptyUrlSequence(idleSeconds, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$runWithStatusCheck(StreamingCrawler $this, int j, UrlAware url, CoroutineScope scope, Continuation $completion) {
        return $this.runWithStatusCheck(j, url, scope, (Continuation<? super FlowState>)$completion);
    }

    public static final /* synthetic */ StreamingCrawlerMetrics access$getGlobalMetrics$cp() {
        return globalMetrics;
    }

    public static final /* synthetic */ Object access$runLoadTask(StreamingCrawler $this, UrlAware url, Continuation $completion) {
        return $this.runLoadTask(url, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$setLastActiveTime$p(StreamingCrawler $this, Instant instant) {
        $this.lastActiveTime = instant;
    }

    public static final /* synthetic */ ConcurrentSkipListSet access$getGlobalLoadingUrls$cp() {
        return globalLoadingUrls;
    }

    public static final /* synthetic */ AtomicInteger access$getGlobalRunningTasks$cp() {
        return globalRunningTasks;
    }

    public static final /* synthetic */ Object access$loadWithTimeout(StreamingCrawler $this, UrlAware url, Continuation $completion) {
        return $this.loadWithTimeout(url, (Continuation<? super WebPage>)$completion);
    }

    public static final /* synthetic */ Object access$loadWithMinorExceptionHandled(StreamingCrawler $this, UrlAware url, Continuation $completion) {
        return $this.loadWithMinorExceptionHandled(url, (Continuation<? super WebPage>)$completion);
    }

    public static final /* synthetic */ Object access$handleContextLeaks(StreamingCrawler $this, Continuation $completion) {
        return $this.handleContextLeaks((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleProxyOutOfService(StreamingCrawler $this, Continuation $completion) {
        return $this.handleProxyOutOfService((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$handleWrongDistrict(StreamingCrawler $this, Continuation $completion) {
        return $this.handleWrongDistrict((Continuation<? super Unit>)$completion);
    }

    static {
        lastUrl = "";
        lastHtmlIntegrity = "";
        lastFetchError = "";
        isIllegalApplicationState = new AtomicBoolean();
        wrongDistrict = AppMetrics.Companion.getReg().multiMetric(Companion, "WRONG_DISTRICT_COUNT");
        Object object = new Pair[]{TuplesKt.to((Object)"globalRunningInstances", StreamingCrawler::_init_$lambda-21), TuplesKt.to((Object)"globalRunningTasks", StreamingCrawler::_init_$lambda-22), TuplesKt.to((Object)"globalKilledTasks", StreamingCrawler::_init_$lambda-23), TuplesKt.to((Object)"contextLeakWaitingTime", StreamingCrawler::_init_$lambda-24), TuplesKt.to((Object)"proxyVendorWaitingTime", StreamingCrawler::_init_$lambda-25), TuplesKt.to((Object)"000WARNING", StreamingCrawler::_init_$lambda-27), TuplesKt.to((Object)"lastUrl", StreamingCrawler::_init_$lambda-28), TuplesKt.to((Object)"lastHtmlIntegrity", StreamingCrawler::_init_$lambda-29), TuplesKt.to((Object)"lastFetchError", StreamingCrawler::_init_$lambda-30)};
        object = MapsKt.mapOf((Pair[])object);
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        AppMetrics.Companion.getReg().registerAll(Companion, it);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lai/platon/pulsar/crawl/impl/StreamingCrawler$Companion;", "", "()V", "contextLeakWaitingTime", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "criticalWarning", "Lai/platon/pulsar/crawl/impl/CriticalWarning;", "globalKilledTasks", "Ljava/util/concurrent/atomic/AtomicInteger;", "globalLoadingUrls", "Ljava/util/concurrent/ConcurrentSkipListSet;", "", "globalMetrics", "Lai/platon/pulsar/crawl/impl/StreamingCrawlerMetrics;", "globalRunningInstances", "globalRunningTasks", "globalTasks", "isIllegalApplicationState", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastFetchError", "lastHtmlIntegrity", "lastUrl", "proxyVendorWaitingTime", "wrongDistrict", "Lai/platon/pulsar/common/metrics/MultiMetric;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

