/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.index;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.urls.UrlUtils;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexField;
import ai.platon.pulsar.crawl.index.IndexingFilters;
import ai.platon.pulsar.crawl.scoring.ScoringFilters;
import ai.platon.pulsar.persist.WebPage;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0010\r\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B9\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001J\u0016\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0001J\u0016\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0003J\u0018\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001J\u0018\u0010#\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030%0$J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010'\u001a\u00020\u0001H\u0002J\u0006\u0010(\u001a\u00020\u0003J\u0010\u0010)\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0010\u0010*\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001e\u001a\u00020\u000eJ\u0010\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001e\u001a\u00020\u000eJ\u0016\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010%2\u0006\u0010\u001e\u001a\u00020\u000eJ\u0010\u0010-\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u000eJ\b\u0010.\u001a\u00020\u0003H\u0016R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0014\"\u0004\b\u0017\u0010\u0004R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u00060"}, d2={"Lai/platon/pulsar/crawl/index/IndexDocument;", "", "key", "", "(Ljava/lang/String;)V", "url", "fields", "", "Lai/platon/pulsar/crawl/index/IndexField;", "weight", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;F)V", "fieldNames", "", "", "getFieldNames", "()Ljava/util/Collection;", "getFields", "()Ljava/util/Map;", "getKey", "()Ljava/lang/String;", "setKey", "getUrl", "setUrl", "getWeight", "()F", "setWeight", "(F)V", "add", "", "name", "value", "addIfAbsent", "addIfNotEmpty", "addIfNotNull", "asMultimap", "", "", "format", "obj", "formatAsLine", "getField", "getFieldValue", "getFieldValueAsString", "getFieldValues", "removeField", "toString", "Builder", "pulsar-skeleton"})
public final class IndexDocument {
    @NotNull
    private String key;
    @NotNull
    private String url;
    @NotNull
    private final Map<String, IndexField> fields;
    private float weight;

    public IndexDocument(@NotNull String key, @NotNull String url, @NotNull Map<String, IndexField> fields, float weight) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        this.key = key;
        this.url = url;
        this.fields = fields;
        this.weight = weight;
    }

    public /* synthetic */ IndexDocument(String string, String string2, Map map2, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            boolean bl = false;
            map2 = new LinkedHashMap();
        }
        if ((n & 8) != 0) {
            f = 1.0f;
        }
        this(string, string2, map2, f);
    }

    @NotNull
    public final String getKey() {
        return this.key;
    }

    public final void setKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.key = string;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @NotNull
    public final Map<String, IndexField> getFields() {
        return this.fields;
    }

    public final float getWeight() {
        return this.weight;
    }

    public final void setWeight(float f) {
        this.weight = f;
    }

    public IndexDocument(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this(key, UrlUtils.unreverseUrl((String)key), null, 0.0f, 12, null);
    }

    public final void addIfAbsent(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.fields.computeIfAbsent(name, arg_0 -> IndexDocument.addIfAbsent$lambda-0(value, arg_0));
    }

    public final void addIfNotEmpty(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = value;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return;
        }
        IndexField field = this.fields.get(name);
        if (field == null) {
            field = new IndexField(value, 0.0f, 2, null);
            Map<String, IndexField> map2 = this.fields;
            boolean bl2 = false;
            map2.put(name, field);
        } else {
            field.add(value);
        }
    }

    public final void addIfNotNull(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value == null) {
            return;
        }
        IndexField field = this.fields.get(name);
        if (field == null) {
            field = new IndexField(value, 0.0f, 2, null);
            Map<String, IndexField> map2 = this.fields;
            boolean bl = false;
            map2.put(name, field);
        } else {
            field.add(value);
        }
    }

    public final void add(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IndexField field = this.fields.get(name);
        if (field == null) {
            Object object = value;
            Intrinsics.checkNotNull((Object)object);
            field = new IndexField(object, 0.0f, 2, null);
            Map<String, IndexField> map2 = this.fields;
            boolean bl = false;
            map2.put(name, field);
        } else {
            Object object = value;
            Intrinsics.checkNotNull((Object)object);
            field.add(object);
        }
    }

    @Nullable
    public final Object getFieldValue(@NotNull CharSequence name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, IndexField> map2 = this.fields;
        boolean bl = false;
        IndexField field = map2.get(name);
        if (field == null) {
            return null;
        }
        if (field.getValues().size() == 0) {
            return null;
        }
        return field.getValues().get(0);
    }

    @Nullable
    public final IndexField getField(@NotNull CharSequence name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, IndexField> map2 = this.fields;
        boolean bl = false;
        return map2.get(name);
    }

    @Nullable
    public final IndexField removeField(@NotNull CharSequence name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, IndexField> map2 = this.fields;
        boolean bl = false;
        Map<String, IndexField> map3 = map2;
        if (map3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
        }
        return (IndexField)TypeIntrinsics.asMutableMap(map3).remove(name);
    }

    @NotNull
    public final Collection<CharSequence> getFieldNames() {
        return this.fields.keySet();
    }

    @Nullable
    public final List<Object> getFieldValues(@NotNull CharSequence name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, IndexField> map2 = this.fields;
        boolean bl = false;
        IndexField indexField = map2.get(name);
        if (indexField == null) {
            return null;
        }
        IndexField field = indexField;
        return field.getValues();
    }

    @Nullable
    public final String getFieldValueAsString(@NotNull CharSequence name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, IndexField> map2 = this.fields;
        boolean bl = false;
        IndexField field = map2.get(name);
        if (field == null || field.getValues().isEmpty()) {
            return null;
        }
        return field.getValues().iterator().next().toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<String>> asMultimap() {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = this.fields.entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(it.getKey(), ((IndexField)it.getValue()).getStringValues());
            boolean bl2 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    @NotNull
    public String toString() {
        String s2 = CollectionsKt.joinToString$default((Iterable)this.fields.entrySet(), null, null, null, (int)0, null, (Function1)toString.s.1.INSTANCE, (int)31, null);
        return "doc {\n" + s2 + "\n}\n";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String formatAsLine() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.fields.entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = "\t" + it.getKey() + ":\t" + it.getValue();
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, (Function1)formatAsLine.2.INSTANCE, (int)31, null);
    }

    private final String format(Object obj) {
        if (obj instanceof Date) {
            return DateTimes.INSTANCE.isoInstantFormat((Date)obj);
        }
        if (obj instanceof Instant) {
            return DateTimes.isoInstantFormat((Instant)((Instant)obj));
        }
        return obj.toString();
    }

    private static final IndexField addIfAbsent$lambda-0(Object $value, String it) {
        Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new IndexField($value, 0.0f, 2, null);
    }

    public IndexDocument() {
        this(null, null, null, 0.0f, 15, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/crawl/index/IndexDocument$Builder;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "indexingFilters", "Lai/platon/pulsar/crawl/index/IndexingFilters;", "scoringFilters", "Lai/platon/pulsar/crawl/scoring/ScoringFilters;", "build", "Lai/platon/pulsar/crawl/index/IndexDocument;", "key", "", "page", "Lai/platon/pulsar/persist/WebPage;", "with", "Companion", "pulsar-skeleton"})
    public static final class Builder {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final ImmutableConfig conf;
        @NotNull
        private IndexingFilters indexingFilters;
        @NotNull
        private ScoringFilters scoringFilters;

        public Builder(@Nullable ImmutableConfig conf) {
            this.conf = conf;
            ImmutableConfig immutableConfig = this.conf;
            Intrinsics.checkNotNull((Object)immutableConfig);
            this.indexingFilters = new IndexingFilters(immutableConfig);
            this.scoringFilters = new ScoringFilters(this.conf);
        }

        @NotNull
        public final Builder with(@NotNull IndexingFilters indexingFilters) {
            Intrinsics.checkNotNullParameter((Object)indexingFilters, (String)"indexingFilters");
            this.indexingFilters = indexingFilters;
            return this;
        }

        @NotNull
        public final Builder with(@NotNull ScoringFilters scoringFilters) {
            Intrinsics.checkNotNullParameter((Object)scoringFilters, (String)"scoringFilters");
            this.scoringFilters = scoringFilters;
            return this;
        }

        @Nullable
        public final IndexDocument build(@Nullable String key, @Nullable WebPage page) {
            if (key == null || page == null) {
                return null;
            }
            IndexDocument doc = new IndexDocument(key);
            String url = doc.getUrl();
            if ((doc = this.indexingFilters.filter(doc, url, page)) == null) {
                return null;
            }
            doc.addIfAbsent("id", key);
            doc.add("digest", page.getSignatureAsString());
            doc.add("batchId", page.getBatchId());
            float boost = 1.0f;
            boost = this.scoringFilters.indexerScore(url, doc, page, boost);
            doc.setWeight(boost);
            doc.add("boost", String.valueOf(boost));
            return doc;
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lai/platon/pulsar/crawl/index/IndexDocument$Builder$Companion;", "", "()V", "newBuilder", "Lai/platon/pulsar/crawl/index/IndexDocument$Builder;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "pulsar-skeleton"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Builder newBuilder(@Nullable ImmutableConfig conf) {
                return new Builder(conf);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

