/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.index;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0003B\u0019\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u0006\u0010\u0014\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0011J\u000e\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\u0010\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lai/platon/pulsar/crawl/index/IndexField;", "Lorg/apache/hadoop/io/Writable;", "", "()V", "value", "", "weight", "", "(Ljava/lang/Object;F)V", "stringValues", "", "", "getStringValues", "()Ljava/util/List;", "values", "", "add", "", "clone", "getValues", "getWeight", "readFields", "in", "Ljava/io/DataInput;", "reset", "setWeight", "toString", "write", "out", "Ljava/io/DataOutput;", "pulsar-skeleton"})
public final class IndexField
implements Writable,
Cloneable {
    private float weight;
    @NotNull
    private List<Object> values;

    public IndexField() {
        this.values = new ArrayList();
    }

    @JvmOverloads
    public IndexField(@NotNull Object value, float weight) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.values = new ArrayList();
        this.weight = weight;
        if (value instanceof Collection) {
            this.values.addAll((Collection)value);
        } else {
            this.values.add(value);
        }
    }

    public /* synthetic */ IndexField(Object object, float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        this(object, f);
    }

    public final void add(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.values.add(value);
    }

    public final float getWeight() {
        return this.weight;
    }

    public final void setWeight(float weight) {
        this.weight = weight;
    }

    @NotNull
    public final List<Object> getValues() {
        return this.values;
    }

    @NotNull
    public final List<String> getStringValues() {
        List<String> list = this.values.stream().map(IndexField::_get_stringValues_$lambda-0).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"values.stream().map { ob\u2026lect(Collectors.toList())");
        return list;
    }

    public final void reset() {
        this.weight = 1.0f;
        this.values.clear();
    }

    @NotNull
    public Object clone() throws CloneNotSupportedException {
        IndexField result = (IndexField)super.clone();
        result.weight = this.weight;
        result.values = this.values;
        return result;
    }

    public void readFields(@NotNull DataInput in) throws IOException {
        block26: {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.weight = in.readFloat();
            int count = in.readInt();
            this.values = new ArrayList();
            int n = 0;
            if (n >= count) break block26;
            do {
                int i = n++;
                String type = Text.readString((DataInput)in);
                if (type == null) continue;
                int n2 = -1;
                switch (type.hashCode()) {
                    case -527879800: {
                        if (type.equals("java.lang.Float")) {
                            n2 = 1;
                        }
                        break;
                    }
                    case 398795216: {
                        if (type.equals("java.lang.Long")) {
                            n2 = 2;
                        }
                        break;
                    }
                    case 65575278: {
                        if (type.equals("java.util.Date")) {
                            n2 = 3;
                        }
                        break;
                    }
                    case 344809556: {
                        if (type.equals("java.lang.Boolean")) {
                            n2 = 4;
                        }
                        break;
                    }
                    case 1195259493: {
                        if (type.equals("java.lang.String")) {
                            n2 = 5;
                        }
                        break;
                    }
                    case 1296075756: {
                        if (type.equals("java.time.Instant")) {
                            n2 = 6;
                        }
                        break;
                    }
                    case -2056817302: {
                        if (type.equals("java.lang.Integer")) {
                            n2 = 7;
                        }
                        break;
                    }
                }
                switch (n2) {
                    case 5: {
                        Object object = Text.readString((DataInput)in);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"readString(`in`)");
                        this.values.add(object);
                        break;
                    }
                    case 4: {
                        this.values.add(in.readBoolean());
                        break;
                    }
                    case 7: {
                        this.values.add(in.readInt());
                        break;
                    }
                    case 1: {
                        this.values.add(Float.valueOf(in.readFloat()));
                        break;
                    }
                    case 2: {
                        this.values.add(in.readLong());
                        break;
                    }
                    case 3: {
                        this.values.add(new Date(in.readLong()));
                        break;
                    }
                    case 6: {
                        Object object = Instant.ofEpochMilli(in.readLong());
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofEpochMilli(`in`.readLong())");
                        this.values.add(object);
                    }
                }
            } while (n < count);
        }
    }

    public void write(@NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeFloat(this.weight);
        out.writeInt(this.values.size());
        for (Object value : this.values) {
            Text.writeString((DataOutput)out, (String)value.getClass().getName());
            if (value instanceof Boolean) {
                out.writeBoolean((Boolean)value);
                continue;
            }
            if (value instanceof Integer) {
                out.writeInt(((Number)value).intValue());
                continue;
            }
            if (value instanceof Long) {
                out.writeLong(((Number)value).longValue());
                continue;
            }
            if (value instanceof Float) {
                out.writeFloat(((Number)value).floatValue());
                continue;
            }
            if (value instanceof String) {
                Text.writeString((DataOutput)out, (String)((String)value));
                continue;
            }
            if (value instanceof Date) {
                out.writeLong(((Date)value).getTime());
                continue;
            }
            if (!(value instanceof Instant)) continue;
            out.writeLong(((Instant)value).toEpochMilli());
        }
    }

    @NotNull
    public String toString() {
        return this.values.toString();
    }

    @JvmOverloads
    public IndexField(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this(value, 0.0f, 2, null);
    }

    private static final String _get_stringValues_$lambda-0(Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.toString();
    }
}

