/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.index;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.LogsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexWriter;
import ai.platon.pulsar.crawl.index.IndexWriters;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0015J\u0010\u0010\u001a\u001a\u00020\u00152\b\u0010\u001b\u001a\u0004\u0018\u00010\u0019J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fR\"\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006!"}, d2={"Lai/platon/pulsar/crawl/index/IndexWriters;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "indexWriters", "", "Lai/platon/pulsar/crawl/index/IndexWriter;", "(Ljava/util/List;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "setLOG", "(Lorg/slf4j/Logger;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getIndexWriters", "()Ljava/util/List;", "close", "", "commit", "delete", "key", "", "open", "indexerUrl", "toString", "update", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "write", "pulsar-skeleton"})
public final class IndexWriters
implements AutoCloseable {
    @NotNull
    private final List<IndexWriter> indexWriters;
    @NotNull
    private final ImmutableConfig conf;
    private Logger LOG;

    public IndexWriters(@NotNull List<IndexWriter> indexWriters, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(indexWriters, (String)"indexWriters");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.indexWriters = indexWriters;
        this.conf = conf;
        this.LOG = LogsKt.getLogger((KClass)Reflection.getOrCreateKotlinClass(IndexWriters.class));
    }

    public /* synthetic */ IndexWriters(List list, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boolean bl = false;
            list = new ArrayList();
        }
        this(list, immutableConfig);
    }

    @NotNull
    public final List<IndexWriter> getIndexWriters() {
        return this.indexWriters;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public final Logger getLOG() {
        return this.LOG;
    }

    public final void setLOG(Logger logger) {
        this.LOG = logger;
    }

    public IndexWriters(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        boolean bl = false;
        this(new ArrayList(), conf);
    }

    public final void open() {
        for (IndexWriter indexWriter : this.indexWriters) {
            try {
                indexWriter.open(this.conf);
            }
            catch (Throwable e) {
                this.LOG.error("Failed to open indexer. " + ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            }
        }
    }

    public final void open(@Nullable String indexerUrl) {
        for (IndexWriter indexWriter : this.indexWriters) {
            try {
                indexWriter.open(indexerUrl);
            }
            catch (Throwable e) {
                this.LOG.error("Failed to open indexer. " + ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            }
        }
    }

    public final void write(@Nullable IndexDocument doc) {
        for (IndexWriter indexWriter : this.indexWriters) {
            try {
                indexWriter.write(doc);
            }
            catch (Throwable e) {
                this.LOG.error("Failed to write indexer. " + ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            }
        }
    }

    public final void update(@NotNull IndexDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        for (IndexWriter indexWriter : this.indexWriters) {
            try {
                indexWriter.update(doc);
            }
            catch (Throwable e) {
                this.LOG.error("Failed to update indexer. " + ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            }
        }
    }

    public final void delete(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        for (IndexWriter indexWriter : this.indexWriters) {
            try {
                indexWriter.delete(key);
            }
            catch (Throwable e) {
                this.LOG.error("Failed to delete indexer. " + ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            }
        }
    }

    @Override
    public void close() {
        for (IndexWriter indexWriter : this.indexWriters) {
            try {
                indexWriter.close();
            }
            catch (Throwable e) {
                this.LOG.error("Failed to close IndexWriter " + indexWriter.getName());
                this.LOG.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            }
        }
        this.indexWriters.clear();
    }

    public final void commit() {
        for (IndexWriter indexWriter : this.indexWriters) {
            try {
                indexWriter.commit();
            }
            catch (Throwable e) {
                this.LOG.error("Failed to commit indexer. {}", (Object)ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            }
        }
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.indexWriters, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
    }
}

