/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.index;

import ai.platon.pulsar.common.config.ImmutableConfig;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\nR\u00020\u00000\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0006J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u00060\nR\u00020\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lai/platon/pulsar/crawl/index/IndexerMapping;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "mappingFile", "", "(Ljava/lang/String;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "keyMap", "", "Lai/platon/pulsar/crawl/index/IndexerMapping$MappingField;", "uniqueKey", "getKeyMap", "", "isMultiValued", "", "key", "mapKeyIfExists", "parseMapping", "", "reportKeys", "Companion", "MappingField", "pulsar-skeleton"})
public final class IndexerMapping {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String mappingFile;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final Map<String, MappingField> keyMap;
    @NotNull
    private String uniqueKey;
    @NotNull
    public static final String PARAM_INDEXER_MAPPING_FILE = "indexer.mapping.file";
    private static Logger LOG = LoggerFactory.getLogger(IndexerMapping.class);

    public IndexerMapping(@NotNull String mappingFile, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)mappingFile, (String)"mappingFile");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.mappingFile = mappingFile;
        this.conf = conf;
        this.keyMap = new HashMap();
        this.uniqueKey = "id";
        this.parseMapping();
    }

    public IndexerMapping(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(conf.get(PARAM_INDEXER_MAPPING_FILE, "indexer-mapping.xml"), conf);
    }

    private final void parseMapping() {
        InputStream ssInputStream = this.conf.getConfResourceAsInputStream(this.mappingFile);
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        List solrFields = arrayList;
        InputSource inputSource = new InputSource(ssInputStream);
        try {
            int n;
            int n2;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(inputSource);
            Element rootElement = document.getDocumentElement();
            NodeList fieldList = rootElement.getElementsByTagName("field");
            if (fieldList.getLength() > 0 && (n2 = 0) < (n = fieldList.getLength())) {
                do {
                    int i;
                    Node node;
                    if ((node = fieldList.item(i = n2++)) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                    }
                    Element element = (Element)node;
                    String name = element.getAttribute("name");
                    String type = element.getAttribute("type");
                    String indexed = element.getAttribute("indexed");
                    String stored = element.getAttribute("stored");
                    String required = element.getAttribute("required");
                    String multiValued = element.getAttribute("multiValued");
                    boolean bIndexed = indexed != null && StringsKt.equals((String)indexed, (String)"true", (boolean)true);
                    boolean bStored = stored != null && StringsKt.equals((String)stored, (String)"true", (boolean)true);
                    boolean bRequired = required != null && StringsKt.equals((String)required, (String)"true", (boolean)true);
                    boolean bMultiValued = multiValued != null && StringsKt.equals((String)multiValued, (String)"true", (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
                    MappingField mappingFiled = new MappingField(name, type, bIndexed, bStored, bRequired, bMultiValued);
                    solrFields.add(name);
                    Map<String, MappingField> map2 = this.keyMap;
                    String string = name;
                    boolean bl = false;
                    map2.put(string, mappingFiled);
                } while (n2 < n);
            }
            LOG.info("Registered " + solrFields.size() + " solr fields : " + StringUtils.join((Iterable)solrFields, (String)", "));
            NodeList uniqueKeyItem = rootElement.getElementsByTagName("uniqueKey");
            if (uniqueKeyItem.getLength() > 1) {
                LOG.warn("More than one unique key definitions found in solr index mapping, using default 'id'");
                this.uniqueKey = "id";
            } else if (uniqueKeyItem.getLength() == 0) {
                LOG.warn("No unique key definition found in solr index mapping using, default 'id'");
            } else {
                String string = uniqueKeyItem.item(0).getFirstChild().getNodeValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uniqueKeyItem.item(0).firstChild.nodeValue");
                this.uniqueKey = string;
            }
        }
        catch (SAXException e) {
            LOG.warn(e.toString());
        }
        catch (IOException e) {
            LOG.warn(e.toString());
        }
        catch (ParserConfigurationException e) {
            LOG.warn(e.toString());
        }
    }

    @NotNull
    public final Map<String, MappingField> getKeyMap() {
        return this.keyMap;
    }

    @Nullable
    public final String mapKeyIfExists(@NotNull String key) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.keyMap.containsKey(key) ? key : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isMultiValued(@NotNull String key) throws IOException {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (!this.keyMap.containsKey(key)) return false;
        MappingField mappingField = this.keyMap.get(key);
        Intrinsics.checkNotNull((Object)mappingField);
        if (!mappingField.getMultiValued()) return false;
        return true;
    }

    @NotNull
    public final String reportKeys() {
        String string = this.keyMap.keySet().stream().collect(Collectors.joining(", "));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"keyMap.keys.stream().col\u2026Collectors.joining(\", \"))");
        return string;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0018\b\u0086\u0004\u0018\u00002\u00020\u0001B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\t\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\f\"\u0004\b\u0015\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0011\"\u0004\b\u0017\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\f\"\u0004\b\u0019\u0010\u000eR\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\f\"\u0004\b\u001b\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0011\"\u0004\b\u001d\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lai/platon/pulsar/crawl/index/IndexerMapping$MappingField;", "", "name", "", "type", "indexed", "", "stored", "required", "multiValued", "(Lai/platon/pulsar/crawl/index/IndexerMapping;Ljava/lang/String;Ljava/lang/String;ZZZZ)V", "getIndexed", "()Z", "setIndexed", "(Z)V", "mappedName", "getMappedName", "()Ljava/lang/String;", "setMappedName", "(Ljava/lang/String;)V", "getMultiValued", "setMultiValued", "getName", "setName", "getRequired", "setRequired", "getStored", "setStored", "getType", "setType", "pulsar-skeleton"})
    public final class MappingField {
        @NotNull
        private String name;
        @NotNull
        private String mappedName;
        @NotNull
        private String type;
        private boolean indexed;
        private boolean stored;
        private boolean required;
        private boolean multiValued;

        public MappingField(@NotNull String name, String type, boolean indexed, boolean stored, boolean required, boolean multiValued) {
            Intrinsics.checkNotNullParameter((Object)IndexerMapping.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.name = name;
            this.mappedName = this.name;
            this.type = type;
            this.indexed = indexed;
            this.stored = stored;
            this.required = required;
            this.multiValued = multiValued;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final void setName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.name = string;
        }

        @NotNull
        public final String getMappedName() {
            return this.mappedName;
        }

        public final void setMappedName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.mappedName = string;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final void setType(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.type = string;
        }

        public final boolean getIndexed() {
            return this.indexed;
        }

        public final void setIndexed(boolean bl) {
            this.indexed = bl;
        }

        public final boolean getStored() {
            return this.stored;
        }

        public final void setStored(boolean bl) {
            this.stored = bl;
        }

        public final boolean getRequired() {
            return this.required;
        }

        public final void setRequired(boolean bl) {
            this.required = bl;
        }

        public final boolean getMultiValued() {
            return this.multiValued;
        }

        public final void setMultiValued(boolean bl) {
            this.multiValued = bl;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lai/platon/pulsar/crawl/index/IndexerMapping$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "setLOG", "(Lorg/slf4j/Logger;)V", "PARAM_INDEXER_MAPPING_FILE", "", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public final void setLOG(Logger logger) {
            LOG = logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

