/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.index;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexingException;
import ai.platon.pulsar.crawl.index.IndexingFilter;
import ai.platon.pulsar.crawl.index.IndexingFilters;
import ai.platon.pulsar.persist.WebPage;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ \u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lai/platon/pulsar/crawl/index/IndexingFilters;", "", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "indexingFilters", "", "Lai/platon/pulsar/crawl/index/IndexingFilter;", "(Ljava/util/List;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getIndexingFilters", "()Ljava/util/List;", "filter", "Lai/platon/pulsar/crawl/index/IndexDocument;", "doc", "url", "", "page", "Lai/platon/pulsar/persist/WebPage;", "toString", "Companion", "pulsar-skeleton"})
public final class IndexingFilters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<IndexingFilter> indexingFilters;
    @NotNull
    private final ImmutableConfig conf;
    private static final Logger LOG = LoggerFactory.getLogger(IndexingFilters.class);

    public IndexingFilters(@NotNull List<IndexingFilter> indexingFilters, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(indexingFilters, (String)"indexingFilters");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.indexingFilters = indexingFilters;
        this.conf = conf;
    }

    public /* synthetic */ IndexingFilters(List list, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boolean bl = false;
            list = new ArrayList();
        }
        this(list, immutableConfig);
    }

    @NotNull
    public final List<IndexingFilter> getIndexingFilters() {
        return this.indexingFilters;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    public IndexingFilters(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        boolean bl = false;
        this(new ArrayList(), conf);
    }

    @Nullable
    public final IndexDocument filter(@NotNull IndexDocument doc, @NotNull String url, @NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        IndexDocument doc1 = doc;
        for (IndexingFilter indexingFilter : this.indexingFilters) {
            try {
                if (doc1 == null) break;
                doc1 = indexingFilter.filter(doc1, url, page);
            }
            catch (IndexingException e) {
                LOG.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
                return null;
            }
        }
        return doc1;
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.indexingFilters, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/crawl/index/IndexingFilters$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

