/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.index.io;

import ai.platon.pulsar.crawl.index.IndexDocument;
import ai.platon.pulsar.crawl.index.IndexField;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VersionMismatchException;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0011"}, d2={"Lai/platon/pulsar/crawl/index/io/IndexDocumentWritable;", "Lorg/apache/hadoop/io/Writable;", "doc", "Lai/platon/pulsar/crawl/index/IndexDocument;", "(Lai/platon/pulsar/crawl/index/IndexDocument;)V", "getDoc", "()Lai/platon/pulsar/crawl/index/IndexDocument;", "setDoc", "get", "readFields", "", "input", "Ljava/io/DataInput;", "write", "out", "Ljava/io/DataOutput;", "Companion", "pulsar-skeleton"})
public final class IndexDocumentWritable
implements Writable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private IndexDocument doc;
    public static final byte VERSION = 2;

    public IndexDocumentWritable(@NotNull IndexDocument doc) {
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.doc = doc;
    }

    public /* synthetic */ IndexDocumentWritable(IndexDocument indexDocument, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            indexDocument = new IndexDocument(null, null, null, 0.0f, 15, null);
        }
        this(indexDocument);
    }

    @NotNull
    public final IndexDocument getDoc() {
        return this.doc;
    }

    public final void setDoc(@NotNull IndexDocument indexDocument) {
        Intrinsics.checkNotNullParameter((Object)indexDocument, (String)"<set-?>");
        this.doc = indexDocument;
    }

    @NotNull
    public final IndexDocument get() {
        return this.doc;
    }

    public void readFields(@NotNull DataInput input) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte version = input.readByte();
        if (version != 2) {
            throw new VersionMismatchException(2, version);
        }
        int n = 0;
        int size = WritableUtils.readVInt((DataInput)input);
        if (n < size) {
            do {
                int i = n++;
                String name = Text.readString((DataInput)input);
                IndexField field = new IndexField();
                field.readFields(input);
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                this.doc.add(name, field);
            } while (n < size);
        }
        this.doc.setWeight(input.readFloat());
    }

    public void write(@NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeByte(2);
        Map<String, IndexField> fields = this.doc.getFields();
        WritableUtils.writeVInt((DataOutput)out, (int)fields.size());
        Object object = fields;
        boolean bl = false;
        Iterator<Map.Entry<String, IndexField>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            IndexField field = (IndexField)object3.getValue();
            Text.writeString((DataOutput)out, (String)key);
            field.write(out);
        }
        out.writeFloat(this.doc.getWeight());
    }

    public IndexDocumentWritable() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/crawl/index/io/IndexDocumentWritable$Companion;", "", "()V", "VERSION", "", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

