/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.index.jit.indexer;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.fetch.batch.JobFetchTask;
import ai.platon.pulsar.crawl.index.jit.indexer.JITIndexer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u0001\u0017B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0000H\u0096\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\b\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/crawl/index/jit/indexer/IndexThread;", "Ljava/lang/Thread;", "", "jitIndexer", "Lai/platon/pulsar/crawl/index/jit/indexer/JITIndexer;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/index/jit/indexer/JITIndexer;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "halt", "Ljava/util/concurrent/atomic/AtomicBoolean;", "id", "", "isHalted", "", "()Z", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "compareTo", "other", "exitAndJoin", "", "run", "Companion", "pulsar-skeleton"})
public final class IndexThread
extends Thread
implements Comparable<IndexThread> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JITIndexer jitIndexer;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger log;
    private final int id;
    @NotNull
    private final AtomicBoolean halt;
    @NotNull
    private static final AtomicInteger instanceSequence = new AtomicInteger(0);

    public IndexThread(@NotNull JITIndexer jitIndexer, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)jitIndexer, (String)"jitIndexer");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.jitIndexer = jitIndexer;
        this.conf = conf;
        this.log = LoggerFactory.getLogger(IndexThread.class);
        this.id = instanceSequence.incrementAndGet();
        this.halt = new AtomicBoolean(false);
        this.setDaemon(true);
        this.setName("Indexer-" + this.id);
    }

    public final boolean isHalted() {
        return this.halt.get();
    }

    public final void halt() {
        this.halt.set(true);
    }

    public final void exitAndJoin() {
        this.halt.set(true);
        try {
            this.join();
        }
        catch (InterruptedException e) {
            this.log.error(e.toString());
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        this.jitIndexer.registerFetchThread$pulsar_skeleton(this);
        while (!this.isHalted()) {
            try {
                JobFetchTask item = this.jitIndexer.consume();
                JobFetchTask jobFetchTask = item;
                if ((jobFetchTask == null ? null : jobFetchTask.getPage()) == null) continue;
                this.jitIndexer.index(item);
            }
            catch (Exception e) {
                this.log.error("Indexer failed, " + e);
            }
        }
        this.jitIndexer.unregisterFetchThread$pulsar_skeleton(this);
    }

    @Override
    public int compareTo(@NotNull IndexThread other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        String string = this.getName();
        String string2 = other.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"other.name");
        return string.compareTo(string2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/crawl/index/jit/indexer/IndexThread$Companion;", "", "()V", "instanceSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

