/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.inject;

import ai.platon.pulsar.common.DateTimes;
import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.common.options.deprecated.CrawlOptions;
import ai.platon.pulsar.crawl.scoring.ScoringFilters;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.Mark;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001a\u0010\b\u001a\u00020\t2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/platon/pulsar/crawl/inject/SeedBuilder;", "Lai/platon/pulsar/common/config/Parameterized;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "scoreFilters", "Lai/platon/pulsar/crawl/scoring/ScoringFilters;", "(Lai/platon/pulsar/crawl/scoring/ScoringFilters;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "create", "Lai/platon/pulsar/persist/WebPage;", "url", "", "args", "urlArgs", "Lorg/apache/commons/lang3/tuple/Pair;", "getParams", "Lai/platon/pulsar/common/config/Params;", "makeSeed", "", "page", "Companion", "pulsar-skeleton"})
public final class SeedBuilder
implements Parameterized {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScoringFilters scoreFilters;
    @NotNull
    private final ImmutableConfig conf;
    private static final Logger LOG = LoggerFactory.getLogger(SeedBuilder.class);

    public SeedBuilder(@NotNull ScoringFilters scoreFilters, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)scoreFilters, (String)"scoreFilters");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.scoreFilters = scoreFilters;
        this.conf = conf;
    }

    public SeedBuilder(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new ScoringFilters(conf), conf);
    }

    @NotNull
    public Params getParams() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
        Params params = Params.of((String)"injectTime", (Object)DateTimes.INSTANCE.format(instant), (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\"injectTime\", DateTimes.format(Instant.now()))");
        return params;
    }

    @NotNull
    public final WebPage create(@NotNull Pair<String, String> urlArgs) {
        Intrinsics.checkNotNullParameter(urlArgs, (String)"urlArgs");
        Object object = urlArgs.getKey();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"urlArgs.key");
        String string = (String)object;
        object = urlArgs.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"urlArgs.value");
        return this.create(string, (String)object);
    }

    @NotNull
    public final WebPage create(@NotNull String url, @NotNull String args) {
        WebPage webPage;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        CharSequence charSequence = url;
        boolean bl = false;
        if (charSequence.length() == 0) {
            charSequence = WebPage.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"NIL");
            return charSequence;
        }
        WebPage webPage2 = WebPage.newWebPage((String)url, (VolatileConfig)this.conf.toVolatileConfig());
        Intrinsics.checkNotNullExpressionValue((Object)webPage2, (String)"newWebPage(url, conf.toVolatileConfig())");
        WebPage page = webPage2;
        if (this.makeSeed(url, args, page)) {
            webPage = page;
        } else {
            webPage2 = WebPage.NIL;
            Intrinsics.checkNotNullExpressionValue((Object)webPage2, (String)"NIL");
            webPage = webPage2;
        }
        return webPage;
    }

    public final boolean makeSeed(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        String string2 = string;
        string = page.getArgs();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.args");
        return this.makeSeed(string2, string, page);
    }

    private final boolean makeSeed(String url, String args, WebPage page) {
        if (page.isInternal()) {
            return false;
        }
        CrawlOptions options = CrawlOptions.Companion.parse(args, this.conf);
        Instant now = Instant.now();
        page.setDistance(0);
        if (page.getCreateTime().isBefore(AppConstants.TCP_IP_STANDARDIZED_TIME)) {
            page.setCreateTime(now);
        }
        page.markSeed();
        page.setScore((float)options.getScore());
        this.scoreFilters.injectedScore(page);
        page.setFetchTime(now);
        page.setFetchInterval(options.getFetchInterval());
        page.setFetchPriority(options.getFetchPriority());
        page.getMarks().put(Mark.INJECT, "y");
        return true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lai/platon/pulsar/crawl/inject/SeedBuilder$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

