/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.parse;

import ai.platon.pulsar.common.DateTimesKt;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.FlowState;
import ai.platon.pulsar.common.HtmlIntegrity;
import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Parameterized;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.metrics.AppMetricRegistry;
import ai.platon.pulsar.common.metrics.AppMetrics;
import ai.platon.pulsar.common.metrics.EnumCounterRegistry;
import ai.platon.pulsar.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.crawl.LoadEvent;
import ai.platon.pulsar.crawl.common.JobInitialized;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.crawl.event.WebPageEventHandler;
import ai.platon.pulsar.crawl.filter.CrawlFilters;
import ai.platon.pulsar.crawl.parse.LinkFilter;
import ai.platon.pulsar.crawl.parse.ParseException;
import ai.platon.pulsar.crawl.parse.ParseResult;
import ai.platon.pulsar.crawl.parse.Parser;
import ai.platon.pulsar.crawl.parse.ParserFactory;
import ai.platon.pulsar.crawl.parse.ParserNotFound;
import ai.platon.pulsar.crawl.signature.Signature;
import ai.platon.pulsar.crawl.signature.TextMD5Signature;
import ai.platon.pulsar.persist.HyperlinkPersistable;
import ai.platon.pulsar.persist.ParseStatus;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.WebPageExt;
import ai.platon.pulsar.persist.metadata.FetchMode;
import ai.platon.pulsar.persist.metadata.Mark;
import ai.platon.pulsar.persist.metadata.Name;
import ai.platon.pulsar.persist.model.PageModel;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 H2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002HIB\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J$\u00102\u001a\b\u0012\u0004\u0012\u000204032\u0006\u0010-\u001a\u00020.2\f\u00105\u001a\b\u0012\u0004\u0012\u00020403H\u0002J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u0002002\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00109\u001a\u0002002\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010:\u001a\u00020,2\u0006\u0010-\u001a\u00020.J\u001e\u0010;\u001a\u0002002\u0006\u0010-\u001a\u00020.2\f\u00105\u001a\b\u0012\u0004\u0012\u0002040<H\u0002J\u0018\u0010=\u001a\u0002002\u0006\u0010-\u001a\u00020.2\u0006\u0010>\u001a\u00020?H\u0002J\u0018\u0010@\u001a\u0002002\u0006\u0010-\u001a\u00020.2\u0006\u0010A\u001a\u00020,H\u0002J\u0018\u0010B\u001a\u00020,2\u0006\u0010C\u001a\u00020D2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010E\u001a\u0002002\u0006\u0010F\u001a\u00020\u0007H\u0016J\u0010\u0010G\u001a\u0002002\u0006\u0010>\u001a\u00020?H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n \u001b*\u0004\u0018\u00010\u001a0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001b*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0017\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u0006J"}, d2={"Lai/platon/pulsar/crawl/parse/PageParser;", "Lai/platon/pulsar/common/config/Parameterized;", "Lai/platon/pulsar/crawl/common/JobInitialized;", "Ljava/lang/AutoCloseable;", "parserFactory", "Lai/platon/pulsar/crawl/parse/ParserFactory;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/crawl/parse/ParserFactory;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "crawlFilters", "Lai/platon/pulsar/crawl/filter/CrawlFilters;", "signature", "Lai/platon/pulsar/crawl/signature/Signature;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "(Lai/platon/pulsar/crawl/parse/ParserFactory;Lai/platon/pulsar/common/config/ImmutableConfig;Lai/platon/pulsar/crawl/filter/CrawlFilters;Lai/platon/pulsar/crawl/signature/Signature;Lai/platon/pulsar/common/message/MiscMessageWriter;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "getCrawlFilters", "()Lai/platon/pulsar/crawl/filter/CrawlFilters;", "linkFilter", "Lai/platon/pulsar/crawl/parse/LinkFilter;", "getLinkFilter", "()Lai/platon/pulsar/crawl/parse/LinkFilter;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "maxParseTime", "Ljava/time/Duration;", "maxParsedLinks", "", "getMessageWriter", "()Lai/platon/pulsar/common/message/MiscMessageWriter;", "getParserFactory", "()Lai/platon/pulsar/crawl/parse/ParserFactory;", "getSignature", "()Lai/platon/pulsar/crawl/signature/Signature;", "unparsableTypes", "Ljava/util/concurrent/ConcurrentSkipListSet;", "", "getUnparsableTypes", "()Ljava/util/concurrent/ConcurrentSkipListSet;", "applyParsers", "Lai/platon/pulsar/crawl/parse/ParseResult;", "page", "Lai/platon/pulsar/persist/WebPage;", "close", "", "doParse", "filterLinks", "", "Lai/platon/pulsar/persist/HyperlinkPersistable;", "unfilteredLinks", "getParams", "Lai/platon/pulsar/common/config/Params;", "onParsed", "onWillParse", "parse", "processLinks", "", "processRedirect", "parseStatus", "Lai/platon/pulsar/persist/ParseStatus;", "processSuccess", "parseResult", "runParser", "p", "Lai/platon/pulsar/crawl/parse/Parser;", "setup", "jobConf", "updateCounters", "Companion", "Counter", "pulsar-skeleton"})
public final class PageParser
implements Parameterized,
JobInitialized,
AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ParserFactory parserFactory;
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final CrawlFilters crawlFilters;
    @NotNull
    private final Signature signature;
    @Nullable
    private final MiscMessageWriter messageWriter;
    private final Logger log;
    @NotNull
    private final ConcurrentSkipListSet<CharSequence> unparsableTypes;
    private final int maxParsedLinks;
    private final Duration maxParseTime;
    @NotNull
    private final LinkFilter linkFilter;
    private static final Logger LOG = LoggerFactory.getLogger(PageParser.class);

    public PageParser(@NotNull ParserFactory parserFactory, @NotNull ImmutableConfig conf, @NotNull CrawlFilters crawlFilters, @NotNull Signature signature, @Nullable MiscMessageWriter messageWriter) {
        Intrinsics.checkNotNullParameter((Object)parserFactory, (String)"parserFactory");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        Intrinsics.checkNotNullParameter((Object)crawlFilters, (String)"crawlFilters");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        this.parserFactory = parserFactory;
        this.conf = conf;
        this.crawlFilters = crawlFilters;
        this.signature = signature;
        this.messageWriter = messageWriter;
        AppMetricRegistry.register$default(AppMetrics.Companion.getReg(), Counter.class, null, false, 6, null);
        this.log = LoggerFactory.getLogger(PageParser.class);
        this.unparsableTypes = new ConcurrentSkipListSet();
        this.maxParsedLinks = this.conf.getUint("parse.max.links", 200);
        Params[] paramsArray = AppConstants.DEFAULT_MAX_PARSE_TIME;
        Intrinsics.checkNotNullExpressionValue((Object)paramsArray, (String)"DEFAULT_MAX_PARSE_TIME");
        this.maxParseTime = this.conf.getDuration("parser.timeout", (Duration)paramsArray);
        this.linkFilter = new LinkFilter(this.crawlFilters, this.conf);
        paramsArray = new Params[]{this.linkFilter.getParams()};
        this.getParams().merge(paramsArray).withLogger(LOG).info(true);
    }

    public /* synthetic */ PageParser(ParserFactory parserFactory, ImmutableConfig immutableConfig, CrawlFilters crawlFilters, Signature signature, MiscMessageWriter miscMessageWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            crawlFilters = new CrawlFilters(immutableConfig);
        }
        if ((n & 8) != 0) {
            signature = new TextMD5Signature();
        }
        if ((n & 0x10) != 0) {
            miscMessageWriter = null;
        }
        this(parserFactory, immutableConfig, crawlFilters, signature, miscMessageWriter);
    }

    @NotNull
    public final ParserFactory getParserFactory() {
        return this.parserFactory;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final CrawlFilters getCrawlFilters() {
        return this.crawlFilters;
    }

    @NotNull
    public final Signature getSignature() {
        return this.signature;
    }

    @Nullable
    public final MiscMessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    @NotNull
    public final ConcurrentSkipListSet<CharSequence> getUnparsableTypes() {
        return this.unparsableTypes;
    }

    @NotNull
    public final LinkFilter getLinkFilter() {
        return this.linkFilter;
    }

    public PageParser(@NotNull ParserFactory parserFactory, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)parserFactory, (String)"parserFactory");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(parserFactory, conf, new CrawlFilters(conf), new TextMD5Signature(), new MiscMessageWriter(conf));
    }

    public PageParser(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new ParserFactory(conf), conf);
    }

    @Override
    public void setup(@NotNull ImmutableConfig jobConf) {
        Intrinsics.checkNotNullParameter((Object)jobConf, (String)"jobConf");
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"maxParsedLinks", this.maxParsedLinks};
        Params params = Params.of((String)"maxParseTime", (Object)this.maxParseTime, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n                \"max\u2026 maxParsedLinks\n        )");
        return params;
    }

    @NotNull
    public final ParseResult parse(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        try {
            ParseResult parseResult = this.doParse(page);
            if (parseResult.isParsed()) {
                page.setParseStatus((ParseStatus)parseResult);
                if (parseResult.isRedirect()) {
                    this.processRedirect(page, parseResult);
                } else if (parseResult.isSuccess()) {
                    this.processSuccess(page, parseResult);
                }
                this.updateCounters(parseResult);
                if (parseResult.isSuccess()) {
                    page.getMarks().putIfNotNull(Mark.PARSE, page.getMarks().get(Mark.FETCH));
                }
            }
            return parseResult;
        }
        catch (Throwable e) {
            LOG.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
            return new ParseResult(0, 0, null, 7, null);
        }
    }

    private final Set<HyperlinkPersistable> filterLinks(WebPage page, Set<? extends HyperlinkPersistable> unfilteredLinks) {
        Sequence $this$sortedByDescending$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)unfilteredLinks), (Function1)((Function1)new Function1<HyperlinkPersistable, Boolean>(this, page){
            final /* synthetic */ PageParser this$0;
            final /* synthetic */ WebPage $page;
            {
                this.this$0 = $receiver;
                this.$page = $page;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull HyperlinkPersistable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.this$0.getLinkFilter().asPredicate(this.$page).test(it);
            }
        }));
        boolean $i$f$sortedByDescending = false;
        boolean bl = false;
        return SequencesKt.toSet((Sequence)SequencesKt.take((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                boolean bl = false;
                HyperlinkPersistable it = (HyperlinkPersistable)b;
                boolean bl2 = false;
                Comparable comparable = Integer.valueOf(it.getText().length());
                it = (HyperlinkPersistable)a;
                Comparable comparable2 = comparable;
                bl2 = false;
                Integer n = it.getText().length();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        }), (int)this.maxParsedLinks));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ParseResult doParse(WebPage page) {
        if (page.isInternal()) {
            ParseResult parseResult = new ParseResult(0, 0, null, 7, null);
            boolean bl = false;
            boolean bl2 = false;
            ParseResult $this$doParse_u24lambda_u2d1 = parseResult;
            boolean bl3 = false;
            $this$doParse_u24lambda_u2d1.setFlowStatus(FlowState.BREAK);
            return parseResult;
        }
        Object object = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.url");
        String url = object;
        if (Companion.isTruncated(page)) {
            return ParseResult.Companion.failed(202, url);
        }
        try {
            this.onWillParse(page);
            object = this.applyParsers(page);
        }
        catch (ParserNotFound e) {
            this.unparsableTypes.add(page.getContentType());
            LOG.warn("No parser found for <" + page.getContentType() + ">\n" + e.getMessage());
            ParseResult parseResult = ParseResult.Companion.failed(206, page.getContentType());
            return parseResult;
        }
        catch (Throwable e) {
            LOG.warn("Failed to parse | " + page.getConfiguredUrl(), e);
            ParseResult parseResult = ParseResult.Companion.failed(e);
            return parseResult;
        }
        finally {
            this.onParsed(page);
        }
        return object;
    }

    private final void onWillParse(WebPage page) {
        try {
            WebPageEventHandler webPageEventHandler;
            LoadEvent loadEvent = WebPageExKt.getLoadEvent(page);
            if (loadEvent != null && (webPageEventHandler = loadEvent.getOnWillParse()) != null) {
                webPageEventHandler.invoke(page);
            }
        }
        catch (Throwable e) {
            LOG.warn("[onWillParse]", e);
        }
    }

    private final void onParsed(WebPage page) {
        try {
            WebPageEventHandler webPageEventHandler;
            LoadEvent loadEvent = WebPageExKt.getLoadEvent(page);
            if (loadEvent != null && (webPageEventHandler = loadEvent.getOnParsed()) != null) {
                webPageEventHandler.invoke(page);
            }
        }
        catch (Throwable e) {
            LOG.warn("[onParsed]", e);
        }
    }

    private final ParseResult applyParsers(WebPage page) throws ParseException {
        if (page.isInternal()) {
            ParseResult parseResult = new ParseResult(0, 0, null, 7, null);
            boolean bl = false;
            boolean bl2 = false;
            ParseResult $this$applyParsers_u24lambda_u2d2 = parseResult;
            boolean bl3 = false;
            $this$applyParsers_u24lambda_u2d2.setFlowStatus(FlowState.BREAK);
            return parseResult;
        }
        ParseResult parseResult = null;
        parseResult = new ParseResult(0, 0, null, 7, null);
        Object object = page.getContentType();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.contentType");
        String string = object;
        object = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.url");
        List<Parser> parsers = this.parserFactory.getParsers(string, (String)object);
        for (Parser parser : parsers) {
            String string2 = parser.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parser::class.java.name");
            Duration timeout = StringsKt.contains$default((CharSequence)string2, (CharSequence)"HtmlParser", (boolean)false, (int)2, null) ? Duration.ZERO : this.maxParseTime;
            boolean $i$f$measureTimeMillis = false;
            boolean bl = false;
            long start$iv = System.currentTimeMillis();
            boolean bl4 = false;
            PageParser pageParser = this;
            boolean bl5 = false;
            boolean bl6 = false;
            PageParser it = pageParser;
            boolean bl7 = false;
            boolean bl8 = timeout.getSeconds() > 0L;
            PageParser pageParser2 = bl8 ? pageParser : null;
            parseResult = pageParser2 == null ? parser.parse(page) : pageParser2.runParser(parser, page);
            long millis = System.currentTimeMillis() - start$iv;
            parseResult.getParsers().add((KClass<? extends Parser>)Reflection.getOrCreateKotlinClass(parser.getClass()));
            PageModel m = page.getPageModel();
            if (this.log.isDebugEnabled() && millis > 10000L && m != null) {
                Object[] objectArray = new Object[5];
                Duration duration = Duration.ofMillis(millis);
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(millis)");
                objectArray[0] = DateTimesKt.readable((Duration)duration);
                objectArray[1] = m.getNumNonBlankFields();
                objectArray[2] = m.getNumNonNullFields();
                objectArray[3] = m.getNumFields();
                objectArray[4] = page.getUrl();
                this.log.debug("It takes {} to parse {}/{}/{} fields | {}", objectArray);
            }
            if (!parseResult.getShouldBreak()) continue;
            break;
        }
        return parseResult;
    }

    private final ParseResult runParser(Parser p, WebPage page) {
        return (ParseResult)((Object)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ParseResult>, Object>(this, p, page, null){
            int label;
            final /* synthetic */ PageParser this$0;
            final /* synthetic */ Parser $p;
            final /* synthetic */ WebPage $page;
            {
                this.this$0 = $receiver;
                this.$p = $p;
                this.$page = $page;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = TimeoutKt.withTimeout((long)PageParser.access$getMaxParseTime$p(this.this$0).toMillis(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ParseResult>, Object>(this.$p, this.$page, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ Parser $p;
                            final /* synthetic */ WebPage $page;
                            {
                                this.$p = $p;
                                this.$page = $page;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            @Nullable
                            public final Object invokeSuspend(@NotNull Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        CoroutineScope $this$withTimeout = (CoroutineScope)this.L$0;
                                        Deferred deferred2 = BuildersKt.async$default((CoroutineScope)$this$withTimeout, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ParseResult>, Object>(this.$p, this.$page, null){
                                            int label;
                                            final /* synthetic */ Parser $p;
                                            final /* synthetic */ WebPage $page;
                                            {
                                                this.$p = $p;
                                                this.$page = $page;
                                                super(2, $completion);
                                            }

                                            @Nullable
                                            public final Object invokeSuspend(@NotNull Object object) {
                                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)object);
                                                        return this.$p.parse(this.$page);
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            @NotNull
                                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            @Nullable
                                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ParseResult> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (int)3, null);
                                        this.label = 1;
                                        Object object3 = deferred2.await((Continuation)this);
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            @NotNull
                            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            @Nullable
                            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ParseResult> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super ParseResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null));
    }

    private final void processSuccess(WebPage page, ParseResult parseResult) {
        Object object;
        ByteBuffer prevSig = page.getSignature();
        if (prevSig != null) {
            page.setPrevSignature(prevSig);
        }
        if ((object = this.signature.calculate(page)) != null) {
            byte[] byArray = object;
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            page.setSignature(it);
        }
        object = parseResult.getHypeLinks();
        boolean bl = false;
        if (!object.isEmpty()) {
            this.processLinks(page, parseResult.getHypeLinks());
        }
    }

    private final void processRedirect(WebPage page, ParseStatus parseStatus) {
        String refreshHref = parseStatus.getArgOrDefault("refreshHref", "");
        Intrinsics.checkNotNullExpressionValue((Object)refreshHref, (String)"refreshHref");
        String string = this.crawlFilters.normalizeToNull(refreshHref, "fetcher");
        if (string == null) {
            return;
        }
        String newUrl = string;
        page.addLiveLink(new HyperlinkPersistable(newUrl));
        page.getMetadata().set(Name.REDIRECT_DISCOVERED, "y");
        if (Intrinsics.areEqual((Object)newUrl, (Object)page.getUrl())) {
            String string2 = parseStatus.getArgOrDefault("refreshTime", "0");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parseStatus.getArgOrDefa\u2026Status.REFRESH_TIME, \"0\")");
            boolean bl = false;
            int refreshTime = Integer.parseInt(string2);
            String string3 = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"page.url");
            String reprUrl = URLUtil.chooseRepr(string3, newUrl, refreshTime < 5);
            page.setReprUrl(reprUrl);
        }
    }

    private final void processLinks(WebPage page, Set<HyperlinkPersistable> unfilteredLinks) {
        boolean follow;
        boolean bl = follow = !page.getMetadata().contains(Name.NO_FOLLOW) || page.isSeed() || page.hasMark(Mark.INJECT) || page.getMetadata().contains(Name.FORCE_FOLLOW) || page.getVariables().contains(Name.FORCE_FOLLOW.name());
        if (follow) {
            Logger logger;
            WebPageExt pageExt = new WebPageExt(page);
            Set<HyperlinkPersistable> hypeLinks = unfilteredLinks;
            Logger logger2 = this.log;
            boolean bl2 = false;
            boolean bl3 = false;
            Logger it = logger2;
            boolean bl4 = false;
            Object object = logger = it.isTraceEnabled() ? logger2 : null;
            if (logger != null) {
                logger.trace("Find {}/{} live links", (Object)hypeLinks.size(), (Object)unfilteredLinks.size());
            }
            page.setLiveLinks((Iterable)hypeLinks);
            pageExt.addHyperlinks((Iterable)hypeLinks);
        }
    }

    private final void updateCounters(ParseStatus parseStatus) {
        Counter counter = null;
        short s2 = parseStatus.getMajorCode();
        if (s2 == 2) {
            counter = Counter.parseFailed;
        }
        if (counter != null) {
            EnumCounterRegistry.inc$default(AppMetrics.Companion.getReg().getEnumCounterRegistry(), counter, 0, 2, null);
        }
    }

    @Override
    public void close() {
    }

    public static final /* synthetic */ Duration access$getMaxParseTime$p(PageParser $this) {
        return $this.maxParseTime;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lai/platon/pulsar/crawl/parse/PageParser$Counter;", "", "(Ljava/lang/String;I)V", "notFetched", "alreadyParsed", "truncated", "notParsed", "parseSuccess", "parseFailed", "pulsar-skeleton"})
    public static final class Counter
    extends Enum<Counter> {
        public static final /* enum */ Counter notFetched = new Counter();
        public static final /* enum */ Counter alreadyParsed = new Counter();
        public static final /* enum */ Counter truncated = new Counter();
        public static final /* enum */ Counter notParsed = new Counter();
        public static final /* enum */ Counter parseSuccess = new Counter();
        public static final /* enum */ Counter parseFailed = new Counter();
        private static final /* synthetic */ Counter[] $VALUES;

        public static Counter[] values() {
            return (Counter[])$VALUES.clone();
        }

        public static Counter valueOf(String value) {
            return Enum.valueOf(Counter.class, value);
        }

        static {
            $VALUES = counterArray = new Counter[]{Counter.notFetched, Counter.alreadyParsed, Counter.truncated, Counter.notParsed, Counter.parseSuccess, Counter.parseFailed};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lai/platon/pulsar/crawl/parse/PageParser$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "isTruncated", "", "page", "Lai/platon/pulsar/persist/WebPage;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public final boolean isTruncated(@NotNull WebPage page) {
            Intrinsics.checkNotNullParameter((Object)page, (String)"page");
            if (page.getFetchMode() == FetchMode.BROWSER) {
                HtmlIntegrity htmlIntegrity = page.getHtmlIntegrity();
                Intrinsics.checkNotNullExpressionValue((Object)htmlIntegrity, (String)"page.htmlIntegrity");
                HtmlIntegrity hi = htmlIntegrity;
                return hi.isOK() ? false : (hi.isOther() ? page.getContentLength() < 20000L : true);
            }
            if (page.getFetchMode() != FetchMode.NATIVE) {
                return false;
            }
            String string = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
            String url = string;
            int inHeaderSize = page.getHeaders().getContentLength();
            if (inHeaderSize < 0) {
                this.getLOG().trace("HttpHeaders.CONTENT_LENGTH is not available | " + url);
                return false;
            }
            ByteBuffer content = page.getContent();
            if (content == null) {
                this.getLOG().debug("Page content is null, url: " + url);
                return false;
            }
            int actualSize = content.limit();
            return inHeaderSize > actualSize;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

