/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.parse;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.parse.FilterResult;
import ai.platon.pulsar.crawl.parse.ParseFilter;
import ai.platon.pulsar.crawl.parse.ParseFilters;
import ai.platon.pulsar.crawl.parse.html.ParseContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001b\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0007J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u0016J\u0012\u0010!\u001a\u00020\u00162\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#J$\u0010$\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010%\u001a\u00020&2\n\u0010'\u001a\u00060(j\u0002`)H\u0002J\u0014\u0010$\u001a\u00020\u00162\f\b\u0002\u0010'\u001a\u00060(j\u0002`)J\b\u0010*\u001a\u00020+H\u0016R2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00070\u0007 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lai/platon/pulsar/crawl/parse/ParseFilters;", "Ljava/lang/AutoCloseable;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "initParseFilters", "", "Lai/platon/pulsar/crawl/parse/ParseFilter;", "(Ljava/util/List;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "_parseFilters", "", "kotlin.jvm.PlatformType", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "logger", "Lorg/slf4j/Logger;", "parseFilters", "getParseFilters", "()Ljava/util/List;", "addFirst", "", "parseFilter", "addLast", "", "clear", "close", "filter", "parseContext", "Lai/platon/pulsar/crawl/parse/html/ParseContext;", "hasFilter", "initialize", "remove", "clazz", "Lkotlin/reflect/KClass;", "report", "depth", "", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toString", "", "pulsar-skeleton"})
public final class ParseFilters
implements AutoCloseable {
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    private final List<ParseFilter> _parseFilters;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final List<ParseFilter> parseFilters;

    public ParseFilters(@NotNull List<? extends ParseFilter> initParseFilters, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(initParseFilters, (String)"initParseFilters");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.logger = LoggerFactory.getLogger(ParseFilters.class);
        this._parseFilters = Collections.synchronizedList(CollectionsKt.toMutableList((Collection)initParseFilters));
        this.closed = new AtomicBoolean();
        List<ParseFilter> list = this._parseFilters;
        Intrinsics.checkNotNullExpressionValue(list, (String)"_parseFilters");
        this.parseFilters = list;
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @NotNull
    public final List<ParseFilter> getParseFilters() {
        return this.parseFilters;
    }

    public ParseFilters(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        boolean bl = false;
        this(CollectionsKt.emptyList(), conf);
    }

    public final void initialize() {
        Iterable $this$forEach$iv = this.parseFilters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParseFilter it = (ParseFilter)element$iv;
            boolean bl = false;
            it.initialize();
        }
    }

    public final void clear() {
        this._parseFilters.clear();
    }

    public final void remove(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Iterator<ParseFilter> it = this._parseFilters.iterator();
        while (it.hasNext() && Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(it.next().getClass()), clazz)) {
            it.remove();
        }
    }

    public final boolean hasFilter(@NotNull ParseFilter parseFilter) {
        Intrinsics.checkNotNullParameter((Object)parseFilter, (String)"parseFilter");
        return this.parseFilters.contains(parseFilter);
    }

    public final void addFirst(@NotNull ParseFilter parseFilter) {
        Intrinsics.checkNotNullParameter((Object)parseFilter, (String)"parseFilter");
        this._parseFilters.add(0, parseFilter);
    }

    public final boolean addLast(@NotNull ParseFilter parseFilter) {
        Intrinsics.checkNotNullParameter((Object)parseFilter, (String)"parseFilter");
        return this._parseFilters.add(parseFilter);
    }

    public final void filter(@NotNull ParseContext parseContext) {
        Intrinsics.checkNotNullParameter((Object)parseContext, (String)"parseContext");
        Iterable $this$forEach$iv = this.parseFilters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object;
            ParseFilter filter = (ParseFilter)element$iv;
            boolean bl = false;
            if (!filter.isRelevant(parseContext).isOK()) continue;
            ParseFilter parseFilter = filter;
            boolean bl2 = false;
            try {
                object = Result.Companion;
                ParseFilter $this$filter_u24lambda_u2d3_u24lambda_u2d1 = parseFilter;
                boolean bl3 = false;
                FilterResult filterResult = $this$filter_u24lambda_u2d3_u24lambda_u2d1.filter(parseContext);
                boolean bl4 = false;
                object = Result.constructor-impl((Object)((Object)filterResult));
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl5 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            parseFilter = object;
            bl2 = false;
            boolean bl6 = false;
            if (Result.exceptionOrNull-impl((Object)parseFilter) != null) {
                Throwable throwable;
                boolean bl7 = false;
                boolean bl8 = false;
                Throwable throwable2 = throwable;
                boolean bl9 = false;
                Throwable it = throwable2;
                boolean bl10 = false;
                this.logger.warn("[Unexpected]", it);
            }
            bl2 = false;
            FilterResult result = (FilterResult)((Object)(Result.isFailure-impl((Object)parseFilter) ? null : parseFilter));
            if (result == null || !result.getShouldBreak()) continue;
            return;
        }
    }

    public final void report(@NotNull StringBuilder sb) {
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Iterable $this$forEach$iv = this.parseFilters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParseFilter it = (ParseFilter)element$iv;
            boolean bl = false;
            this.report(it, 0, sb);
        }
    }

    public static /* synthetic */ void report$default(ParseFilters parseFilters, StringBuilder stringBuilder, int n, Object object) {
        if ((n & 1) != 0) {
            stringBuilder = new StringBuilder();
        }
        parseFilters.report(stringBuilder);
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.parseFilters, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Iterable $this$forEach$iv = this.parseFilters;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Throwable throwable;
                Object object;
                ParseFilter it = (ParseFilter)element$iv;
                boolean bl = false;
                ParseFilter parseFilter = it;
                boolean bl2 = false;
                try {
                    object = Result.Companion;
                    ParseFilter $this$close_u24lambda_u2d7_u24lambda_u2d5 = parseFilter;
                    boolean bl3 = false;
                    $this$close_u24lambda_u2d7_u24lambda_u2d5.close();
                    Unit unit = Unit.INSTANCE;
                    boolean bl4 = false;
                    object = Result.constructor-impl((Object)unit);
                }
                catch (Throwable throwable2) {
                    Result.Companion companion = Result.Companion;
                    boolean bl5 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                }
                parseFilter = object;
                bl2 = false;
                boolean bl6 = false;
                if (Result.exceptionOrNull-impl((Object)parseFilter) == null) continue;
                boolean bl7 = false;
                boolean bl8 = false;
                Throwable throwable3 = throwable;
                boolean bl9 = false;
                Throwable t = throwable3;
                boolean bl10 = false;
                this.logger.warn("Cannot close " + this.getClass().getSimpleName(), t);
            }
        }
    }

    private final void report(ParseFilter filter, int depth, StringBuilder sb) {
        String padding = depth > 0 ? StringsKt.repeat((CharSequence)"  ", (int)depth) : "";
        StringBuilder stringBuilder = sb;
        String string = padding + filter;
        boolean bl = false;
        StringBuilder stringBuilder2 = stringBuilder.append(string);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
        StringBuilder stringBuilder3 = stringBuilder2;
        boolean bl2 = false;
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
        Iterable $this$forEach$iv = filter.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParseFilter it = (ParseFilter)element$iv;
            boolean bl3 = false;
            this.report(it, depth + 1, sb);
        }
    }
}

