/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.parse;

import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.parse.ParserConfig;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lai/platon/pulsar/crawl/parse/ParserConfigReader;", "", "()V", "notDefinedParsers", "", "", "parseConfigFile", "getAliases", "", "parsePluginsRoot", "Lorg/w3c/dom/Element;", "parse", "Lai/platon/pulsar/crawl/parse/ParserConfig;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "Companion", "pulsar-skeleton"})
public final class ParserConfigReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private String parseConfigFile;
    @NotNull
    private final List<String> notDefinedParsers;
    private static final Logger LOG = LoggerFactory.getLogger(ParserConfigReader.class);
    @NotNull
    public static final String PARSE_PLUGINS_FILE = "parse.plugin.file";

    public ParserConfigReader() {
        boolean bl = false;
        this.notDefinedParsers = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ParserConfig parse(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        ParserConfig parserConfig = new ParserConfig();
        String resourcePrefix = conf.get("legacy.config.profile", "");
        String fileResource = conf.get(PARSE_PLUGINS_FILE, "parse-plugins.xml");
        Document document = null;
        try {
            Object object = new String[]{resourcePrefix};
            object = ResourceLoader.INSTANCE.getResourceAsReader(fileResource, object);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                Reader reader = (Reader)object;
                boolean bl3 = false;
                InputSource inputSource = new InputSource(reader);
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                document = parser.parse(inputSource);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        catch (IOException e) {
            LOG.error("Failed to find resource " + fileResource);
            return parserConfig;
        }
        catch (ParserConfigurationException e) {
            String string;
            String string2 = this.parseConfigFile;
            if (string2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parseConfigFile");
                string = null;
            } else {
                string = string2;
            }
            LOG.warn("Unable to parse [" + string + "]", (Throwable)e);
            return parserConfig;
        }
        catch (SAXException e) {
            String string;
            String string3 = this.parseConfigFile;
            if (string3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parseConfigFile");
                string = null;
            } else {
                string = string3;
            }
            LOG.warn("Unable to parse [" + string + "]", (Throwable)e);
            return parserConfig;
        }
        catch (Throwable e) {
            String string;
            String string4 = this.parseConfigFile;
            if (string4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"parseConfigFile");
                string = null;
            } else {
                string = string4;
            }
            LOG.warn("Unable to parse [" + string + "], unexpected exception", e);
            return parserConfig;
        }
        Document document2 = document;
        Intrinsics.checkNotNull((Object)document2);
        Element parsePlugins = document2.getDocumentElement();
        Intrinsics.checkNotNullExpressionValue((Object)parsePlugins, (String)"parsePlugins");
        Map<String, String> aliases = this.getAliases(parsePlugins);
        parserConfig.setAliases(aliases);
        NodeList mimeTypes = parsePlugins.getElementsByTagName("mimeType");
        int n = 0;
        int n2 = mimeTypes.getLength();
        if (n < n2) {
            do {
                int i;
                Node node;
                if ((node = mimeTypes.item(i = n++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element mimeType = (Element)node;
                String mimeTypeStr = mimeType.getAttribute("name");
                NodeList parserNodes = mimeType.getElementsByTagName("parser");
                if (parserNodes != null && parserNodes.getLength() > 0) {
                    int n3 = 0;
                    List parserClasses = new ArrayList();
                    n3 = 0;
                    int n4 = parserNodes.getLength();
                    if (n3 < n4) {
                        do {
                            int j;
                            Node node2;
                            if ((node2 = parserNodes.item(j = n3++)) == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                            }
                            Element parserNode = (Element)node2;
                            String parserId = parserNode.getAttribute("id");
                            String parserClass = aliases.get(parserId);
                            if (parserClass == null) {
                                Intrinsics.checkNotNullExpressionValue((Object)parserId, (String)"parserId");
                                this.notDefinedParsers.add(parserId);
                                continue;
                            }
                            parserClasses.add(parserClass);
                        } while (n3 < n4);
                    }
                    Collection collection = parserClasses;
                    n4 = 0;
                    if (!(!collection.isEmpty())) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)mimeTypeStr, (String)"mimeTypeStr");
                    parserConfig.setParsers(mimeTypeStr, parserClasses);
                    continue;
                }
                LOG.warn("No plugins defined for mime type: " + mimeTypeStr + ", continuing parse");
            } while (n < n2);
        }
        return parserConfig;
    }

    private final Map<String, String> getAliases(Element parsePluginsRoot) {
        int n;
        int n2;
        Node node;
        Map aliases = new HashMap();
        NodeList aliasRoot = parsePluginsRoot.getElementsByTagName("aliases");
        if (aliasRoot == null || aliasRoot.getLength() == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("No aliases defined in parse-plugins.xml!");
            }
            return aliases;
        }
        if (aliasRoot.getLength() > 1 && LOG.isWarnEnabled()) {
            LOG.warn("There should only be one \"aliases\" tag in parse-plugins.xml");
        }
        if ((node = aliasRoot.item(0)) == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
        }
        Element aliasRootElem = (Element)node;
        NodeList aliasElements = aliasRootElem.getElementsByTagName("alias");
        if (aliasElements != null && aliasElements.getLength() > 0 && (n2 = 0) < (n = aliasElements.getLength())) {
            do {
                int i;
                Node node2;
                if ((node2 = aliasElements.item(i = n2++)) == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.w3c.dom.Element");
                }
                Element aliasElem = (Element)node2;
                String name = aliasElem.getAttribute("name");
                String clazz = aliasElem.getAttribute("class");
                if (name == null || clazz == null) continue;
                Map map2 = aliases;
                String string = name;
                String string2 = clazz;
                boolean bl = false;
                map2.put(string, string2);
            } while (n2 < n);
        }
        return aliases;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lai/platon/pulsar/crawl/parse/ParserConfigReader$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "PARSE_PLUGINS_FILE", "", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

