/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.parse;

import ai.platon.pulsar.common.MimeTypeResolver;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.crawl.parse.Parser;
import ai.platon.pulsar.crawl.parse.ParserConfig;
import ai.platon.pulsar.crawl.parse.ParserConfigReader;
import ai.platon.pulsar.crawl.parse.ParserFactory;
import ai.platon.pulsar.crawl.parse.ParserNotFound;
import ai.platon.pulsar.crawl.parse.html.PrimerHtmlParser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B%\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB)\b\u0016\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0013\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\rJ\b\u0010\u0016\u001a\u00020\rH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lai/platon/pulsar/crawl/parse/ParserFactory;", "", "availableParsers", "", "Lai/platon/pulsar/crawl/parse/Parser;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Ljava/util/List;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "parserConfig", "Lai/platon/pulsar/crawl/parse/ParserConfig;", "(Lai/platon/pulsar/crawl/parse/ParserConfig;Ljava/util/List;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "parses", "", "", "(Ljava/util/Map;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "mineType2Parsers", "Ljava/util/concurrent/ConcurrentHashMap;", "escapeContentType", "contentType", "getParsers", "url", "toString", "Companion", "pulsar-skeleton"})
public final class ParserFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ImmutableConfig conf;
    @NotNull
    private final ConcurrentHashMap<String, List<Parser>> mineType2Parsers;
    private static final Logger LOG = LoggerFactory.getLogger(ParserFactory.class);
    @NotNull
    public static final String DEFAULT_MINE_TYPE = "*";

    public ParserFactory(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.mineType2Parsers = new ConcurrentHashMap();
        if (this.mineType2Parsers.isEmpty()) {
            List htmlParsers = CollectionsKt.listOf((Object)new PrimerHtmlParser(this.conf));
            Object[] objectArray = new String[]{"text/html", "application/xhtml+xml"};
            Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                Map map2 = this.mineType2Parsers;
                boolean bl2 = false;
                map2.put(it, htmlParsers);
            }
        }
    }

    public ParserFactory(@NotNull List<? extends Parser> availableParsers, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(availableParsers, (String)"availableParsers");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(new ParserConfigReader().parse(conf), availableParsers, conf);
    }

    /*
     * WARNING - void declaration
     */
    public ParserFactory(@NotNull ParserConfig parserConfig, @NotNull List<? extends Parser> availableParsers, @NotNull ImmutableConfig conf) {
        String string;
        Map.Entry it;
        Map map2;
        void $this$associateByTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)parserConfig, (String)"parserConfig");
        Intrinsics.checkNotNullParameter(availableParsers, (String)"availableParsers");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(conf);
        Iterable $this$associateBy$iv = availableParsers;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Object destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv2) {
            Parser parser = (Parser)element$iv$iv;
            map2 = destination$iv$iv;
            boolean $i$a$-associateBy-ParserFactory$availableNamedParsers$22 = false;
            string = it.getClass().getName();
            map2.put(string, element$iv$iv);
        }
        Map availableNamedParsers = destination$iv$iv;
        Object $this$forEach$iv = parserConfig.getParsers();
        boolean $i$f$forEach = false;
        Map<String, List<String>> capacity$iv22 = $this$forEach$iv;
        boolean $this$associateByTo$iv$iv2 = false;
        destination$iv$iv = capacity$iv22.entrySet().iterator();
        while (destination$iv$iv.hasNext()) {
            void $this$mapNotNullTo$iv$iv;
            Map.Entry element$iv;
            Map.Entry $dstr$mimeType$parserClasses = element$iv = (Map.Entry)destination$iv$iv.next();
            boolean bl = false;
            it = $dstr$mimeType$parserClasses;
            boolean $i$a$-associateBy-ParserFactory$availableNamedParsers$22 = false;
            String mimeType = (String)it.getKey();
            Map.Entry $i$a$-associateBy-ParserFactory$availableNamedParsers$22 = $dstr$mimeType$parserClasses;
            boolean bl2 = false;
            List parserClasses = (List)$i$a$-associateBy-ParserFactory$availableNamedParsers$22.getValue();
            Iterable $this$mapNotNull$iv = parserClasses;
            boolean $i$f$mapNotNull = false;
            Iterable iterable2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Parser parser;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                String name = (String)element$iv$iv;
                boolean bl4 = false;
                if ((Parser)availableNamedParsers.get(name) == null) continue;
                boolean bl5 = false;
                boolean bl6 = false;
                Parser it$iv$iv = parser;
                boolean bl7 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List parsers = (List)destination$iv$iv2;
            Map map3 = this.mineType2Parsers;
            List list = Collections.synchronizedList(parsers);
            Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(parsers)");
            boolean bl8 = false;
            map3.put(mimeType, list);
        }
        $this$forEach$iv = this.mineType2Parsers.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)$this$forEach$iv, (String)"mineType2Parsers.keys");
        Iterable $this$associateWith$iv = (Iterable)$this$forEach$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it2;
            String bl = (String)element$iv$iv;
            string = element$iv$iv;
            map2 = result$iv;
            boolean bl9 = false;
            List<Parser> list = this.mineType2Parsers.get(it2);
            String string2 = list == null ? null : CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, (Function1)2.1.INSTANCE, (int)31, null);
            map2.put(string, string2);
        }
        Map map4 = result$iv;
        boolean bl = false;
        boolean bl10 = false;
        Map it3 = map4;
        boolean bl11 = false;
        new Params(it3).withLogger(LOG).info("Active parsers: ", "", false);
    }

    public ParserFactory(@NotNull Map<String, ? extends List<? extends Parser>> parses, @NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter(parses, (String)"parses");
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(conf);
        this.mineType2Parsers.putAll(parses);
    }

    @NotNull
    public final List<Parser> getParsers(@NotNull String contentType, @NotNull String url) throws ParserNotFound {
        List<Parser> list;
        List<Parser> list2;
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String mimeType = MimeTypeResolver.cleanMimeType(contentType);
        List<Parser> list3 = this.mineType2Parsers.get(mimeType);
        List<Parser> list4 = list2 = list3 == null ? this.mineType2Parsers.get(DEFAULT_MINE_TYPE) : list3;
        if (list2 == null) {
            boolean bl = false;
            list = CollectionsKt.emptyList();
        } else {
            list = list2;
        }
        return list;
    }

    public static /* synthetic */ List getParsers$default(ParserFactory parserFactory, String string, String string2, int n, Object object) throws ParserNotFound {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return parserFactory.getParsers(string, string2);
    }

    private final String escapeContentType(String contentType) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)contentType, (String)"+", (String)"\\+", (boolean)false, (int)4, null), (String)".", (String)"\\.", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String toString() {
        void $this$flatMapTo$iv$iv;
        Collection<List<Parser>> collection = this.mineType2Parsers.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"mineType2Parsers.values");
        Iterable $this$flatMap$iv = collection;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            List it = (List)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            Iterable $this$map$iv = it;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Parser parser = (Parser)item$iv$iv;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                String string = it2.getClass().getSimpleName();
                collection2.add(string);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lai/platon/pulsar/crawl/parse/ParserFactory$Companion;", "", "()V", "DEFAULT_MINE_TYPE", "", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

