/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.parse.html;

import ai.platon.pulsar.persist.metadata.MultiMetadata;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010,\u001a\u00020-J\b\u0010.\u001a\u00020/H\u0016J\u000e\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u0003R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019R\u001c\u0010#\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\t\"\u0004\b%\u0010\u000bR\u001a\u0010&\u001a\u00020'X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+\u00a8\u00062"}, d2={"Lai/platon/pulsar/crawl/parse/html/HTMLMetaTags;", "", "root", "Lorg/w3c/dom/Node;", "currURL", "Ljava/net/URL;", "(Lorg/w3c/dom/Node;Ljava/net/URL;)V", "baseHref", "getBaseHref", "()Ljava/net/URL;", "setBaseHref", "(Ljava/net/URL;)V", "generalTags", "Lai/platon/pulsar/persist/metadata/MultiMetadata;", "getGeneralTags", "()Lai/platon/pulsar/persist/metadata/MultiMetadata;", "httpEquivTags", "Ljava/util/Properties;", "getHttpEquivTags", "()Ljava/util/Properties;", "noCache", "", "getNoCache", "()Z", "setNoCache", "(Z)V", "noFollow", "getNoFollow", "setNoFollow", "noIndex", "getNoIndex", "setNoIndex", "refresh", "getRefresh", "setRefresh", "refreshHref", "getRefreshHref", "setRefreshHref", "refreshTime", "", "getRefreshTime", "()I", "setRefreshTime", "(I)V", "reset", "", "toString", "", "walk", "node", "pulsar-skeleton"})
public final class HTMLMetaTags {
    @Nullable
    private final URL currURL;
    private boolean noIndex;
    private boolean noFollow;
    private boolean noCache;
    @Nullable
    private URL baseHref;
    private boolean refresh;
    private int refreshTime;
    @Nullable
    private URL refreshHref;
    @NotNull
    private final MultiMetadata generalTags;
    @NotNull
    private final Properties httpEquivTags;

    public HTMLMetaTags(@NotNull Node root, @Nullable URL currURL) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.currURL = currURL;
        this.generalTags = new MultiMetadata();
        this.httpEquivTags = new Properties();
        this.walk(root);
    }

    public final boolean getNoIndex() {
        return this.noIndex;
    }

    public final void setNoIndex(boolean bl) {
        this.noIndex = bl;
    }

    public final boolean getNoFollow() {
        return this.noFollow;
    }

    public final void setNoFollow(boolean bl) {
        this.noFollow = bl;
    }

    public final boolean getNoCache() {
        return this.noCache;
    }

    public final void setNoCache(boolean bl) {
        this.noCache = bl;
    }

    @Nullable
    public final URL getBaseHref() {
        return this.baseHref;
    }

    public final void setBaseHref(@Nullable URL uRL) {
        this.baseHref = uRL;
    }

    public final boolean getRefresh() {
        return this.refresh;
    }

    public final void setRefresh(boolean bl) {
        this.refresh = bl;
    }

    public final int getRefreshTime() {
        return this.refreshTime;
    }

    public final void setRefreshTime(int n) {
        this.refreshTime = n;
    }

    @Nullable
    public final URL getRefreshHref() {
        return this.refreshHref;
    }

    public final void setRefreshHref(@Nullable URL uRL) {
        this.refreshHref = uRL;
    }

    @NotNull
    public final MultiMetadata getGeneralTags() {
        return this.generalTags;
    }

    @NotNull
    public final Properties getHttpEquivTags() {
        return this.httpEquivTags;
    }

    public final void reset() {
        this.noIndex = false;
        this.noFollow = false;
        this.noCache = false;
        this.refresh = false;
        this.refreshTime = 0;
        this.baseHref = null;
        this.refreshHref = null;
        this.generalTags.clear();
        this.httpEquivTags.clear();
    }

    public final void walk(@NotNull Node node) {
        int len;
        int n;
        NodeList children;
        block49: {
            Node hrefNode;
            NamedNodeMap attrs;
            block50: {
                int index2;
                String attrName2;
                boolean bl;
                Object attr222;
                int i2;
                Node contentNode;
                Node equivNode;
                Node nameNode;
                block51: {
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    if (node.getNodeType() != 1) break block49;
                    if (StringsKt.equals((String)"body", (String)node.getNodeName(), (boolean)true)) {
                        return;
                    }
                    if (!StringsKt.equals((String)"meta", (String)node.getNodeName(), (boolean)true)) break block50;
                    attrs = node.getAttributes();
                    nameNode = null;
                    equivNode = null;
                    contentNode = null;
                    int n2 = 0;
                    int n3 = attrs.getLength();
                    if (n2 >= n3) break block51;
                    do {
                        i2 = n2++;
                        attr222 = attrs.item(i2);
                        String string = attr222.getNodeName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attr.nodeName");
                        bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(), (String)"(this as java.lang.String).toLowerCase()");
                        int n4 = -1;
                        switch (attrName2.hashCode()) {
                            case 3373707: {
                                if (attrName2.equals("name")) {
                                    n4 = 1;
                                }
                                break;
                            }
                            case -165085519: {
                                if (attrName2.equals("http-equiv")) {
                                    n4 = 2;
                                }
                                break;
                            }
                            case 951530617: {
                                if (attrName2.equals("content")) {
                                    n4 = 3;
                                }
                                break;
                            }
                        }
                        switch (n4) {
                            case 1: {
                                nameNode = attr222;
                                break;
                            }
                            case 2: {
                                equivNode = attr222;
                                break;
                            }
                            case 3: {
                                contentNode = attr222;
                            }
                        }
                    } while (n2 < n3);
                }
                if (nameNode != null && contentNode != null) {
                    String string = nameNode.getNodeValue();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nameNode.nodeValue");
                    i2 = 0;
                    String string2 = string.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
                    String name = string2;
                    this.generalTags.put(name, contentNode.getNodeValue());
                    if (Intrinsics.areEqual((Object)"robots", (Object)name)) {
                        String i2 = contentNode.getNodeValue();
                        Intrinsics.checkNotNullExpressionValue((Object)i2, (String)"contentNode.nodeValue");
                        boolean attr222 = false;
                        String string3 = i2.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
                        String directives = string3;
                        index2 = StringsKt.indexOf$default((CharSequence)directives, (String)"none", (int)0, (boolean)false, (int)6, null);
                        if (index2 >= 0) {
                            this.noIndex = true;
                            this.noFollow = true;
                        }
                        if ((index2 = StringsKt.indexOf$default((CharSequence)directives, (String)"all", (int)0, (boolean)false, (int)6, null)) >= 0) {
                            // empty if block
                        }
                        if ((index2 = StringsKt.indexOf$default((CharSequence)directives, (String)"noindex", (int)0, (boolean)false, (int)6, null)) >= 0) {
                            this.noIndex = true;
                        }
                        if ((index2 = StringsKt.indexOf$default((CharSequence)directives, (String)"nofollow", (int)0, (boolean)false, (int)6, null)) >= 0) {
                            this.noFollow = true;
                        }
                        if ((index2 = StringsKt.indexOf$default((CharSequence)directives, (String)"nocache", (int)0, (boolean)false, (int)6, null)) >= 0) {
                            this.noCache = true;
                        }
                    }
                }
                if (equivNode != null && contentNode != null) {
                    String directives = equivNode.getNodeValue();
                    Intrinsics.checkNotNullExpressionValue((Object)directives, (String)"equivNode.nodeValue");
                    index2 = 0;
                    String string = directives.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase()");
                    String name = string;
                    String content = contentNode.getNodeValue();
                    this.httpEquivTags.setProperty(name, content);
                    if (Intrinsics.areEqual((Object)"pragma", (Object)name)) {
                        String index2 = content;
                        Intrinsics.checkNotNullExpressionValue((Object)index2, (String)"content");
                        boolean attr222 = false;
                        String string4 = index2.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                        String attr222 = content = string4;
                        Intrinsics.checkNotNullExpressionValue((Object)attr222, (String)"content");
                        int index22 = StringsKt.indexOf$default((CharSequence)attr222, (String)"no-cache", (int)0, (boolean)false, (int)6, null);
                        if (index22 >= 0) {
                            this.noCache = true;
                        }
                    } else if (Intrinsics.areEqual((Object)"refresh", (Object)name)) {
                        String string5;
                        attr222 = content;
                        Intrinsics.checkNotNullExpressionValue((Object)attr222, (String)"content");
                        int idx = StringsKt.indexOf$default((CharSequence)((CharSequence)attr222), (char)';', (int)0, (boolean)false, (int)6, null);
                        if (idx == -1) {
                            string5 = content;
                        } else {
                            attrName2 = content;
                            Intrinsics.checkNotNullExpressionValue((Object)attrName2, (String)"content");
                            int n5 = 0;
                            bl = false;
                            String string6 = attrName2.substring(n5, idx);
                            string5 = string6;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        }
                        String time = string5;
                        try {
                            Intrinsics.checkNotNullExpressionValue((Object)time, (String)"time");
                            attrName2 = time;
                            boolean bl2 = false;
                            this.refreshTime = Integer.parseInt(attrName2);
                            this.refresh = true;
                        }
                        catch (Exception attrName2) {
                            // empty catch block
                        }
                        Object refreshUrl = null;
                        if (this.refresh && idx != -1) {
                            String string7 = content;
                            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"content");
                            bl = false;
                            String string8 = string7.toLowerCase();
                            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase()");
                            idx = StringsKt.indexOf$default((CharSequence)string8, (String)"url=", (int)0, (boolean)false, (int)6, null);
                            if (idx == -1) {
                                string7 = content;
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"content");
                                idx = StringsKt.indexOf$default((CharSequence)string7, (char)';', (int)0, (boolean)false, (int)6, null) + 1;
                            } else {
                                idx += 4;
                            }
                            if (idx != -1) {
                                Object object = content;
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"content");
                                boolean bl3 = false;
                                String string9 = ((String)object).substring(idx);
                                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).substring(startIndex)");
                                String url = string9;
                                try {
                                    object = new URL(url);
                                }
                                catch (Exception e) {
                                    URL uRL;
                                    try {
                                        uRL = new URL(this.currURL, url);
                                    }
                                    catch (Exception e1) {
                                        uRL = null;
                                    }
                                    object = uRL;
                                }
                                refreshUrl = object;
                            }
                        }
                        if (this.refresh) {
                            if (refreshUrl == null) {
                                refreshUrl = this.currURL;
                            }
                            this.refreshHref = refreshUrl;
                        }
                    }
                }
                break block49;
            }
            if (StringsKt.equals((String)"base", (String)node.getNodeName(), (boolean)true) && (hrefNode = (attrs = node.getAttributes()).getNamedItem("href")) != null) {
                String urlString = hrefNode.getNodeValue();
                URL url = null;
                try {
                    URL uRL;
                    URL uRL2 = this.currURL;
                    if (uRL2 == null) {
                        uRL = null;
                    } else {
                        URL uRL3 = uRL2;
                        boolean bl = false;
                        boolean bl4 = false;
                        URL it = uRL3;
                        boolean bl5 = false;
                        uRL = new URL(it, urlString);
                    }
                    URL uRL4 = uRL;
                    url = uRL4 == null ? new URL(urlString) : uRL4;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (url != null) {
                    this.baseHref = url;
                }
            }
        }
        if ((children = node.getChildNodes()) != null && (n = 0) < (len = children.getLength())) {
            do {
                int i = n++;
                Node node2 = children.item(i);
                Intrinsics.checkNotNullExpressionValue((Object)node2, (String)"children.item(i)");
                this.walk(node2);
            } while (n < len);
        }
    }

    @NotNull
    public String toString() {
        boolean bl;
        StringBuffer sb = new StringBuffer();
        sb.append("base=" + this.baseHref + ", noCache=" + this.noCache + ", noFollow=" + this.noFollow + ", noIndex=" + this.noIndex + ", refresh=" + this.refresh + ", refreshHref=" + this.refreshHref);
        sb.append(" * general tags:\n");
        Object object = this.generalTags.names();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"generalTags.names()");
        Iterable<Object> $this$forEach$iv = (Set<Object>)object;
        boolean $i$f$forEach = false;
        for (Object t : $this$forEach$iv) {
            String name = (String)t;
            bl = false;
            sb.append("   - " + name + "\t=\t" + this.getGeneralTags().get(name) + "\n");
        }
        sb.append(" * http-equiv tags:\n");
        $this$forEach$iv = this.httpEquivTags.keySet();
        Intrinsics.checkNotNullExpressionValue($this$forEach$iv, (String)"httpEquivTags.keys");
        $this$forEach$iv = $this$forEach$iv;
        $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object object2;
            Object o = object2 = iterator.next();
            bl = false;
            if (o == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            String key = (String)o;
            sb.append("   - " + key + "\t=\t" + this.getHttpEquivTags().get(key) + "\n");
        }
        object = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
        return object;
    }
}

