/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.parse.html;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.crawl.LoadEvent;
import ai.platon.pulsar.crawl.event.HTMLDocumentEventHandler;
import ai.platon.pulsar.crawl.event.WebPageEventHandler;
import ai.platon.pulsar.crawl.parse.ParseFilters;
import ai.platon.pulsar.crawl.parse.ParseResult;
import ai.platon.pulsar.crawl.parse.Parser;
import ai.platon.pulsar.crawl.parse.html.ParseContext;
import ai.platon.pulsar.crawl.parse.html.PrimerParser;
import ai.platon.pulsar.dom.FeaturedDocument;
import ai.platon.pulsar.persist.WebPage;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lai/platon/pulsar/crawl/parse/html/PrimerHtmlParser;", "Lai/platon/pulsar/crawl/parse/Parser;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "parseFilters", "Lai/platon/pulsar/crawl/parse/ParseFilters;", "(Lai/platon/pulsar/crawl/parse/ParseFilters;Lai/platon/pulsar/common/config/ImmutableConfig;)V", "defaultCharEncoding", "", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "primerParser", "Lai/platon/pulsar/crawl/parse/html/PrimerParser;", "tracer", "getParams", "Lai/platon/pulsar/common/config/Params;", "onHTMLDocumentParsed", "", "page", "Lai/platon/pulsar/persist/WebPage;", "document", "Lai/platon/pulsar/dom/FeaturedDocument;", "onWillParseHTMLDocument", "parse", "Lai/platon/pulsar/crawl/parse/ParseResult;", "Companion", "pulsar-skeleton"})
public final class PrimerHtmlParser
implements Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ParseFilters parseFilters;
    @NotNull
    private final ImmutableConfig conf;
    private final Logger logger;
    @Nullable
    private final Logger tracer;
    @NotNull
    private final String defaultCharEncoding;
    @NotNull
    private final PrimerParser primerParser;
    @NotNull
    private static final AtomicInteger numHtmlParses = new AtomicInteger();
    @NotNull
    private static final AtomicInteger numHtmlParsed = new AtomicInteger();

    /*
     * WARNING - void declaration
     */
    public PrimerHtmlParser(@Nullable ParseFilters parseFilters, @NotNull ImmutableConfig conf) {
        void it;
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.parseFilters = parseFilters;
        this.conf = conf;
        Logger logger = this.logger = LoggerFactory.getLogger(PrimerHtmlParser.class);
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = logger;
        PrimerHtmlParser primerHtmlParser = this;
        boolean bl3 = false;
        boolean bl4 = it.isDebugEnabled();
        primerHtmlParser.tracer = bl4 ? logger : null;
        this.defaultCharEncoding = this.conf.get("parser.character.encoding.default", "utf-8");
        this.primerParser = new PrimerParser(this.conf);
        this.logger.info(this.getParams().formatAsLine());
    }

    public /* synthetic */ PrimerHtmlParser(ParseFilters parseFilters, ImmutableConfig immutableConfig, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            parseFilters = null;
        }
        this(parseFilters, immutableConfig);
    }

    public PrimerHtmlParser(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this(null, conf);
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"defaultCharEncoding", this.defaultCharEncoding, "parseFilters", this.parseFilters};
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n            \"classNa\u2026\", parseFilters\n        )");
        return params;
    }

    @Override
    @NotNull
    public ParseResult parse(@NotNull WebPage page) {
        ParseResult parseResult;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        try {
            this.onWillParseHTMLDocument(page);
            ParseContext parseContext = this.primerParser.parseHTMLDocument(page);
            ParseFilters parseFilters = this.parseFilters;
            if (parseFilters != null) {
                parseFilters.filter(parseContext);
            }
            parseFilters = parseContext.getDocument();
            if (parseFilters != null) {
                ParseFilters parseFilters2 = parseFilters;
                boolean bl = false;
                boolean bl2 = false;
                ParseFilters it = parseFilters2;
                boolean bl3 = false;
                this.onHTMLDocumentParsed(page, (FeaturedDocument)it);
            }
            parseResult = parseContext.getParseResult();
        }
        catch (MalformedURLException e) {
            parseResult = ParseResult.Companion.failed(207, e.getMessage());
        }
        catch (Exception e) {
            parseResult = ParseResult.Companion.failed(203, e.getMessage());
        }
        return parseResult;
    }

    private final void onWillParseHTMLDocument(WebPage page) {
        numHtmlParses.incrementAndGet();
        try {
            WebPageEventHandler webPageEventHandler;
            LoadEvent loadEvent = WebPageExKt.getLoadEvent(page);
            if (loadEvent != null && (webPageEventHandler = loadEvent.getOnWillParseHTMLDocument()) != null) {
                webPageEventHandler.invoke(page);
            }
        }
        catch (Throwable e) {
            this.logger.warn("Failed to invoke onWillParseHTMLDocument | " + page.getConfiguredUrl(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onHTMLDocumentParsed(WebPage page, FeaturedDocument document) {
        try {
            LoadEvent loadEvent = WebPageExKt.getLoadEvent(page);
            if (loadEvent == null) {
            } else {
                HTMLDocumentEventHandler hTMLDocumentEventHandler = loadEvent.getOnHTMLDocumentParsed();
                if (hTMLDocumentEventHandler == null) {
                } else {
                    hTMLDocumentEventHandler.invoke(page, document);
                }
            }
        }
        catch (Throwable e) {
            this.logger.warn("Failed to invoke onHTMLDocumentParsed | " + page.getConfiguredUrl(), e);
        }
        finally {
            numHtmlParsed.incrementAndGet();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lai/platon/pulsar/crawl/parse/html/PrimerHtmlParser$Companion;", "", "()V", "numHtmlParsed", "Ljava/util/concurrent/atomic/AtomicInteger;", "getNumHtmlParsed", "()Ljava/util/concurrent/atomic/AtomicInteger;", "numHtmlParses", "getNumHtmlParses", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicInteger getNumHtmlParses() {
            return numHtmlParses;
        }

        @NotNull
        public final AtomicInteger getNumHtmlParsed() {
            return numHtmlParsed;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

