/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.protocol;

import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.ResourceLoader;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.protocol.Protocol;
import ai.platon.pulsar.crawl.protocol.ProtocolNotFound;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.FetchMode;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u0004\u0018\u00010\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0018\u001a\u00020\fR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lai/platon/pulsar/crawl/protocol/ProtocolFactory;", "Ljava/lang/AutoCloseable;", "immutableConfig", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "protocols", "", "", "Lai/platon/pulsar/crawl/protocol/Protocol;", "close", "", "getInstance", "config", "", "getProtocol", "page", "Lai/platon/pulsar/persist/WebPage;", "mode", "Lai/platon/pulsar/persist/metadata/FetchMode;", "url", "pulsar-skeleton"})
public final class ProtocolFactory
implements AutoCloseable {
    @NotNull
    private final ImmutableConfig immutableConfig;
    private final Logger logger;
    @NotNull
    private final Map<String, Protocol> protocols;
    @NotNull
    private final AtomicBoolean closed;

    /*
     * WARNING - void declaration
     */
    public ProtocolFactory(@NotNull ImmutableConfig immutableConfig) {
        Map map2;
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)immutableConfig, (String)"immutableConfig");
        this.immutableConfig = immutableConfig;
        this.logger = LoggerFactory.getLogger(ProtocolFactory.class);
        this.protocols = new ConcurrentHashMap();
        this.closed = new AtomicBoolean();
        Sequence $this$associate$iv = SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)ResourceLoader.INSTANCE.readAllLines("protocol-plugins.txt")), (Function1)1.INSTANCE), (Function1)2.INSTANCE), (Function1)3.INSTANCE), (Function1)4.INSTANCE), (Function1)((Function1)new Function1<List<? extends String>, Pair<? extends String, ? extends Protocol>>(){

            @NotNull
            public final Pair<String, Protocol> invoke(@NotNull List<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return TuplesKt.to((Object)it.get(0), (Object)this.getInstance(it));
            }
        })), (Function1)6.INSTANCE);
        boolean $i$f$associate = false;
        Object object = $this$associate$iv;
        Map destination$iv$iv22 = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            map2 = destination$iv$iv22;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Object object2 = it.getFirst();
            Object object3 = it.getSecond();
            Intrinsics.checkNotNull((Object)object3);
            Pair pair = TuplesKt.to((Object)object2, (Object)object3);
            boolean bl2 = false;
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map $this$onEach$iv = destination$iv$iv22;
        boolean $i$f$onEach = false;
        object = $this$onEach$iv;
        boolean destination$iv$iv22 = false;
        $i$f$associateTo = false;
        Object $this$apply$iv = object;
        boolean bl = false;
        map2 = $this$apply$iv;
        boolean bl3 = false;
        Iterator iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl4 = false;
            ((Protocol)it.getValue()).setConf(this.immutableConfig);
        }
        MapsKt.toMap((Map)object, this.protocols);
        String string = CollectionsKt.joinToString$default((Iterable)this.protocols.keySet(), (CharSequence)", ", (CharSequence)"Supported protocols: ", (CharSequence)"", (int)0, null, null, (int)56, null);
        boolean bl5 = false;
        boolean bl6 = false;
        String it = string;
        boolean bl7 = false;
        this.logger.info(it);
    }

    @NotNull
    public final Protocol getProtocol(@NotNull WebPage page) {
        Protocol protocol;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        FetchMode fetchMode = page.getFetchMode();
        boolean bl = false;
        boolean bl2 = false;
        FetchMode it = fetchMode;
        boolean bl3 = false;
        Object object = it != FetchMode.UNKNOWN ? fetchMode : null;
        Object object2 = object == null ? FetchMode.BROWSER : object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"page.fetchMode.takeIf { \u2026WN } ?: FetchMode.BROWSER");
        FetchMode fetchMode2 = object2;
        page.setFetchMode(fetchMode2);
        object = fetchMode2;
        int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        if (n == 1) {
            protocol = this.getProtocol("browser:" + page.getUrl());
        } else {
            String string = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
            protocol = object2 = this.getProtocol(string);
        }
        if (object2 == null) {
            object = page.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.url");
            throw new ProtocolNotFound((String)object, null, 2, null);
        }
        return object2;
    }

    @Nullable
    public final Protocol getProtocol(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String protocolName = StringUtils.substringBefore((String)url, (String)":");
        return this.protocols.get(protocolName);
    }

    @Nullable
    public final Protocol getProtocol(@NotNull FetchMode mode) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        String string = mode.name();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        return this.getProtocol(string3 + "://");
    }

    private final Protocol getInstance(List<String> config) {
        try {
            String className = config.get(1);
            Constructor<?>[] constructorArray = Class.forName(className).getConstructors();
            Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"forName(className).constructors");
            Object t = ((Constructor)ArraysKt.first((Object[])constructorArray)).newInstance(new Object[0]);
            if (t == null) {
                throw new NullPointerException("null cannot be cast to non-null type ai.platon.pulsar.crawl.protocol.Protocol");
            }
            return (Protocol)t;
        }
        catch (ClassNotFoundException e) {
            this.logger.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
        catch (InstantiationException e) {
            this.logger.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
        catch (IllegalAccessException e) {
            this.logger.error(ExceptionsKt.stringify$default((Throwable)e, null, null, (int)3, null));
        }
        return null;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            Iterable $this$forEach$iv = this.protocols.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Protocol protocol = (Protocol)element$iv;
                boolean bl = false;
                try {
                    protocol.close();
                }
                catch (Throwable e) {
                    this.logger.error(e.toString());
                }
            }
            this.protocols.clear();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FetchMode.values().length];
            nArray[FetchMode.BROWSER.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

