/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.protocol;

import ai.platon.pulsar.common.config.Configurable;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.crawl.protocol.Protocol;
import com.google.common.io.Files;
import crawlercommons.robots.BaseRobotRules;
import crawlercommons.robots.SimpleRobotRules;
import crawlercommons.robots.SimpleRobotRulesParser;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\f\u001a\u00020\u0004H\u0017J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H'J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0007J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0007H\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0004H\u0016J\b\u0010\u001b\u001a\u00020\u0019H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lai/platon/pulsar/crawl/protocol/RobotRulesParser;", "Lai/platon/pulsar/common/config/Configurable;", "()V", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "(Lai/platon/pulsar/common/config/ImmutableConfig;)V", "agentNames", "", "getAgentNames", "()Ljava/lang/String;", "setAgentNames", "(Ljava/lang/String;)V", "getConf", "getRobotRulesSet", "Lcrawlercommons/robots/BaseRobotRules;", "protocol", "Lai/platon/pulsar/crawl/protocol/Protocol;", "url", "Ljava/net/URL;", "parseRules", "content", "", "contentType", "robotName", "setConf", "", "jobConf", "setup", "Companion", "pulsar-skeleton"})
public abstract class RobotRulesParser
implements Configurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected String agentNames;
    private ImmutableConfig conf;
    private static final Logger LOG = LoggerFactory.getLogger(RobotRulesParser.class);
    @JvmField
    @NotNull
    public static final BaseRobotRules EMPTY_RULES = (BaseRobotRules)new SimpleRobotRules(SimpleRobotRules.RobotRulesMode.ALLOW_ALL);
    @NotNull
    private static final Hashtable<String, BaseRobotRules> CACHE = new Hashtable();
    @NotNull
    private static BaseRobotRules FORBID_ALL_RULES = (BaseRobotRules)new SimpleRobotRules(SimpleRobotRules.RobotRulesMode.ALLOW_NONE);
    @NotNull
    private static final SimpleRobotRulesParser robotParser = new SimpleRobotRulesParser();

    @NotNull
    protected final String getAgentNames() {
        String string = this.agentNames;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"agentNames");
        return null;
    }

    protected final void setAgentNames(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.agentNames = string;
    }

    public RobotRulesParser() {
    }

    public RobotRulesParser(@NotNull ImmutableConfig conf) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.setConf(conf);
    }

    private final void setup() {
        ImmutableConfig immutableConfig;
        ImmutableConfig immutableConfig2;
        ImmutableConfig immutableConfig3 = this.conf;
        if (immutableConfig3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"conf");
            immutableConfig2 = null;
        } else {
            immutableConfig2 = immutableConfig3;
        }
        CharSequence $this$trim$iv = immutableConfig2.get("http.agent.name", "");
        boolean $i$f$trim22 = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String ua = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        $this$trim$iv = ua;
        $i$f$trim22 = false;
        if ($this$trim$iv.length() == 0) {
            // empty if block
        }
        this.setAgentNames(ua);
        ImmutableConfig $i$f$trim22 = this.conf;
        if ($i$f$trim22 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"conf");
            immutableConfig = null;
        } else {
            immutableConfig = $i$f$trim22;
        }
        String otherAgents = immutableConfig.get("http.robots.agents");
        if (otherAgents != null) {
            CharSequence $this$trim$iv2 = otherAgents;
            boolean $i$f$trim3 = false;
            CharSequence $this$trim$iv$iv2 = $this$trim$iv2;
            boolean $i$f$trim42 = false;
            int startIndex$iv$iv2 = 0;
            int endIndex$iv$iv2 = $this$trim$iv$iv2.length() - 1;
            boolean startFound$iv$iv2 = false;
            while (startIndex$iv$iv2 <= endIndex$iv$iv2) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv2 ? startIndex$iv$iv2 : endIndex$iv$iv2;
                char it = $this$trim$iv$iv2.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv2) {
                    if (!match$iv$iv) {
                        startFound$iv$iv2 = true;
                        continue;
                    }
                    ++startIndex$iv$iv2;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv2;
            }
            $this$trim$iv2 = ((Object)$this$trim$iv$iv2.subSequence(startIndex$iv$iv2, endIndex$iv$iv2 + 1)).toString();
            $i$f$trim3 = false;
            if (!($this$trim$iv2.length() == 0)) {
                StringTokenizer tok = new StringTokenizer(otherAgents, ",");
                StringBuilder sb = new StringBuilder(this.getAgentNames());
                while (tok.hasMoreTokens()) {
                    String str;
                    String $i$f$trim42 = tok.nextToken();
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$trim42, (String)"tok.nextToken()");
                    String $this$trim$iv3 = $i$f$trim42;
                    boolean $i$f$trim5 = false;
                    CharSequence $this$trim$iv$iv3 = $this$trim$iv3;
                    boolean $i$f$trim6 = false;
                    int startIndex$iv$iv3 = 0;
                    int endIndex$iv$iv3 = $this$trim$iv$iv3.length() - 1;
                    boolean startFound$iv$iv3 = false;
                    while (startIndex$iv$iv3 <= endIndex$iv$iv3) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv3 ? startIndex$iv$iv3 : endIndex$iv$iv3;
                        char it = $this$trim$iv$iv3.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv3) {
                            if (!match$iv$iv) {
                                startFound$iv$iv3 = true;
                                continue;
                            }
                            ++startIndex$iv$iv3;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv3;
                    }
                    if (Intrinsics.areEqual((Object)(str = ((Object)$this$trim$iv$iv3.subSequence(startIndex$iv$iv3, endIndex$iv$iv3 + 1)).toString()), (Object)"*") || Intrinsics.areEqual((Object)str, (Object)this.getAgentNames())) continue;
                    sb.append(",").append(str);
                }
                String string = sb.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
                this.setAgentNames(string);
            }
        }
    }

    @NotNull
    public ImmutableConfig getConf() {
        ImmutableConfig immutableConfig;
        ImmutableConfig immutableConfig2 = this.conf;
        if (immutableConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"conf");
            immutableConfig = null;
        } else {
            immutableConfig = immutableConfig2;
        }
        return immutableConfig;
    }

    public void setConf(@NotNull ImmutableConfig jobConf) {
        Intrinsics.checkNotNullParameter((Object)jobConf, (String)"jobConf");
        this.conf = jobConf;
        this.setup();
    }

    @NotNull
    public final BaseRobotRules parseRules(@NotNull String url, @NotNull byte[] content, @NotNull String contentType, @NotNull String robotName) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)robotName, (String)"robotName");
        BaseRobotRules baseRobotRules = robotParser.parseContent(url, content, contentType, robotName);
        Intrinsics.checkNotNullExpressionValue((Object)baseRobotRules, (String)"robotParser.parseContent\u2026, contentType, robotName)");
        return baseRobotRules;
    }

    @NotNull
    public final BaseRobotRules getRobotRulesSet(@NotNull Protocol protocol, @NotNull String url) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            uRL = new URL(url);
        }
        catch (Exception e) {
            return EMPTY_RULES;
        }
        URL u = uRL;
        return this.getRobotRulesSet(protocol, u);
    }

    @NotNull
    public abstract BaseRobotRules getRobotRulesSet(@NotNull Protocol var1, @NotNull URL var2);

    @JvmStatic
    public static final void main(@NotNull String[] argv) {
        Companion.main(argv);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0019H\u0007\u00a2\u0006\u0002\u0010\u001aR\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0019\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lai/platon/pulsar/crawl/protocol/RobotRulesParser$Companion;", "", "()V", "CACHE", "Ljava/util/Hashtable;", "", "Lcrawlercommons/robots/BaseRobotRules;", "getCACHE", "()Ljava/util/Hashtable;", "EMPTY_RULES", "FORBID_ALL_RULES", "getFORBID_ALL_RULES", "()Lcrawlercommons/robots/BaseRobotRules;", "setFORBID_ALL_RULES", "(Lcrawlercommons/robots/BaseRobotRules;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lorg/slf4j/Logger;", "robotParser", "Lcrawlercommons/robots/SimpleRobotRulesParser;", "main", "", "argv", "", "([Ljava/lang/String;)V", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLOG() {
            return LOG;
        }

        @NotNull
        public final Hashtable<String, BaseRobotRules> getCACHE() {
            return CACHE;
        }

        @NotNull
        public final BaseRobotRules getFORBID_ALL_RULES() {
            return FORBID_ALL_RULES;
        }

        public final void setFORBID_ALL_RULES(@NotNull BaseRobotRules baseRobotRules) {
            Intrinsics.checkNotNullParameter((Object)baseRobotRules, (String)"<set-?>");
            FORBID_ALL_RULES = baseRobotRules;
        }

        @JvmStatic
        public final void main(@NotNull String[] argv) {
            Intrinsics.checkNotNullParameter((Object)argv, (String)"argv");
            if (argv.length != 3) {
                System.err.println("Usage: RobotRulesParser <robots-file> <url-file> <agent-names>\n");
                System.err.println("    <robots-file> - Input robots.txt file which will be parsed.");
                System.err.println("    <url-file>    - Contains input URLs (1 per line) which are tested against the rules.");
                System.err.println("    <agent-names> - Input agent names. Multiple agent names can be provided using");
                System.err.println("                    comma as a delimiter without any spaces.");
                int n = -1;
                boolean bl = false;
                System.exit(n);
                throw (Throwable)new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            try {
                byte[] robotsBytes = Files.toByteArray((File)new File(argv[0]));
                BaseRobotRules rules = robotParser.parseContent(argv[0], robotsBytes, "text/plain", argv[2]);
                LineNumberReader testsIn = new LineNumberReader(new FileReader(argv[1]));
                Object object = testsIn.readLine();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"testsIn.readLine()");
                String $this$trim$iv = object;
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                String testPath = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                while (testPath != null) {
                    object = (rules.isAllowed(testPath) ? "allowed" : "not allowed") + ":\t" + testPath;
                    boolean bl = false;
                    System.out.println(object);
                    testPath = testsIn.readLine();
                }
                testsIn.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

