/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.protocol.http;

import ai.platon.pulsar.common.AppContext;
import ai.platon.pulsar.common.ExceptionsKt;
import ai.platon.pulsar.common.IllegalApplicationContextStateException;
import ai.platon.pulsar.common.MimeTypeResolver;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.VolatileConfig;
import ai.platon.pulsar.crawl.protocol.ForwardingResponse;
import ai.platon.pulsar.crawl.protocol.Protocol;
import ai.platon.pulsar.crawl.protocol.ProtocolOutput;
import ai.platon.pulsar.crawl.protocol.Response;
import ai.platon.pulsar.crawl.protocol.http.AbstractHttpProtocol;
import ai.platon.pulsar.crawl.protocol.http.HttpRobotRulesParser;
import ai.platon.pulsar.crawl.protocol.http.ProtocolStatusTranslator;
import ai.platon.pulsar.persist.PageDatum;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.RetryScope;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.FetchMode;
import ai.platon.pulsar.persist.metadata.MultiMetadata;
import ai.platon.pulsar.persist.metadata.Name;
import crawlercommons.robots.BaseRobotRules;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 B2\u00020\u0001:\u0001BB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\bH\u0016J\"\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nH\u0002J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0016J\u0019\u0010(\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0010\u0010*\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010$2\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020\fH&J#\u0010-\u001a\u0004\u0018\u00010$2\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020\fH\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J$\u0010/\u001a\b\u0012\u0004\u0012\u00020$002\f\u00101\u001a\b\u0012\u0004\u0012\u00020'002\u0006\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002052\u0006\u0010&\u001a\u00020'H\u0016J\b\u00106\u001a\u00020\u0018H\u0016J&\u00107\u001a\u0004\u0018\u00010\"2\b\u00108\u001a\u0004\u0018\u00010\"2\u0006\u0010!\u001a\u00020\"2\b\u00109\u001a\u0004\u0018\u00010:H\u0002J\u0010\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020\bH\u0016J \u0010=\u001a\u00020\u00182\u0006\u0010>\u001a\u00020?2\u0006\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010@\u001a\u00020\f2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010A\u001a\u00020\"H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u0016\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006C"}, d2={"Lai/platon/pulsar/crawl/protocol/http/AbstractHttpProtocol;", "Lai/platon/pulsar/crawl/protocol/Protocol;", "()V", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getClosed", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "fetchMaxRetry", "", "isActive", "", "()Z", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "mimeTypeResolver", "Lai/platon/pulsar/common/MimeTypeResolver;", "robots", "Lai/platon/pulsar/crawl/protocol/http/HttpRobotRulesParser;", "supportParallel", "getSupportParallel", "close", "", "getConf", "getFailedResponse", "Lai/platon/pulsar/crawl/protocol/ProtocolOutput;", "lastThrowable", "", "tryCount", "maxRry", "getOutputWithHttpCodeTranslated", "url", "", "response", "Lai/platon/pulsar/crawl/protocol/Response;", "getProtocolOutput", "page", "Lai/platon/pulsar/persist/WebPage;", "getProtocolOutputDeferred", "(Lai/platon/pulsar/persist/WebPage;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getProtocolOutputWithRetry", "getResponse", "followRedirects", "getResponseDeferred", "(Lai/platon/pulsar/persist/WebPage;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getResponses", "", "pages", "volatileConfig", "Lai/platon/pulsar/common/config/VolatileConfig;", "getRobotRules", "Lcrawlercommons/robots/BaseRobotRules;", "reset", "resolveMimeType", "contentType", "data", "", "setConf", "jobConf", "setResponseTime", "startTime", "Ljava/time/Instant;", "shouldRetry", "toString", "Companion", "pulsar-skeleton"})
public abstract class AbstractHttpProtocol
implements Protocol {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = LoggerFactory.getLogger(AbstractHttpProtocol.class);
    @NotNull
    private final AtomicBoolean closed = new AtomicBoolean();
    private final boolean supportParallel;
    private int fetchMaxRetry = 3;
    private ImmutableConfig conf;
    private MimeTypeResolver mimeTypeResolver;
    private HttpRobotRulesParser robots;
    private static final int MAX_REY_GUARD = 10;

    public AbstractHttpProtocol() {
        this.supportParallel = true;
    }

    @NotNull
    protected final AtomicBoolean getClosed() {
        return this.closed;
    }

    public final boolean isActive() {
        return !this.closed.get() && AppContext.INSTANCE.isActive();
    }

    @Override
    public boolean getSupportParallel() {
        return this.supportParallel;
    }

    @NotNull
    public ImmutableConfig getConf() {
        ImmutableConfig immutableConfig;
        ImmutableConfig immutableConfig2 = this.conf;
        if (immutableConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"conf");
            immutableConfig = null;
        } else {
            immutableConfig = immutableConfig2;
        }
        return immutableConfig;
    }

    public void setConf(@NotNull ImmutableConfig jobConf) {
        Intrinsics.checkNotNullParameter((Object)jobConf, (String)"jobConf");
        this.conf = jobConf;
        this.fetchMaxRetry = jobConf.getInt("http.fetch.max.retry", 3);
        this.mimeTypeResolver = new MimeTypeResolver(jobConf);
        this.robots = new HttpRobotRulesParser(jobConf);
    }

    @Override
    public void reset() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<Response> getResponses(@NotNull Collection<WebPage> pages, @NotNull VolatileConfig volatileConfig) {
        Collection collection;
        List list;
        Collection<WebPage> collection2;
        Intrinsics.checkNotNullParameter(pages, (String)"pages");
        Intrinsics.checkNotNullParameter((Object)volatileConfig, (String)"volatileConfig");
        Iterable<Object> iterable = pages;
        boolean bl = false;
        boolean bl2 = false;
        Collection<WebPage> it = iterable;
        boolean bl3 = false;
        Collection<Object> collection3 = collection2 = this.isActive() ? iterable : null;
        if (collection2 == null) {
            list = null;
        } else {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            iterable = collection2;
            boolean $i$f$mapNotNull = false;
            void var7_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Response response2;
                Object object;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl4 = false;
                WebPage it2 = (WebPage)element$iv$iv;
                boolean bl5 = false;
                WebPage webPage = it2;
                boolean bl6 = false;
                try {
                    object = Result.Companion;
                    WebPage $this$getResponses_u24lambda_u2d3_u24lambda_u2d1 = webPage;
                    boolean bl7 = false;
                    Response response3 = this.getResponse(it2, false);
                    boolean bl8 = false;
                    object = Result.constructor-impl((Object)response3);
                }
                catch (Throwable throwable) {
                    Result.Companion companion = Result.Companion;
                    boolean bl9 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                webPage = object;
                bl6 = false;
                boolean bl10 = false;
                if (Result.exceptionOrNull-impl((Object)webPage) != null) {
                    Throwable throwable;
                    boolean bl11 = false;
                    boolean bl12 = false;
                    Throwable throwable2 = throwable;
                    boolean bl13 = false;
                    Throwable it3 = throwable2;
                    boolean bl14 = false;
                    this.log.warn(it3.getMessage());
                }
                bl6 = false;
                if ((Response)(Result.isFailure-impl((Object)webPage) ? null : webPage) == null) continue;
                boolean bl15 = false;
                boolean bl16 = false;
                Response it$iv$iv = response2;
                boolean bl17 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        }
        List list2 = list;
        if (list2 == null) {
            boolean bl18 = false;
            collection = CollectionsKt.emptyList();
        } else {
            collection = list2;
        }
        return collection;
    }

    @Override
    @NotNull
    public ProtocolOutput getProtocolOutput(@NotNull WebPage page) {
        ProtocolOutput protocolOutput;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        try {
            protocolOutput = this.getProtocolOutputWithRetry(page);
        }
        catch (Throwable e) {
            this.log.warn("Unexpected exception", e);
            ProtocolStatus protocolStatus = ProtocolStatus.failed((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus, (String)"failed(e)");
            protocolOutput = new ProtocolOutput(protocolStatus);
        }
        return protocolOutput;
    }

    @Override
    @Nullable
    public Object getProtocolOutputDeferred(@NotNull WebPage page, @NotNull Continuation<? super ProtocolOutput> $completion) {
        return AbstractHttpProtocol.getProtocolOutputDeferred$suspendImpl(this, page, $completion);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object getProtocolOutputDeferred$suspendImpl(AbstractHttpProtocol var0, WebPage var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof getProtocolOutputDeferred.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, (Continuation<? super getProtocolOutputDeferred.1>)var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ AbstractHttpProtocol this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return AbstractHttpProtocol.getProtocolOutputDeferred$suspendImpl(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                startTime = Instant.now();
                $continuation.L$0 = this;
                $continuation.L$1 = page;
                $continuation.L$2 = startTime;
                $continuation.label = 1;
                v0 = this.getResponseDeferred(page, false, (Continuation<? super Response>)$continuation);
                if (v0 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl27
            }
            case 1: {
                startTime = (Instant)$continuation.L$2;
                page = (WebPage)$continuation.L$1;
                this = (AbstractHttpProtocol)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl27:
                // 2 sources

                if ((var5_7 = (Response)v0) == null) {
                    var6_8 = ProtocolStatus.retry((RetryScope)RetryScope.CRAWL);
                    Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"retry(RetryScope.CRAWL)");
                    return new ProtocolOutput(var6_8);
                }
                response = var5_7;
                Intrinsics.checkNotNullExpressionValue((Object)startTime, (String)"startTime");
                this.setResponseTime(startTime, page, response);
                var5_7 = page.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"page.url");
                return this.getOutputWithHttpCodeTranslated((String)var5_7, response);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final ProtocolOutput getProtocolOutputWithRetry(WebPage page) {
        Object object;
        Instant startTime = Instant.now();
        Response response2 = null;
        boolean retry = false;
        Throwable lastThrowable = null;
        int i = 0;
        int maxTry = RangesKt.coerceAtMost((int)this.fetchMaxRetry, (int)10);
        do {
            if (i > 0) {
                object = new Object[]{i, maxTry, page.getUrl()};
                this.log.info("Protocol retry: {}/{} | {}", (Object[])object);
            }
            try {
                response2 = this.getResponse(page, false);
                retry = response2 == null || this.shouldRetry(response2);
            }
            catch (IllegalApplicationContextStateException e) {
                this.log.warn(e.getMessage());
                response2 = null;
                lastThrowable = e;
            }
            catch (Exception e) {
                response2 = null;
                lastThrowable = e;
                this.log.warn(ExceptionsKt.brief$default((Throwable)e, (String)"[Unexpected]", null, (int)2, null));
            }
            catch (Throwable t) {
                response2 = null;
                lastThrowable = t;
                this.log.warn(ExceptionsKt.stringify$default((Throwable)t, (String)"[Unexpected]", null, (int)2, null));
            }
        } while (retry && ++i < maxTry && this.isActive());
        if (!this.isActive()) {
            object = ProtocolStatus.failed((int)1602);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"failed(ProtocolStatusCodes.CANCELED)");
            return new ProtocolOutput((ProtocolStatus)object);
        }
        if (response2 == null) {
            return this.getFailedResponse(lastThrowable, i, maxTry);
        }
        Intrinsics.checkNotNullExpressionValue((Object)startTime, (String)"startTime");
        this.setResponseTime(startTime, page, response2);
        object = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.url");
        return this.getOutputWithHttpCodeTranslated((String)object, response2);
    }

    private final boolean shouldRetry(Response response2) {
        return !(response2 instanceof ForwardingResponse) && response2.getProtocolStatus().isRetry(RetryScope.PROTOCOL);
    }

    private final ProtocolOutput getOutputWithHttpCodeTranslated(String url, Response response2) {
        URL u = new URL(url);
        int httpCode = response2.getHttpCode();
        PageDatum pageDatum = response2.getPageDatum();
        byte[] content = pageDatum.getContent();
        String contentType = response2.getHeader("Content-Type");
        pageDatum.setContentType(this.resolveMimeType(contentType, url, content));
        MultiMetadata headers = pageDatum.getHeaders();
        ProtocolStatus finalProtocolStatus = httpCode >= 1000 ? response2.getProtocolStatus() : ProtocolStatusTranslator.INSTANCE.translateHttpCode(httpCode);
        int n = httpCode;
        boolean bl = 300 <= n ? n <= 399 : false;
        if (bl) {
            String string;
            Object object = response2.getHeader("Location");
            String redirect = object == null ? ((string = response2.getHeader("location")) == null ? "" : string) : object;
            u = new URL(u, redirect);
            object = finalProtocolStatus.getArgs();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"finalProtocolStatus.args");
            string = "redirectTo";
            String string2 = u.toString();
            boolean bl2 = false;
            object.put(string, string2);
        }
        return new ProtocolOutput(pageDatum, headers, finalProtocolStatus);
    }

    private final String resolveMimeType(String contentType, String url, byte[] data) {
        MimeTypeResolver mimeTypeResolver;
        MimeTypeResolver mimeTypeResolver2 = this.mimeTypeResolver;
        if (mimeTypeResolver2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mimeTypeResolver");
            mimeTypeResolver = null;
        } else {
            mimeTypeResolver = mimeTypeResolver2;
        }
        return mimeTypeResolver.autoResolveContentType(contentType, url, data);
    }

    private final ProtocolOutput getFailedResponse(Throwable lastThrowable, int tryCount, int maxRry) {
        Throwable throwable = lastThrowable;
        int code = throwable instanceof ConnectException ? 408 : (throwable instanceof SocketTimeoutException ? 408 : (throwable instanceof UnknownHostException ? 1460 : 1462));
        Object[] objectArray = new Object[]{"exception", lastThrowable, "retry", tryCount, "maxRetry", maxRry};
        ProtocolStatus protocolStatus = ProtocolStatus.failed((int)code, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)protocolStatus, (String)"failed(code,\n           \u2026      \"maxRetry\", maxRry)");
        ProtocolStatus protocolStatus2 = protocolStatus;
        return new ProtocolOutput(null, new MultiMetadata(), protocolStatus2);
    }

    private final void setResponseTime(Instant startTime, WebPage page, Response response2) {
        Duration duration;
        FetchMode fetchMode = page.getFetchMode();
        Intrinsics.checkNotNullExpressionValue((Object)fetchMode, (String)"page.fetchMode");
        FetchMode pageFetchMode = fetchMode;
        if (pageFetchMode == FetchMode.BROWSER) {
            Long l;
            long responseTime;
            Long l2;
            String string = response2.getHeader("Q-Request-Time");
            long requestTime = string == null ? -1L : ((l2 = StringsKt.toLongOrNull((String)string)) == null ? -1L : l2);
            String string2 = response2.getHeader("Q-Response-Time");
            long l3 = string2 == null ? -1L : (responseTime = (l = StringsKt.toLongOrNull((String)string2)) == null ? -1L : l);
            duration = requestTime > 0L && responseTime > 0L ? Duration.ofMillis(responseTime - requestTime) : Duration.ZERO;
        } else {
            duration = Duration.between(startTime, Instant.now());
        }
        Duration elapsedTime = duration;
        page.getMetadata().set(Name.RESPONSE_TIME, elapsedTime.toString());
    }

    @Nullable
    public abstract Response getResponse(@NotNull WebPage var1, boolean var2) throws Exception;

    @Nullable
    public abstract Object getResponseDeferred(@NotNull WebPage var1, boolean var2, @NotNull Continuation<? super Response> var3) throws Exception;

    @Override
    @NotNull
    public BaseRobotRules getRobotRules(@NotNull WebPage page) {
        HttpRobotRulesParser httpRobotRulesParser;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Object object = this.robots;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"robots");
            httpRobotRulesParser = null;
        } else {
            httpRobotRulesParser = object;
        }
        Protocol protocol = this;
        object = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"page.url");
        return httpRobotRulesParser.getRobotRulesSet(protocol, (String)object);
    }

    @Override
    public void close() {
        this.closed.set(true);
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"javaClass.simpleName");
        return string;
    }

    @Override
    public void cancel(@NotNull WebPage page) {
        Protocol.DefaultImpls.cancel(this, page);
    }

    @Override
    public void cancelAll() {
        Protocol.DefaultImpls.cancelAll(this);
    }

    @Override
    public void setResponse(@NotNull Response response2) {
        Protocol.DefaultImpls.setResponse(this, response2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lai/platon/pulsar/crawl/protocol/http/AbstractHttpProtocol$Companion;", "", "()V", "MAX_REY_GUARD", "", "pulsar-skeleton"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

