/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.protocol.http;

import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.crawl.common.URLUtil;
import ai.platon.pulsar.persist.CrawlStatus;
import ai.platon.pulsar.persist.ProtocolStatus;
import ai.platon.pulsar.persist.WebPage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lai/platon/pulsar/crawl/protocol/http/ProtocolStatusTranslator;", "", "()V", "handleMoved", "Lai/platon/pulsar/persist/CrawlStatus;", "page", "Lai/platon/pulsar/persist/WebPage;", "protocolStatus", "Lai/platon/pulsar/persist/ProtocolStatus;", "translateHttpCode", "httpCode", "", "translateToCrawlStatus", "pulsar-skeleton"})
public final class ProtocolStatusTranslator {
    @NotNull
    public static final ProtocolStatusTranslator INSTANCE = new ProtocolStatusTranslator();

    private ProtocolStatusTranslator() {
    }

    @NotNull
    public final ProtocolStatus translateHttpCode(int httpCode) {
        ProtocolStatus protocolStatus;
        int n = httpCode;
        if (n == 200) {
            ProtocolStatus protocolStatus2 = ProtocolStatus.STATUS_SUCCESS;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus2, (String)"STATUS_SUCCESS");
            protocolStatus = protocolStatus2;
        } else if (n == 304) {
            ProtocolStatus protocolStatus3 = ProtocolStatus.STATUS_NOTMODIFIED;
            Intrinsics.checkNotNullExpressionValue((Object)protocolStatus3, (String)"STATUS_NOTMODIFIED");
            protocolStatus = protocolStatus3;
        } else {
            boolean bl = 300 <= n ? n <= 399 : false;
            if (bl) {
                int n2;
                int n3 = httpCode;
                switch (n3) {
                    case 300: {
                        n2 = 301;
                        break;
                    }
                    case 301: 
                    case 305: {
                        n2 = 301;
                        break;
                    }
                    case 302: 
                    case 303: 
                    case 307: {
                        n2 = 302;
                        break;
                    }
                    default: {
                        n2 = 301;
                    }
                }
                int code = n2;
                Object[] objectArray = new Object[]{"httpCode", httpCode};
                ProtocolStatus protocolStatus4 = ProtocolStatus.failed((int)code, (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)protocolStatus4, (String)"{\n                // han\u2026, httpCode)\n            }");
                protocolStatus = protocolStatus4;
            } else if (n == 400) {
                Object[] objectArray = new Object[]{"httpCode", httpCode};
                ProtocolStatus protocolStatus5 = ProtocolStatus.failed((int)410, (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)protocolStatus5, (String)"{\n                Protoc\u2026, httpCode)\n            }");
                protocolStatus = protocolStatus5;
            } else if (n == 401) {
                Object[] objectArray = new Object[]{"httpCode", httpCode};
                ProtocolStatus protocolStatus6 = ProtocolStatus.failed((int)401, (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)protocolStatus6, (String)"{ // requires authorizat\u2026, httpCode)\n            }");
                protocolStatus = protocolStatus6;
            } else if (n == 404) {
                Object[] objectArray = new Object[]{"httpCode", httpCode};
                ProtocolStatus protocolStatus7 = ProtocolStatus.failed((int)404, (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)protocolStatus7, (String)"{ // GONE\n              \u2026, httpCode)\n            }");
                protocolStatus = protocolStatus7;
            } else if (n == 408) {
                Object[] objectArray = new Object[]{"httpCode", httpCode};
                ProtocolStatus protocolStatus8 = ProtocolStatus.failed((int)408, (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)protocolStatus8, (String)"{ // TIMEOUT\n           \u2026, httpCode)\n            }");
                protocolStatus = protocolStatus8;
            } else if (n == 410) {
                Object[] objectArray = new Object[]{"httpCode", httpCode};
                ProtocolStatus protocolStatus9 = ProtocolStatus.failed((int)410, (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)protocolStatus9, (String)"{ // permanently GONE\n  \u2026, httpCode)\n            }");
                protocolStatus = protocolStatus9;
            } else {
                Object[] objectArray = new Object[]{"httpCode", httpCode};
                ProtocolStatus protocolStatus10 = ProtocolStatus.failed((int)1462, (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)protocolStatus10, (String)"{\n                Protoc\u2026, httpCode)\n            }");
                protocolStatus = protocolStatus10;
            }
        }
        return protocolStatus;
    }

    @NotNull
    public final CrawlStatus translateToCrawlStatus(@NotNull ProtocolStatus protocolStatus, @NotNull WebPage page) {
        CrawlStatus crawlStatus;
        Intrinsics.checkNotNullParameter((Object)protocolStatus, (String)"protocolStatus");
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        int n = protocolStatus.getMinorCode();
        switch (n) {
            case 200: {
                crawlStatus = CrawlStatus.Companion.getSTATUS_FETCHED();
                break;
            }
            case 304: {
                crawlStatus = CrawlStatus.Companion.getSTATUS_NOTMODIFIED();
                break;
            }
            case 1602: {
                crawlStatus = CrawlStatus.STATUS_UNFETCHED;
                break;
            }
            case 301: 
            case 302: {
                crawlStatus = this.handleMoved(page, protocolStatus);
                break;
            }
            case 401: 
            case 404: 
            case 410: 
            case 1460: 
            case 1461: {
                crawlStatus = CrawlStatus.Companion.getSTATUS_GONE();
                break;
            }
            case 1462: 
            case 1466: 
            case 1601: {
                crawlStatus = CrawlStatus.Companion.getSTATUS_RETRY();
                break;
            }
            case 408: 
            case 1470: 
            case 1471: 
            case 1472: {
                crawlStatus = CrawlStatus.Companion.getSTATUS_RETRY();
                break;
            }
            default: {
                crawlStatus = CrawlStatus.Companion.getSTATUS_RETRY();
            }
        }
        return crawlStatus;
    }

    private final CrawlStatus handleMoved(WebPage page, ProtocolStatus protocolStatus) {
        String reprUrl;
        CrawlStatus crawlStatus;
        String string = page.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"page.url");
        String url = string;
        int minorCode = protocolStatus.getMinorCode();
        boolean temp = false;
        if (minorCode == 301) {
            temp = false;
            crawlStatus = CrawlStatus.Companion.getSTATUS_REDIR_PERM();
        } else {
            temp = true;
            crawlStatus = CrawlStatus.Companion.getSTATUS_REDIR_TEMP();
        }
        CrawlStatus crawlStatus2 = crawlStatus;
        String newUrl = protocolStatus.getArgOrDefault("redirectTo", "");
        Intrinsics.checkNotNullExpressionValue((Object)newUrl, (String)"newUrl");
        CharSequence charSequence = newUrl;
        boolean bl = false;
        if (charSequence.length() > 0 && (reprUrl = URLUtil.chooseRepr(url, newUrl, temp)).length() >= AppConstants.SHORTEST_VALID_URL_LENGTH) {
            page.setReprUrl(reprUrl);
        }
        return crawlStatus2;
    }
}

