/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.schedule;

import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.common.persist.ext.WebPageExKt;
import ai.platon.pulsar.crawl.schedule.FetchSchedule;
import ai.platon.pulsar.crawl.schedule.ModifyInfo;
import ai.platon.pulsar.persist.CrawlStatus;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.Mark;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020%H\u0016J(\u0010&\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0011H\u0016J(\u0010)\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00112\u0006\u0010(\u001a\u00020\u0011H\u0016J\u0018\u0010*\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u0011H\u0016J \u0010,\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\n2\u0006\u0010$\u001a\u00020%H\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\n \u000b*\u0004\u0018\u00010\u00110\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006."}, d2={"Lai/platon/pulsar/crawl/schedule/AbstractFetchSchedule;", "Lai/platon/pulsar/crawl/schedule/FetchSchedule;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "(Lai/platon/pulsar/common/config/ImmutableConfig;Lai/platon/pulsar/common/message/MiscMessageWriter;)V", "getConf", "()Lai/platon/pulsar/common/config/ImmutableConfig;", "defaultInterval", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getDefaultInterval", "()Ljava/time/Duration;", "setDefaultInterval", "(Ljava/time/Duration;)V", "impreciseNow", "Ljava/time/Instant;", "getImpreciseNow", "()Ljava/time/Instant;", "maxFetchInterval", "getMaxFetchInterval", "getMessageWriter", "()Lai/platon/pulsar/common/message/MiscMessageWriter;", "estimatePrevFetchTime", "page", "Lai/platon/pulsar/persist/WebPage;", "forceRefetch", "", "prevFetchTime", "asap", "", "getParams", "Lai/platon/pulsar/common/config/Params;", "initializeSchedule", "setFetchSchedule", "m", "Lai/platon/pulsar/crawl/schedule/ModifyInfo;", "setPageGoneSchedule", "prevModifiedTime", "fetchTime", "setPageRetrySchedule", "shouldFetch", "now", "updateRefetchTime", "fetchInterval", "pulsar-skeleton"})
public abstract class AbstractFetchSchedule
implements FetchSchedule {
    @NotNull
    private final ImmutableConfig conf;
    @Nullable
    private final MiscMessageWriter messageWriter;
    private Duration defaultInterval;
    private final Instant impreciseNow;
    @NotNull
    private final Duration maxFetchInterval;

    public AbstractFetchSchedule(@NotNull ImmutableConfig conf, @Nullable MiscMessageWriter messageWriter) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        this.conf = conf;
        this.messageWriter = messageWriter;
        Duration duration = Duration.ofDays(30L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(30)");
        this.defaultInterval = this.conf.getDuration("fetch.default.interval", duration);
        this.impreciseNow = Instant.now();
        Duration duration2 = ChronoUnit.DECADES.getDuration();
        Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"DECADES.duration");
        duration = this.conf.getDuration("fetch.interval.max", duration2);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"conf.getDuration(Capabil\u2026onoUnit.DECADES.duration)");
        this.maxFetchInterval = duration;
    }

    public /* synthetic */ AbstractFetchSchedule(ImmutableConfig immutableConfig, MiscMessageWriter miscMessageWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            miscMessageWriter = null;
        }
        this(immutableConfig, miscMessageWriter);
    }

    @NotNull
    public final ImmutableConfig getConf() {
        return this.conf;
    }

    @Nullable
    public final MiscMessageWriter getMessageWriter() {
        return this.messageWriter;
    }

    protected final Duration getDefaultInterval() {
        return this.defaultInterval;
    }

    protected final void setDefaultInterval(Duration duration) {
        this.defaultInterval = duration;
    }

    protected final Instant getImpreciseNow() {
        return this.impreciseNow;
    }

    @Override
    @NotNull
    public Duration getMaxFetchInterval() {
        return this.maxFetchInterval;
    }

    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"maxInterval", this.getMaxFetchInterval(), "maxFetchInterval", this.getMaxFetchInterval()};
        Params params = Params.of((String)"defaultInterval", (Object)this.defaultInterval, (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params, (String)"of(\n            \"default\u2026xFetchInterval,\n        )");
        return params;
    }

    @Override
    public void initializeSchedule(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        page.setFetchInterval(this.defaultInterval);
        page.setFetchRetries(0);
        page.setCrawlStatus(CrawlStatus.STATUS_UNFETCHED);
    }

    @Override
    public void setFetchSchedule(@NotNull WebPage page, @NotNull ModifyInfo m) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        if (page.getProtocolStatus().isSuccess()) {
            page.setFetchRetries(0);
        }
        page.setFetchInterval(WebPageExKt.getOptions(page).getFetchInterval());
        Instant now = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        Instant instant = now.plus(page.getFetchInterval());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now + page.fetchInterval");
        WebPageExKt.updateFetchTime(page, now, instant);
        page.setModifiedTime(m.getModifiedTime());
        page.setPrevModifiedTime(m.getPrevModifiedTime());
    }

    @Override
    public void setPageRetrySchedule(@NotNull WebPage page, @NotNull Instant prevFetchTime, @NotNull Instant prevModifiedTime, @NotNull Instant fetchTime) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)prevFetchTime, (String)"prevFetchTime");
        Intrinsics.checkNotNullParameter((Object)prevModifiedTime, (String)"prevModifiedTime");
        Intrinsics.checkNotNullParameter((Object)fetchTime, (String)"fetchTime");
        WebPage webPage = page;
        int n = webPage.getFetchRetries();
        webPage.setFetchRetries(n + 1);
        Instant now = Instant.now();
        page.setFetchInterval(Duration.ofSeconds(0L));
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        WebPageExKt.updateFetchTime(page, now, now);
        int crawlStatus = page.getFetchRetries() <= page.getMaxRetries() ? 1 : 3;
        page.setCrawlStatus(crawlStatus);
    }

    @Override
    public void setPageGoneSchedule(@NotNull WebPage page, @NotNull Instant prevFetchTime, @NotNull Instant prevModifiedTime, @NotNull Instant fetchTime) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)prevFetchTime, (String)"prevFetchTime");
        Intrinsics.checkNotNullParameter((Object)prevModifiedTime, (String)"prevModifiedTime");
        Intrinsics.checkNotNullParameter((Object)fetchTime, (String)"fetchTime");
        page.setFetchInterval(ChronoUnit.DECADES.getDuration());
        Instant now = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        Instant instant = now.plus(page.getFetchInterval());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now + page.fetchInterval");
        WebPageExKt.updateFetchTime(page, now, instant);
    }

    @Override
    @NotNull
    public Instant estimatePrevFetchTime(@NotNull WebPage page) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Instant instant = page.getFetchTime().minus(page.getFetchInterval());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"page.fetchTime - page.fetchInterval");
        return instant;
    }

    @Override
    public boolean shouldFetch(@NotNull WebPage page, @NotNull Instant now) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)now, (String)"now");
        if (page.hasMark(Mark.INACTIVE)) {
            return false;
        }
        if (WebPageExKt.getOptions(page).isExpired(now)) {
            return true;
        }
        Instant instant = page.getFetchTime();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"page.fetchTime");
        Instant fetchTime = instant;
        return fetchTime.compareTo(now) < 0;
    }

    @Override
    public void forceRefetch(@NotNull WebPage page, @NotNull Instant prevFetchTime, boolean asap) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)prevFetchTime, (String)"prevFetchTime");
        if (page.hasMark(Mark.INACTIVE)) {
            return;
        }
        if (page.getFetchInterval().compareTo(this.getMaxFetchInterval()) > 0) {
            page.setFetchInterval((float)this.getMaxFetchInterval().getSeconds() * 0.9f);
        }
        page.setCrawlStatus(CrawlStatus.STATUS_UNFETCHED);
        page.setFetchRetries(0);
        Duration fetchInterval = asap ? Duration.ZERO : page.getFetchInterval();
        Instant now = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        Instant instant = now.plus(fetchInterval);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now + fetchInterval");
        WebPageExKt.updateFetchTime(page, now, instant);
    }

    protected final void updateRefetchTime(@NotNull WebPage page, @NotNull Duration fetchInterval, @NotNull ModifyInfo m) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)fetchInterval, (String)"fetchInterval");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Instant now = Instant.now();
        page.setFetchInterval(fetchInterval);
        Intrinsics.checkNotNullExpressionValue((Object)now, (String)"now");
        Instant instant = now.plus(page.getFetchInterval());
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now + page.fetchInterval");
        WebPageExKt.updateFetchTime(page, now, instant);
        page.setPrevModifiedTime(m.getPrevModifiedTime());
        page.setModifiedTime(m.getModifiedTime());
    }
}

