/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.schedule;

import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.config.Params;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.crawl.schedule.AbstractFetchSchedule;
import ai.platon.pulsar.crawl.schedule.ModifyInfo;
import ai.platon.pulsar.persist.WebPage;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010/\u001a\u00020\u00112\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u00020*H\u0004J\b\u00106\u001a\u000207H\u0016J\u0018\u00108\u001a\u0002092\u0006\u00100\u001a\u0002012\u0006\u0010:\u001a\u00020;H\u0016J(\u0010<\u001a\u0002092\u0006\u00100\u001a\u0002012\u0006\u0010=\u001a\u0002032\u0006\u0010>\u001a\u0002032\u0006\u0010?\u001a\u000203H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\"\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\"\u0010\u001a\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\u001d\u001a\u00020\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u0006@"}, d2={"Lai/platon/pulsar/crawl/schedule/AdaptiveFetchSchedule;", "Lai/platon/pulsar/crawl/schedule/AbstractFetchSchedule;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "(Lai/platon/pulsar/common/config/ImmutableConfig;Lai/platon/pulsar/common/message/MiscMessageWriter;)V", "DEC_RATE", "", "getDEC_RATE", "()F", "setDEC_RATE", "(F)V", "INC_RATE", "getINC_RATE", "setINC_RATE", "MAX_INTERVAL", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "getMAX_INTERVAL", "()Ljava/time/Duration;", "setMAX_INTERVAL", "(Ljava/time/Duration;)V", "MIN_INTERVAL", "getMIN_INTERVAL", "setMIN_INTERVAL", "SEED_MAX_INTERVAL", "getSEED_MAX_INTERVAL", "setSEED_MAX_INTERVAL", "SYNC_DELTA", "", "getSYNC_DELTA", "()Z", "setSYNC_DELTA", "(Z)V", "SYNC_DELTA_RATE", "", "getSYNC_DELTA_RATE", "()D", "setSYNC_DELTA_RATE", "(D)V", "maxDistance", "", "getMaxDistance", "()I", "setMaxDistance", "(I)V", "getFetchInterval", "page", "Lai/platon/pulsar/persist/WebPage;", "fetchTime_", "Ljava/time/Instant;", "modifiedTime", "state", "getParams", "Lai/platon/pulsar/common/config/Params;", "setFetchSchedule", "", "m", "Lai/platon/pulsar/crawl/schedule/ModifyInfo;", "setPageGoneSchedule", "prevFetchTime", "prevModifiedTime", "fetchTime", "pulsar-skeleton"})
public class AdaptiveFetchSchedule
extends AbstractFetchSchedule {
    private float INC_RATE;
    private float DEC_RATE;
    private Duration MIN_INTERVAL;
    private Duration MAX_INTERVAL;
    private Duration SEED_MAX_INTERVAL;
    private boolean SYNC_DELTA;
    private double SYNC_DELTA_RATE;
    private int maxDistance;

    public AdaptiveFetchSchedule(@NotNull ImmutableConfig conf, @Nullable MiscMessageWriter messageWriter) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf, messageWriter);
        this.INC_RATE = conf.getFloat("db.fetch.schedule.adaptive.inc_rate", 0.2f);
        this.DEC_RATE = conf.getFloat("db.fetch.schedule.adaptive.dec_rate", 0.2f);
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMinutes(10)");
        this.MIN_INTERVAL = conf.getDuration("db.fetch.schedule.adaptive.min_interval", duration);
        duration = Duration.ofDays(365L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(365)");
        this.MAX_INTERVAL = conf.getDuration("db.fetch.schedule.adaptive.max_interval", duration);
        duration = Duration.ofDays(1L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofDays(1)");
        this.SEED_MAX_INTERVAL = conf.getDuration("db.fetch.schedule.adaptive.seed_max_interval", duration);
        this.SYNC_DELTA = conf.getBoolean("db.fetch.schedule.adaptive.sync_delta", true);
        this.SYNC_DELTA_RATE = conf.getFloat("db.fetch.schedule.adaptive.sync_delta_rate", 0.2f);
        this.maxDistance = conf.getInt("crawl.max.distance", 10000);
    }

    public /* synthetic */ AdaptiveFetchSchedule(ImmutableConfig immutableConfig, MiscMessageWriter miscMessageWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            miscMessageWriter = null;
        }
        this(immutableConfig, miscMessageWriter);
    }

    protected final float getINC_RATE() {
        return this.INC_RATE;
    }

    protected final void setINC_RATE(float f) {
        this.INC_RATE = f;
    }

    protected final float getDEC_RATE() {
        return this.DEC_RATE;
    }

    protected final void setDEC_RATE(float f) {
        this.DEC_RATE = f;
    }

    protected final Duration getMIN_INTERVAL() {
        return this.MIN_INTERVAL;
    }

    protected final void setMIN_INTERVAL(Duration duration) {
        this.MIN_INTERVAL = duration;
    }

    protected final Duration getMAX_INTERVAL() {
        return this.MAX_INTERVAL;
    }

    protected final void setMAX_INTERVAL(Duration duration) {
        this.MAX_INTERVAL = duration;
    }

    protected final Duration getSEED_MAX_INTERVAL() {
        return this.SEED_MAX_INTERVAL;
    }

    protected final void setSEED_MAX_INTERVAL(Duration duration) {
        this.SEED_MAX_INTERVAL = duration;
    }

    protected final boolean getSYNC_DELTA() {
        return this.SYNC_DELTA;
    }

    protected final void setSYNC_DELTA(boolean bl) {
        this.SYNC_DELTA = bl;
    }

    protected final double getSYNC_DELTA_RATE() {
        return this.SYNC_DELTA_RATE;
    }

    protected final void setSYNC_DELTA_RATE(double d) {
        this.SYNC_DELTA_RATE = d;
    }

    protected final int getMaxDistance() {
        return this.maxDistance;
    }

    protected final void setMaxDistance(int n) {
        this.maxDistance = n;
    }

    @Override
    @NotNull
    public Params getParams() {
        Object[] objectArray = new Object[]{"MIN_INTERVAL", this.MIN_INTERVAL, "MAX_INTERVAL", this.MAX_INTERVAL, "SEED_MAX_INTERVAL", this.SEED_MAX_INTERVAL};
        Params params = Params.of((String)"className", (Object)this.getClass().getSimpleName(), (Object[])objectArray);
        objectArray = new Params[]{super.getParams()};
        Params params2 = params.merge((Params[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)params2, (String)"of(\n            \"classNa\u2026.merge(super.getParams())");
        return params2;
    }

    @Override
    public void setFetchSchedule(@NotNull WebPage page, @NotNull ModifyInfo m) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Instant newModifiedTime = m.getModifiedTime();
        super.setFetchSchedule(page, m);
        if (m.getModifiedTime().compareTo(AppConstants.TCP_IP_STANDARDIZED_TIME) < 0) {
            m.setModifiedTime(m.getFetchTime());
        }
        Duration newInterval = this.getFetchInterval(page, m.getFetchTime(), newModifiedTime, m.getModified());
        this.updateRefetchTime(page, newInterval, m);
    }

    @Override
    public void setPageGoneSchedule(@NotNull WebPage page, @NotNull Instant prevFetchTime, @NotNull Instant prevModifiedTime, @NotNull Instant fetchTime) {
        float prevInterval;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)prevFetchTime, (String)"prevFetchTime");
        Intrinsics.checkNotNullParameter((Object)prevModifiedTime, (String)"prevModifiedTime");
        Intrinsics.checkNotNullParameter((Object)fetchTime, (String)"fetchTime");
        float newInterval = prevInterval = (float)page.getFetchInterval().getSeconds();
        newInterval = newInterval < (float)this.getMaxFetchInterval().getSeconds() ? prevInterval * 1.5f : (float)this.getMaxFetchInterval().getSeconds() * 0.9f;
        Instant now = Instant.now();
        page.setFetchInterval(newInterval);
        page.setPrevFetchTime(now);
        page.setFetchTime(now.plusSeconds((long)newInterval));
    }

    @NotNull
    protected final Duration getFetchInterval(@NotNull WebPage page, @NotNull Instant fetchTime_, @NotNull Instant modifiedTime, int state) {
        Duration newInterval;
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)fetchTime_, (String)"fetchTime_");
        Intrinsics.checkNotNullParameter((Object)modifiedTime, (String)"modifiedTime");
        Instant fetchTime = fetchTime_;
        long interval = page.getFetchInterval().getSeconds();
        int n = state;
        switch (n) {
            case 1: {
                interval *= (long)(1.0f - this.DEC_RATE);
                break;
            }
            case 2: {
                interval *= (long)(1.0f + this.INC_RATE);
            }
        }
        if (this.SYNC_DELTA) {
            long gap = fetchTime.getEpochSecond() - modifiedTime.getEpochSecond();
            if (gap > interval) {
                interval = gap;
            }
            Instant instant = fetchTime.minusSeconds(Math.round((double)gap * this.SYNC_DELTA_RATE));
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"fetchTime.minusSeconds(M\u2026d(gap * SYNC_DELTA_RATE))");
            fetchTime = instant;
        }
        if ((newInterval = Duration.ofSeconds(interval)).compareTo(this.MIN_INTERVAL) < 0) {
            newInterval = this.MIN_INTERVAL;
        }
        if (newInterval.compareTo(this.MAX_INTERVAL) > 0) {
            newInterval = this.MAX_INTERVAL;
        }
        Duration duration = newInterval;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"newInterval");
        return duration;
    }
}

