/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.schedule;

import ai.platon.pulsar.common.config.AppConstants;
import ai.platon.pulsar.common.config.ImmutableConfig;
import ai.platon.pulsar.common.message.MiscMessageWriter;
import ai.platon.pulsar.crawl.schedule.AdaptiveFetchSchedule;
import ai.platon.pulsar.crawl.schedule.ModifyInfo;
import ai.platon.pulsar.persist.WebPage;
import ai.platon.pulsar.persist.metadata.Mark;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lai/platon/pulsar/crawl/schedule/NewsFetchSchedule;", "Lai/platon/pulsar/crawl/schedule/AdaptiveFetchSchedule;", "conf", "Lai/platon/pulsar/common/config/ImmutableConfig;", "messageWriter", "Lai/platon/pulsar/common/message/MiscMessageWriter;", "(Lai/platon/pulsar/common/config/ImmutableConfig;Lai/platon/pulsar/common/message/MiscMessageWriter;)V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "adjustSeedFetchInterval", "Ljava/time/Duration;", "page", "Lai/platon/pulsar/persist/WebPage;", "fetchTime", "Ljava/time/Instant;", "modifiedTime", "setFetchSchedule", "", "m", "Lai/platon/pulsar/crawl/schedule/ModifyInfo;", "pulsar-skeleton"})
public final class NewsFetchSchedule
extends AdaptiveFetchSchedule {
    private final Logger LOG;

    public NewsFetchSchedule(@NotNull ImmutableConfig conf, @Nullable MiscMessageWriter messageWriter) {
        Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
        super(conf, messageWriter);
        this.LOG = LoggerFactory.getLogger(NewsFetchSchedule.class);
    }

    public /* synthetic */ NewsFetchSchedule(ImmutableConfig immutableConfig, MiscMessageWriter miscMessageWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            miscMessageWriter = null;
        }
        this(immutableConfig, miscMessageWriter);
    }

    @Override
    public void setFetchSchedule(@NotNull WebPage page, @NotNull ModifyInfo m) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        Instant time = m.getModifiedTime();
        if (time.isBefore(AppConstants.TCP_IP_STANDARDIZED_TIME)) {
            time = m.getFetchTime();
        }
        Duration interval = Duration.ofDays(3650L);
        if (page.isSeed()) {
            interval = this.adjustSeedFetchInterval(page, m.getFetchTime(), time);
        } else {
            page.getMarks().put(Mark.INACTIVE, "y");
        }
        m.setFetchTime(time);
        Duration duration = interval;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"interval");
        this.updateRefetchTime(page, duration, m);
    }

    private final Duration adjustSeedFetchInterval(WebPage page, Instant fetchTime, Instant modifiedTime) {
        long days;
        Instant time = modifiedTime;
        Instant publishTime = page.getContentPublishTime();
        if (publishTime.isAfter(time)) {
            time = publishTime;
        }
        if ((days = ChronoUnit.DAYS.between(time, fetchTime)) > 7L) {
            Object object = this.getMessageWriter();
            if (object != null) {
                object.reportFetchSchedule(page, false);
            }
            object = Duration.ofHours(1L);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ofHours(1)");
            return object;
        }
        Duration duration = this.getMIN_INTERVAL();
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"MIN_INTERVAL");
        return duration;
    }
}

