/*
 * Decompiled with CFR 0.152.
 */
package ai.platon.pulsar.crawl.signature;

import ai.platon.pulsar.crawl.signature.MD5Signature;
import ai.platon.pulsar.crawl.signature.Signature;
import ai.platon.pulsar.persist.WebPage;
import org.apache.hadoop.io.MD5Hash;

public class TextMD5Signature
extends Signature {
    public static int GOOD_CONTENT_TEXT_LENGTH = 2000;
    private Signature fallback = new MD5Signature();

    @Override
    public byte[] calculate(WebPage page) {
        String text = page.getContentText();
        if (text.isEmpty() || text.length() < GOOD_CONTENT_TEXT_LENGTH) {
            text = page.getPageText();
        }
        if (text.isEmpty()) {
            return this.fallback.calculate(page);
        }
        return MD5Hash.digest((String)text).getDigest();
    }
}

