/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room;

import android.arch.core.executor.AppToolkitTaskExecutor;
import android.arch.core.internal.SafeIterableMap;
import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteStatement;
import android.arch.persistence.room.RoomDatabase;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.annotation.WorkerThread;
import android.support.v4.util.ArrayMap;
import android.support.v4.util.ArraySet;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class InvalidationTracker {
    private static final String[] TRIGGERS = new String[]{"UPDATE", "DELETE", "INSERT"};
    private static final String UPDATE_TABLE_NAME = "room_table_modification_log";
    private static final String VERSION_COLUMN_NAME = "version";
    private static final String TABLE_ID_COLUMN_NAME = "table_id";
    private static final String CREATE_VERSION_TABLE_SQL = "CREATE TEMP TABLE room_table_modification_log(version INTEGER PRIMARY KEY AUTOINCREMENT, table_id INTEGER)";
    @VisibleForTesting
    static final String CLEANUP_SQL = "DELETE FROM room_table_modification_log WHERE version NOT IN( SELECT MAX(version) FROM room_table_modification_log GROUP BY table_id)";
    @VisibleForTesting
    static final String SELECT_UPDATED_TABLES_SQL = "SELECT * FROM room_table_modification_log WHERE version  > ? ORDER BY version ASC;";
    @NonNull
    @VisibleForTesting
    ArrayMap<String, Integer> mTableIdLookup;
    private String[] mTableNames;
    @NonNull
    @VisibleForTesting
    long[] mTableVersions;
    private Object[] mQueryArgs = new Object[1];
    private long mMaxVersion = -1L;
    private final RoomDatabase mDatabase;
    AtomicBoolean mPendingRefresh = new AtomicBoolean(false);
    private volatile boolean mInitialized = false;
    private volatile SupportSQLiteStatement mCleanupStatement;
    private ObservedTableTracker mObservedTableTracker;
    @VisibleForTesting
    final SafeIterableMap<Observer, ObserverWrapper> mObserverMap = new SafeIterableMap();
    private Runnable mSyncTriggers = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (InvalidationTracker.this.mDatabase.inTransaction()) {
                return;
            }
            if (!InvalidationTracker.this.ensureInitialization()) {
                return;
            }
            try {
                while (true) {
                    int[] tablesToSync;
                    if ((tablesToSync = InvalidationTracker.this.mObservedTableTracker.getTablesToSync()) == null) {
                        return;
                    }
                    int limit = tablesToSync.length;
                    SupportSQLiteDatabase writableDatabase = InvalidationTracker.this.mDatabase.getOpenHelper().getWritableDatabase();
                    try {
                        writableDatabase.beginTransaction();
                        block10: for (int tableId = 0; tableId < limit; ++tableId) {
                            switch (tablesToSync[tableId]) {
                                case 1: {
                                    InvalidationTracker.this.startTrackingTable(writableDatabase, tableId);
                                    continue block10;
                                }
                                case 2: {
                                    InvalidationTracker.this.stopTrackingTable(writableDatabase, tableId);
                                }
                            }
                        }
                        writableDatabase.setTransactionSuccessful();
                    }
                    finally {
                        writableDatabase.endTransaction();
                    }
                    InvalidationTracker.this.mObservedTableTracker.onSyncCompleted();
                }
            }
            catch (SQLiteException | IllegalStateException exception) {
                Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)exception);
                return;
            }
        }
    };
    @VisibleForTesting
    Runnable mRefreshRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!InvalidationTracker.this.ensureInitialization()) {
                return;
            }
            if (InvalidationTracker.this.mDatabase.inTransaction() || !InvalidationTracker.this.mPendingRefresh.compareAndSet(true, false)) {
                return;
            }
            boolean hasUpdatedTable = false;
            try {
                InvalidationTracker.this.mCleanupStatement.executeUpdateDelete();
                ((InvalidationTracker)InvalidationTracker.this).mQueryArgs[0] = InvalidationTracker.this.mMaxVersion;
                try (Cursor cursor = InvalidationTracker.this.mDatabase.query(InvalidationTracker.SELECT_UPDATED_TABLES_SQL, InvalidationTracker.this.mQueryArgs);){
                    while (cursor.moveToNext()) {
                        long version = cursor.getLong(0);
                        int tableId = cursor.getInt(1);
                        InvalidationTracker.this.mTableVersions[tableId] = version;
                        hasUpdatedTable = true;
                        InvalidationTracker.this.mMaxVersion = version;
                    }
                }
            }
            catch (SQLiteException | IllegalStateException exception) {
                Log.e((String)"ROOM", (String)"Cannot run invalidation tracker. Is the db closed?", (Throwable)exception);
            }
            if (hasUpdatedTable) {
                SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = InvalidationTracker.this.mObserverMap;
                synchronized (safeIterableMap) {
                    for (Map.Entry entry : InvalidationTracker.this.mObserverMap) {
                        ((ObserverWrapper)entry.getValue()).checkForInvalidation(InvalidationTracker.this.mTableVersions);
                    }
                }
            }
        }
    };

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public InvalidationTracker(RoomDatabase database, String ... tableNames) {
        this.mDatabase = database;
        this.mObservedTableTracker = new ObservedTableTracker(tableNames.length);
        this.mTableIdLookup = new ArrayMap();
        int size = tableNames.length;
        this.mTableNames = new String[size];
        for (int id = 0; id < size; ++id) {
            String tableName = tableNames[id].toLowerCase(Locale.US);
            this.mTableIdLookup.put((Object)tableName, (Object)id);
            this.mTableNames[id] = tableName;
        }
        this.mTableVersions = new long[tableNames.length];
        Arrays.fill(this.mTableVersions, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void internalInit(SupportSQLiteDatabase database) {
        InvalidationTracker invalidationTracker = this;
        synchronized (invalidationTracker) {
            if (this.mInitialized) {
                Log.e((String)"ROOM", (String)"Invalidation tracker is initialized twice :/.");
                return;
            }
            database.beginTransaction();
            try {
                database.execSQL("PRAGMA temp_store = MEMORY;");
                database.execSQL("PRAGMA recursive_triggers='ON';");
                database.execSQL(CREATE_VERSION_TABLE_SQL);
                database.setTransactionSuccessful();
            }
            finally {
                database.endTransaction();
            }
            this.mCleanupStatement = database.compileStatement(CLEANUP_SQL);
            this.mInitialized = true;
        }
    }

    private static void appendTriggerName(StringBuilder builder, String tableName, String triggerType) {
        builder.append("room_table_modification_trigger_").append(tableName).append("_").append(triggerType);
    }

    private void stopTrackingTable(SupportSQLiteDatabase writableDb, int tableId) {
        String tableName = this.mTableNames[tableId];
        StringBuilder stringBuilder = new StringBuilder();
        for (String trigger : TRIGGERS) {
            stringBuilder.setLength(0);
            stringBuilder.append("DROP TRIGGER IF EXISTS ");
            InvalidationTracker.appendTriggerName(stringBuilder, tableName, trigger);
            writableDb.execSQL(stringBuilder.toString());
        }
    }

    private void startTrackingTable(SupportSQLiteDatabase writableDb, int tableId) {
        String tableName = this.mTableNames[tableId];
        StringBuilder stringBuilder = new StringBuilder();
        for (String trigger : TRIGGERS) {
            stringBuilder.setLength(0);
            stringBuilder.append("CREATE TEMP TRIGGER IF NOT EXISTS ");
            InvalidationTracker.appendTriggerName(stringBuilder, tableName, trigger);
            stringBuilder.append(" AFTER ").append(trigger).append(" ON ").append(tableName).append(" BEGIN INSERT OR REPLACE INTO ").append(UPDATE_TABLE_NAME).append(" VALUES(null, ").append(tableId).append("); END");
            writableDb.execSQL(stringBuilder.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer observer) {
        ObserverWrapper currentObserver;
        String[] tableNames = observer.mTables;
        int[] tableIds = new int[tableNames.length];
        int size = tableNames.length;
        long[] versions = new long[tableNames.length];
        for (int i = 0; i < size; ++i) {
            Integer tableId = (Integer)this.mTableIdLookup.get((Object)tableNames[i].toLowerCase(Locale.US));
            if (tableId == null) {
                throw new IllegalArgumentException("There is no table with name " + tableNames[i]);
            }
            tableIds[i] = tableId;
            versions[i] = this.mMaxVersion;
        }
        ObserverWrapper wrapper = new ObserverWrapper(observer, tableIds, tableNames, versions);
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.mObserverMap;
        synchronized (safeIterableMap) {
            currentObserver = (ObserverWrapper)this.mObserverMap.putIfAbsent((Object)observer, (Object)wrapper);
        }
        if (currentObserver == null && this.mObservedTableTracker.onAdded(tableIds)) {
            AppToolkitTaskExecutor.getInstance().executeOnDiskIO(this.mSyncTriggers);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void addWeakObserver(Observer observer) {
        this.addObserver(new WeakObserver(this, observer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(Observer observer) {
        ObserverWrapper wrapper;
        SafeIterableMap<Observer, ObserverWrapper> safeIterableMap = this.mObserverMap;
        synchronized (safeIterableMap) {
            wrapper = (ObserverWrapper)this.mObserverMap.remove((Object)observer);
        }
        if (wrapper != null && this.mObservedTableTracker.onRemoved(wrapper.mTableIds)) {
            AppToolkitTaskExecutor.getInstance().executeOnDiskIO(this.mSyncTriggers);
        }
    }

    private boolean ensureInitialization() {
        if (!this.mDatabase.isOpen()) {
            return false;
        }
        if (!this.mInitialized) {
            this.mDatabase.getOpenHelper().getWritableDatabase();
        }
        if (!this.mInitialized) {
            Log.e((String)"ROOM", (String)"database is not initialized even though it is open");
            return false;
        }
        return true;
    }

    public void refreshVersionsAsync() {
        if (this.mPendingRefresh.compareAndSet(false, true)) {
            AppToolkitTaskExecutor.getInstance().executeOnDiskIO(this.mRefreshRunnable);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @WorkerThread
    public void refreshVersionsSync() {
        this.syncTriggers();
        this.mRefreshRunnable.run();
    }

    void syncTriggers() {
        this.mSyncTriggers.run();
    }

    static class WeakObserver
    extends Observer {
        final InvalidationTracker mTracker;
        final WeakReference<Observer> mDelegateRef;

        WeakObserver(InvalidationTracker tracker, Observer delegate) {
            super(delegate.mTables);
            this.mTracker = tracker;
            this.mDelegateRef = new WeakReference<Observer>(delegate);
        }

        @Override
        public void onInvalidated(@NonNull Set<String> tables) {
            Observer observer = (Observer)this.mDelegateRef.get();
            if (observer == null) {
                this.mTracker.removeObserver(this);
            } else {
                observer.onInvalidated(tables);
            }
        }
    }

    static class ObservedTableTracker {
        static final int NO_OP = 0;
        static final int ADD = 1;
        static final int REMOVE = 2;
        final long[] mTableObservers;
        final boolean[] mTriggerStates;
        final int[] mTriggerStateChanges;
        boolean mNeedsSync;
        boolean mPendingSync;

        ObservedTableTracker(int tableCount) {
            this.mTableObservers = new long[tableCount];
            this.mTriggerStates = new boolean[tableCount];
            this.mTriggerStateChanges = new int[tableCount];
            Arrays.fill(this.mTableObservers, 0L);
            Arrays.fill(this.mTriggerStates, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean onAdded(int ... tableIds) {
            boolean needTriggerSync = false;
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                for (int tableId : tableIds) {
                    long prevObserverCount = this.mTableObservers[tableId];
                    this.mTableObservers[tableId] = prevObserverCount + 1L;
                    if (prevObserverCount != 0L) continue;
                    this.mNeedsSync = true;
                    needTriggerSync = true;
                }
            }
            return needTriggerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean onRemoved(int ... tableIds) {
            boolean needTriggerSync = false;
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                for (int tableId : tableIds) {
                    long prevObserverCount = this.mTableObservers[tableId];
                    this.mTableObservers[tableId] = prevObserverCount - 1L;
                    if (prevObserverCount != 1L) continue;
                    this.mNeedsSync = true;
                    needTriggerSync = true;
                }
            }
            return needTriggerSync;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        int[] getTablesToSync() {
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                if (!this.mNeedsSync || this.mPendingSync) {
                    return null;
                }
                int tableCount = this.mTableObservers.length;
                for (int i = 0; i < tableCount; ++i) {
                    boolean newState;
                    boolean bl = newState = this.mTableObservers[i] > 0L;
                    this.mTriggerStateChanges[i] = newState != this.mTriggerStates[i] ? (newState ? 1 : 2) : 0;
                    this.mTriggerStates[i] = newState;
                }
                this.mPendingSync = true;
                this.mNeedsSync = false;
                return this.mTriggerStateChanges;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onSyncCompleted() {
            ObservedTableTracker observedTableTracker = this;
            synchronized (observedTableTracker) {
                this.mPendingSync = false;
            }
        }
    }

    public static abstract class Observer {
        final String[] mTables;

        protected Observer(@NonNull String firstTable, String ... rest) {
            this.mTables = Arrays.copyOf(rest, rest.length + 1);
            this.mTables[rest.length] = firstTable;
        }

        public Observer(@NonNull String[] tables) {
            this.mTables = Arrays.copyOf(tables, tables.length);
        }

        public abstract void onInvalidated(@NonNull Set<String> var1);
    }

    static class ObserverWrapper {
        final int[] mTableIds;
        private final String[] mTableNames;
        private final long[] mVersions;
        final Observer mObserver;
        private final Set<String> mSingleTableSet;

        ObserverWrapper(Observer observer, int[] tableIds, String[] tableNames, long[] versions) {
            this.mObserver = observer;
            this.mTableIds = tableIds;
            this.mTableNames = tableNames;
            this.mVersions = versions;
            if (tableIds.length == 1) {
                ArraySet set = new ArraySet();
                set.add((Object)this.mTableNames[0]);
                this.mSingleTableSet = Collections.unmodifiableSet(set);
            } else {
                this.mSingleTableSet = null;
            }
        }

        void checkForInvalidation(long[] versions) {
            ArraySet invalidatedTables = null;
            int size = this.mTableIds.length;
            for (int index = 0; index < size; ++index) {
                long currentVersion = this.mVersions[index];
                int tableId = this.mTableIds[index];
                long newVersion = versions[tableId];
                if (currentVersion >= newVersion) continue;
                this.mVersions[index] = newVersion;
                if (size == 1) {
                    invalidatedTables = this.mSingleTableSet;
                    continue;
                }
                if (invalidatedTables == null) {
                    invalidatedTables = new ArraySet(size);
                }
                invalidatedTables.add(this.mTableNames[index]);
            }
            if (invalidatedTables != null) {
                this.mObserver.onInvalidated((Set<String>)invalidatedTables);
            }
        }
    }
}

