/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.paging;

import android.arch.persistence.room.InvalidationTracker;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomSQLiteQuery;
import android.arch.util.paging.CountedDataSource;
import android.database.Cursor;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import java.util.Collections;
import java.util.List;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class LimitOffsetDataSource<T>
extends CountedDataSource<T> {
    private final RoomSQLiteQuery mSourceQuery;
    private final String mCountQuery;
    private final String mLimitOffsetQuery;
    private final RoomDatabase mDb;
    private final InvalidationTracker.Observer mObserver;
    public Runnable invalidCallback;

    protected LimitOffsetDataSource(RoomDatabase db, RoomSQLiteQuery query, String ... tables) {
        this.mDb = db;
        this.mSourceQuery = query;
        this.mCountQuery = "SELECT COUNT(*) FROM ( " + this.mSourceQuery.getSql() + " )";
        this.mLimitOffsetQuery = "SELECT * FROM ( " + this.mSourceQuery.getSql() + " ) LIMIT ? OFFSET ?";
        this.mObserver = new InvalidationTracker.Observer(tables){

            @Override
            public void onInvalidated(@NonNull Set<String> tables) {
                LimitOffsetDataSource.this.invalidate();
            }
        };
        db.getInvalidationTracker().addWeakObserver(this.mObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadCount() {
        RoomSQLiteQuery sqLiteQuery = RoomSQLiteQuery.acquire(this.mCountQuery, this.mSourceQuery.getArgCount());
        sqLiteQuery.copyArgumentsFrom(this.mSourceQuery);
        Cursor cursor = this.mDb.query(sqLiteQuery);
        try {
            if (cursor.moveToFirst()) {
                int n = cursor.getInt(0);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            cursor.close();
            sqLiteQuery.release();
        }
    }

    public boolean isInvalid() {
        this.mDb.getInvalidationTracker().refreshVersionsSync();
        return super.isInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> queryRange(int offset, int limit) {
        RoomSQLiteQuery sqLiteQuery = RoomSQLiteQuery.acquire(this.mLimitOffsetQuery, this.mSourceQuery.getArgCount() + 2);
        sqLiteQuery.copyArgumentsFrom(this.mSourceQuery);
        sqLiteQuery.bindLong(sqLiteQuery.getArgCount() - 1, limit);
        sqLiteQuery.bindLong(sqLiteQuery.getArgCount(), offset);
        Cursor cursor = this.mDb.query(sqLiteQuery);
        try {
            List<T> list = this.convertRows(cursor);
            return list;
        }
        finally {
            cursor.close();
            sqLiteQuery.release();
        }
    }

    protected abstract List<T> convertRows(Cursor var1);

    @Nullable
    public List<T> loadAfterInitial(int position, int pageSize) {
        if (this.isInvalid()) {
            return null;
        }
        List<T> result = this.queryRange(position + 1, pageSize);
        if (this.isInvalid()) {
            return null;
        }
        return result;
    }

    @Nullable
    public List<T> loadAfter(int currentEndIndex, @NonNull T currentEndItem, int pageSize) {
        if (this.isInvalid()) {
            return null;
        }
        List<T> result = this.queryRange(currentEndIndex + 1, pageSize);
        if (this.isInvalid()) {
            return null;
        }
        return result;
    }

    @Nullable
    public List<T> loadBefore(int currentBeginIndex, @NonNull T currentBeginItem, int pageSize) {
        if (this.isInvalid()) {
            return null;
        }
        int offset = Math.max(0, currentBeginIndex - pageSize);
        List<T> list = this.queryRange(offset, pageSize);
        Collections.reverse(list);
        if (this.isInvalid()) {
            return null;
        }
        return list;
    }
}

