/*
 * Decompiled with CFR 0.152.
 */
package android.arch.persistence.room.testing;

import android.app.Instrumentation;
import android.arch.persistence.db.SupportSQLiteDatabase;
import android.arch.persistence.db.SupportSQLiteOpenHelper;
import android.arch.persistence.db.framework.FrameworkSQLiteOpenHelperFactory;
import android.arch.persistence.room.DatabaseConfiguration;
import android.arch.persistence.room.RoomDatabase;
import android.arch.persistence.room.RoomOpenHelper;
import android.arch.persistence.room.migration.Migration;
import android.arch.persistence.room.migration.bundle.DatabaseBundle;
import android.arch.persistence.room.migration.bundle.EntityBundle;
import android.arch.persistence.room.migration.bundle.FieldBundle;
import android.arch.persistence.room.migration.bundle.ForeignKeyBundle;
import android.arch.persistence.room.migration.bundle.SchemaBundle;
import android.arch.persistence.room.util.TableInfo;
import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class MigrationTestHelper
extends TestWatcher {
    private static final String TAG = "MigrationTestHelper";
    private final String mAssetsFolder;
    private final SupportSQLiteOpenHelper.Factory mOpenFactory;
    private List<WeakReference<SupportSQLiteDatabase>> mManagedDatabases = new ArrayList<WeakReference<SupportSQLiteDatabase>>();
    private List<WeakReference<RoomDatabase>> mManagedRoomDatabases = new ArrayList<WeakReference<RoomDatabase>>();
    private boolean mTestStarted;
    private Instrumentation mInstrumentation;

    public MigrationTestHelper(Instrumentation instrumentation, String assetsFolder) {
        this(instrumentation, assetsFolder, (SupportSQLiteOpenHelper.Factory)new FrameworkSQLiteOpenHelperFactory());
    }

    public MigrationTestHelper(Instrumentation instrumentation, String assetsFolder, SupportSQLiteOpenHelper.Factory openFactory) {
        this.mInstrumentation = instrumentation;
        if (assetsFolder.endsWith("/")) {
            assetsFolder = assetsFolder.substring(0, assetsFolder.length() - 1);
        }
        this.mAssetsFolder = assetsFolder;
        this.mOpenFactory = openFactory;
    }

    protected void starting(Description description) {
        super.starting(description);
        this.mTestStarted = true;
    }

    public SupportSQLiteDatabase createDatabase(String name, int version) throws IOException {
        File dbPath = this.mInstrumentation.getTargetContext().getDatabasePath(name);
        if (dbPath.exists()) {
            Log.d((String)TAG, (String)("deleting database file " + name));
            if (!dbPath.delete()) {
                throw new IllegalStateException("there is a database file and i could not delete it. Make sure you don't have any open connections to that database before calling this method.");
            }
        }
        SchemaBundle schemaBundle = this.loadSchema(version);
        RoomDatabase.MigrationContainer container = new RoomDatabase.MigrationContainer();
        DatabaseConfiguration configuration = new DatabaseConfiguration(this.mInstrumentation.getTargetContext(), name, this.mOpenFactory, container, null, true, true);
        RoomOpenHelper roomOpenHelper = new RoomOpenHelper(configuration, (RoomOpenHelper.Delegate)new CreatingDelegate(schemaBundle.getDatabase()), schemaBundle.getDatabase().getIdentityHash());
        return this.openDatabase(name, roomOpenHelper);
    }

    public SupportSQLiteDatabase runMigrationsAndValidate(String name, int version, boolean validateDroppedTables, Migration ... migrations) throws IOException {
        File dbPath = this.mInstrumentation.getTargetContext().getDatabasePath(name);
        if (!dbPath.exists()) {
            throw new IllegalStateException("Cannot find the database file for " + name + ". " + "Before calling runMigrations, you must first create the database via " + "createDatabase.");
        }
        SchemaBundle schemaBundle = this.loadSchema(version);
        RoomDatabase.MigrationContainer container = new RoomDatabase.MigrationContainer();
        container.addMigrations(migrations);
        DatabaseConfiguration configuration = new DatabaseConfiguration(this.mInstrumentation.getTargetContext(), name, this.mOpenFactory, container, null, true, true);
        RoomOpenHelper roomOpenHelper = new RoomOpenHelper(configuration, (RoomOpenHelper.Delegate)new MigratingDelegate(schemaBundle.getDatabase(), validateDroppedTables), schemaBundle.getDatabase().getIdentityHash());
        return this.openDatabase(name, roomOpenHelper);
    }

    private SupportSQLiteDatabase openDatabase(String name, RoomOpenHelper roomOpenHelper) {
        SupportSQLiteOpenHelper.Configuration config = SupportSQLiteOpenHelper.Configuration.builder((Context)this.mInstrumentation.getTargetContext()).callback((SupportSQLiteOpenHelper.Callback)roomOpenHelper).name(name).build();
        SupportSQLiteDatabase db = this.mOpenFactory.create(config).getWritableDatabase();
        this.mManagedDatabases.add(new WeakReference<SupportSQLiteDatabase>(db));
        return db;
    }

    protected void finished(Description description) {
        super.finished(description);
        for (WeakReference<SupportSQLiteDatabase> weakReference : this.mManagedDatabases) {
            SupportSQLiteDatabase db = (SupportSQLiteDatabase)weakReference.get();
            if (db == null || !db.isOpen()) continue;
            try {
                db.close();
            }
            catch (Throwable throwable) {}
        }
        for (WeakReference<SupportSQLiteDatabase> weakReference : this.mManagedRoomDatabases) {
            RoomDatabase roomDatabase = (RoomDatabase)weakReference.get();
            if (roomDatabase == null) continue;
            roomDatabase.close();
        }
    }

    public void closeWhenFinished(SupportSQLiteDatabase db) {
        if (!this.mTestStarted) {
            throw new IllegalStateException("You cannot register a database to be closed before the test starts. Maybe you forgot to annotate MigrationTestHelper as a test rule? (@Rule)");
        }
        this.mManagedDatabases.add(new WeakReference<SupportSQLiteDatabase>(db));
    }

    public void closeWhenFinished(RoomDatabase db) {
        if (!this.mTestStarted) {
            throw new IllegalStateException("You cannot register a database to be closed before the test starts. Maybe you forgot to annotate MigrationTestHelper as a test rule? (@Rule)");
        }
        this.mManagedRoomDatabases.add(new WeakReference<RoomDatabase>(db));
    }

    private SchemaBundle loadSchema(int version) throws IOException {
        try {
            return this.loadSchema(this.mInstrumentation.getContext(), version);
        }
        catch (FileNotFoundException testAssetsIOExceptions) {
            Log.w((String)TAG, (String)"Could not find the schema file in the test assets. Checking the application assets");
            try {
                return this.loadSchema(this.mInstrumentation.getTargetContext(), version);
            }
            catch (FileNotFoundException appAssetsException) {
                throw new FileNotFoundException("Cannot find the schema file in the assets folder. Make sure to include the exported json schemas in your test assert inputs. See https://developer.android.com/topic/libraries/architecture/room.html#db-migration-testing for details. Missing file: " + testAssetsIOExceptions.getMessage());
            }
        }
    }

    private SchemaBundle loadSchema(Context context, int version) throws IOException {
        InputStream input = context.getAssets().open(this.mAssetsFolder + "/" + version + ".json");
        return SchemaBundle.deserialize((InputStream)input);
    }

    private static TableInfo toTableInfo(EntityBundle entityBundle) {
        return new TableInfo(entityBundle.getTableName(), MigrationTestHelper.toColumnMap(entityBundle), MigrationTestHelper.toForeignKeys(entityBundle.getForeignKeys()));
    }

    private static Set<TableInfo.ForeignKey> toForeignKeys(List<ForeignKeyBundle> bundles) {
        if (bundles == null) {
            return Collections.emptySet();
        }
        HashSet<TableInfo.ForeignKey> result = new HashSet<TableInfo.ForeignKey>(bundles.size());
        for (ForeignKeyBundle bundle : bundles) {
            result.add(new TableInfo.ForeignKey(bundle.getTable(), bundle.getOnDelete(), bundle.getOnUpdate(), bundle.getColumns(), bundle.getReferencedColumns()));
        }
        return result;
    }

    private static Map<String, TableInfo.Column> toColumnMap(EntityBundle entity) {
        HashMap<String, TableInfo.Column> result = new HashMap<String, TableInfo.Column>();
        for (FieldBundle bundle : entity.getFields()) {
            TableInfo.Column column = MigrationTestHelper.toColumn(entity, bundle);
            result.put(column.name, column);
        }
        return result;
    }

    private static TableInfo.Column toColumn(EntityBundle entity, FieldBundle field) {
        return new TableInfo.Column(field.getColumnName(), field.getAffinity(), field.isNonNull(), MigrationTestHelper.findPrimaryKeyPosition(entity, field));
    }

    private static int findPrimaryKeyPosition(EntityBundle entity, FieldBundle field) {
        List columnNames = entity.getPrimaryKey().getColumnNames();
        int i = 0;
        for (String columnName : columnNames) {
            ++i;
            if (!field.getColumnName().equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return 0;
    }

    static abstract class RoomOpenHelperDelegate
    extends RoomOpenHelper.Delegate {
        final DatabaseBundle mDatabaseBundle;

        RoomOpenHelperDelegate(DatabaseBundle databaseBundle) {
            super(databaseBundle.getVersion());
            this.mDatabaseBundle = databaseBundle;
        }

        protected void dropAllTables(SupportSQLiteDatabase database) {
            throw new UnsupportedOperationException("cannot drop all tables in the test");
        }

        protected void onCreate(SupportSQLiteDatabase database) {
        }

        protected void onOpen(SupportSQLiteDatabase database) {
        }
    }

    static class CreatingDelegate
    extends RoomOpenHelperDelegate {
        CreatingDelegate(DatabaseBundle databaseBundle) {
            super(databaseBundle);
        }

        protected void createAllTables(SupportSQLiteDatabase database) {
            for (String query : this.mDatabaseBundle.buildCreateQueries()) {
                database.execSQL(query);
            }
        }

        protected void validateMigration(SupportSQLiteDatabase db) {
            throw new UnsupportedOperationException("This open helper just creates the database but it received a migration request.");
        }
    }

    class MigratingDelegate
    extends RoomOpenHelperDelegate {
        private final boolean mVerifyDroppedTables;

        MigratingDelegate(DatabaseBundle databaseBundle, boolean verifyDroppedTables) {
            super(databaseBundle);
            this.mVerifyDroppedTables = verifyDroppedTables;
        }

        protected void createAllTables(SupportSQLiteDatabase database) {
            throw new UnsupportedOperationException("Was expecting to migrate but received create.Make sure you have created the database first.");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void validateMigration(SupportSQLiteDatabase db) {
            Map tables = this.mDatabaseBundle.getEntitiesByTableName();
            for (EntityBundle entity : tables.values()) {
                TableInfo found;
                TableInfo expected = MigrationTestHelper.toTableInfo(entity);
                if (expected.equals((Object)(found = TableInfo.read((SupportSQLiteDatabase)db, (String)entity.getTableName())))) continue;
                throw new IllegalStateException("Migration failed. expected:" + expected + " , found:" + found);
            }
            if (this.mVerifyDroppedTables) {
                try (Cursor cursor = db.query("SELECT name FROM sqlite_master WHERE type='table' AND name NOT IN(?, ?, ?)", (Object[])new String[]{"room_master_table", "android_metadata", "sqlite_sequence"});){
                    while (cursor.moveToNext()) {
                        String tableName = cursor.getString(0);
                        if (tables.containsKey(tableName)) continue;
                        throw new IllegalStateException("Migration failed. Unexpected table " + tableName);
                    }
                }
            }
        }
    }
}

