/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.graphics.drawable;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.util.StateSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.appcompat.graphics.drawable.DrawableContainerCompat;
import androidx.appcompat.resources.Compatibility;
import androidx.appcompat.resources.R;
import androidx.appcompat.widget.ResourceManagerInternal;
import androidx.core.content.res.TypedArrayUtils;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class StateListDrawableCompat
extends DrawableContainerCompat {
    private static final String TAG = "StateListDrawableCompat";
    private static final boolean DEBUG = false;
    private StateListState mStateListState;
    private boolean mMutated;

    public StateListDrawableCompat() {
        this(null, null);
    }

    public void addState(int[] stateSet, Drawable drawable2) {
        if (drawable2 != null) {
            this.mStateListState.addStateSet(stateSet, drawable2);
            this.onStateChange(this.getState());
        }
    }

    @Override
    public boolean isStateful() {
        return true;
    }

    @Override
    protected boolean onStateChange(@NonNull int[] stateSet) {
        boolean changed = super.onStateChange(stateSet);
        int idx = this.mStateListState.indexOfStateSet(stateSet);
        if (idx < 0) {
            idx = this.mStateListState.indexOfStateSet(StateSet.WILD_CARD);
        }
        return this.selectDrawable(idx) || changed;
    }

    public void inflate(@NonNull Context context, @NonNull Resources r, @NonNull XmlPullParser parser, @NonNull AttributeSet attrs, @Nullable Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = TypedArrayUtils.obtainAttributes((Resources)r, (Resources.Theme)theme, (AttributeSet)attrs, (int[])R.styleable.StateListDrawable);
        this.setVisible(a.getBoolean(R.styleable.StateListDrawable_android_visible, true), true);
        this.updateStateFromTypedArray(a);
        this.updateDensity(r);
        a.recycle();
        this.inflateChildElements(context, r, parser, attrs, theme);
        this.onStateChange(this.getState());
    }

    private void updateStateFromTypedArray(TypedArray a) {
        StateListState state = this.mStateListState;
        if (Build.VERSION.SDK_INT >= 21) {
            state.mChangingConfigurations |= Compatibility.Api21Impl.getChangingConfigurations(a);
        }
        state.mVariablePadding = a.getBoolean(R.styleable.StateListDrawable_android_variablePadding, state.mVariablePadding);
        state.mConstantSize = a.getBoolean(R.styleable.StateListDrawable_android_constantSize, state.mConstantSize);
        state.mEnterFadeDuration = a.getInt(R.styleable.StateListDrawable_android_enterFadeDuration, state.mEnterFadeDuration);
        state.mExitFadeDuration = a.getInt(R.styleable.StateListDrawable_android_exitFadeDuration, state.mExitFadeDuration);
        state.mDither = a.getBoolean(R.styleable.StateListDrawable_android_dither, state.mDither);
    }

    private void inflateChildElements(Context context, Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        int depth;
        int type;
        StateListState state = this.mStateListState;
        int innerDepth = parser.getDepth() + 1;
        while ((type = parser.next()) != 1 && ((depth = parser.getDepth()) >= innerDepth || type != 3)) {
            if (type != 2 || depth > innerDepth || !parser.getName().equals("item")) continue;
            TypedArray a = TypedArrayUtils.obtainAttributes((Resources)r, (Resources.Theme)theme, (AttributeSet)attrs, (int[])R.styleable.StateListDrawableItem);
            Drawable dr = null;
            int drawableId = a.getResourceId(R.styleable.StateListDrawableItem_android_drawable, -1);
            if (drawableId > 0) {
                dr = ResourceManagerInternal.get().getDrawable(context, drawableId);
            }
            a.recycle();
            int[] states = this.extractStateSet(attrs);
            if (dr == null) {
                while ((type = parser.next()) == 4) {
                }
                if (type != 2) {
                    throw new XmlPullParserException(parser.getPositionDescription() + ": <item> tag requires a 'drawable' attribute or child tag defining a drawable");
                }
                dr = Build.VERSION.SDK_INT >= 21 ? Compatibility.Api21Impl.createFromXmlInner(r, parser, attrs, theme) : Drawable.createFromXmlInner((Resources)r, (XmlPullParser)parser, (AttributeSet)attrs);
            }
            state.addStateSet(states, dr);
        }
    }

    int[] extractStateSet(AttributeSet attrs) {
        int j = 0;
        int numAttrs = attrs.getAttributeCount();
        int[] states = new int[numAttrs];
        block4: for (int i = 0; i < numAttrs; ++i) {
            int stateResId = attrs.getAttributeNameResource(i);
            switch (stateResId) {
                case 0: {
                    continue block4;
                }
                case 0x10100D0: 
                case 0x1010199: {
                    continue block4;
                }
                default: {
                    states[j++] = attrs.getAttributeBooleanValue(i, false) ? stateResId : -stateResId;
                }
            }
        }
        states = StateSet.trimStateSet((int[])states, (int)j);
        return states;
    }

    StateListState getStateListState() {
        return this.mStateListState;
    }

    int getStateCount() {
        return this.mStateListState.getChildCount();
    }

    int[] getStateSet(int index) {
        return this.mStateListState.mStateSets[index];
    }

    Drawable getStateDrawable(int index) {
        return this.mStateListState.getChild(index);
    }

    int getStateDrawableIndex(int[] stateSet) {
        return this.mStateListState.indexOfStateSet(stateSet);
    }

    @Override
    @NonNull
    public Drawable mutate() {
        if (!this.mMutated && super.mutate() == this) {
            this.mStateListState.mutate();
            this.mMutated = true;
        }
        return this;
    }

    @Override
    StateListState cloneConstantState() {
        return new StateListState(this.mStateListState, this, null);
    }

    @Override
    void clearMutated() {
        super.clearMutated();
        this.mMutated = false;
    }

    @Override
    @RequiresApi(value=21)
    public void applyTheme(@NonNull Resources.Theme theme) {
        super.applyTheme(theme);
        this.onStateChange(this.getState());
    }

    @Override
    void setConstantState(@NonNull DrawableContainerCompat.DrawableContainerState state) {
        super.setConstantState(state);
        if (state instanceof StateListState) {
            this.mStateListState = (StateListState)state;
        }
    }

    StateListDrawableCompat(StateListState state, Resources res) {
        StateListState newState = new StateListState(state, this, res);
        this.setConstantState(newState);
        this.onStateChange(this.getState());
    }

    StateListDrawableCompat(@Nullable StateListState state) {
        if (state != null) {
            this.setConstantState(state);
        }
    }

    static class StateListState
    extends DrawableContainerCompat.DrawableContainerState {
        int[][] mStateSets;

        StateListState(StateListState orig, StateListDrawableCompat owner, Resources res) {
            super(orig, owner, res);
            this.mStateSets = orig != null ? orig.mStateSets : (int[][])new int[this.getCapacity()][];
        }

        @Override
        void mutate() {
            int[][] stateSets = new int[this.mStateSets.length][];
            for (int i = this.mStateSets.length - 1; i >= 0; --i) {
                stateSets[i] = this.mStateSets[i] != null ? (int[])this.mStateSets[i].clone() : null;
            }
            this.mStateSets = stateSets;
        }

        int addStateSet(int[] stateSet, Drawable drawable2) {
            int pos = this.addChild(drawable2);
            this.mStateSets[pos] = stateSet;
            return pos;
        }

        int indexOfStateSet(int[] stateSet) {
            int[][] stateSets = this.mStateSets;
            int count = this.getChildCount();
            for (int i = 0; i < count; ++i) {
                if (!StateSet.stateSetMatches((int[])stateSets[i], (int[])stateSet)) continue;
                return i;
            }
            return -1;
        }

        @NonNull
        public Drawable newDrawable() {
            return new StateListDrawableCompat(this, null);
        }

        @NonNull
        public Drawable newDrawable(Resources res) {
            return new StateListDrawableCompat(this, res);
        }

        @Override
        public void growArray(int oldSize, int newSize) {
            super.growArray(oldSize, newSize);
            int[][] newStateSets = new int[newSize][];
            System.arraycopy(this.mStateSets, 0, newStateSets, 0, oldSize);
            this.mStateSets = newStateSets;
        }
    }
}

