/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.appsearch.app.AppSearchSession;
import androidx.appsearch.app.GenericDocument;
import androidx.appsearch.app.GetByDocumentIdRequest;
import androidx.appsearch.app.GetSchemaResponse;
import androidx.appsearch.app.GlobalSearchSession;
import androidx.appsearch.app.SearchResult;
import androidx.appsearch.app.SearchResults;
import androidx.appsearch.app.SearchSpec;
import androidx.appsearch.exceptions.AppSearchException;
import androidx.appsearch.localstorage.LocalStorage;
import androidx.appsearch.platformstorage.PlatformStorage;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DebugAppSearchManager
implements Closeable {
    private static final int PAGE_SIZE = 100;
    private final Context mContext;
    private final ExecutorService mExecutor;
    private final SettableFuture<AppSearchSession> mAppSearchSessionFuture = SettableFuture.create();
    private final SettableFuture<GlobalSearchSession> mGlobalSearchSessionFuture = SettableFuture.create();
    private final int mSearchType;
    @Nullable
    private final String mTargetPackageName;
    private final String mTargetDatabase;

    private DebugAppSearchManager(@NonNull Context context, @NonNull ExecutorService executor, int searchType, @Nullable String targetPackageName, @NonNull String targetDatabaseName) {
        this.mContext = (Context)Preconditions.checkNotNull((Object)context);
        this.mExecutor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.mSearchType = searchType;
        this.mTargetPackageName = targetPackageName;
        this.mTargetDatabase = (String)Preconditions.checkNotNull((Object)targetDatabaseName);
    }

    @NonNull
    public static ListenableFuture<DebugAppSearchManager> createAsync(@NonNull Context context, @NonNull ExecutorService executor, @NonNull String databaseName, @Nullable String targetPackageName, int storageType, int searchType) throws AppSearchException {
        ListenableFuture debugAppSearchManagerListenableFuture;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull((Object)databaseName);
        if (searchType == 1) {
            Preconditions.checkArgument((storageType == 1 ? 1 : 0) != 0);
            Preconditions.checkNotNull((Object)targetPackageName);
        }
        DebugAppSearchManager debugAppSearchManager = new DebugAppSearchManager(context, executor, searchType, targetPackageName, databaseName);
        if (searchType == 1) {
            if (Build.VERSION.SDK_INT < 31) {
                throw new AppSearchException(3, "Platform Storage debugging only valid for S+ devices.");
            }
            debugAppSearchManagerListenableFuture = Futures.transform(debugAppSearchManager.initializeGlobalSearchSessionAsync(), unused -> debugAppSearchManager, (Executor)executor);
        } else {
            switch (storageType) {
                case 0: {
                    debugAppSearchManagerListenableFuture = Futures.transform(debugAppSearchManager.initializeLocalStorageAsync(databaseName), unused -> debugAppSearchManager, (Executor)executor);
                    break;
                }
                case 1: {
                    if (Build.VERSION.SDK_INT < 31) {
                        throw new AppSearchException(3, "Platform Storage debugging only valid for S+ devices.");
                    }
                    debugAppSearchManagerListenableFuture = Futures.transform(debugAppSearchManager.initializePlatformStorageAsync(databaseName), unused -> debugAppSearchManager, (Executor)executor);
                    break;
                }
                default: {
                    throw new AppSearchException(3, "Invalid storage type specified. Verify that the storage type that has been passed in the intent is valid.");
                }
            }
        }
        return debugAppSearchManagerListenableFuture;
    }

    @NonNull
    public ListenableFuture<SearchResults> getAllDocumentsSearchResultsAsync() {
        SearchSpec.Builder searchSpecBuilder = new SearchSpec.Builder().setResultCountPerPage(100).setTermMatch(2).addProjection("*", Collections.emptyList());
        String retrieveAllQueryString = "";
        if (this.mSearchType == 1) {
            searchSpecBuilder.addFilterPackageNames(new String[]{this.mTargetPackageName});
            return Futures.transform(this.mGlobalSearchSessionFuture, session -> session.search(retrieveAllQueryString, searchSpecBuilder.build()), (Executor)this.mExecutor);
        }
        return Futures.transform(this.mAppSearchSessionFuture, session -> session.search(retrieveAllQueryString, searchSpecBuilder.build()), (Executor)this.mExecutor);
    }

    @NonNull
    public ListenableFuture<List<GenericDocument>> getNextPageAsync(@NonNull SearchResults results) {
        Preconditions.checkNotNull((Object)results);
        return Futures.transform((ListenableFuture)results.getNextPageAsync(), DebugAppSearchManager::convertResultsToGenericDocuments, (Executor)this.mExecutor);
    }

    @NonNull
    public ListenableFuture<GenericDocument> getDocumentAsync(@NonNull String namespace, @NonNull String id) {
        Preconditions.checkNotNull((Object)id);
        Preconditions.checkNotNull((Object)namespace);
        GetByDocumentIdRequest request = new GetByDocumentIdRequest.Builder(namespace).addIds(new String[]{id}).build();
        if (this.mSearchType == 1) {
            return Futures.transformAsync(this.mGlobalSearchSessionFuture, session -> {
                if (!session.getFeatures().isFeatureSupported("GLOBAL_SEARCH_SESSION_GET_BY_ID")) {
                    return Futures.immediateFailedFuture((Throwable)new UnsupportedOperationException());
                }
                return Futures.transform((ListenableFuture)session.getByDocumentIdAsync(this.mTargetPackageName, this.mTargetDatabase, request), response -> (GenericDocument)response.getSuccesses().get(id), (Executor)this.mExecutor);
            }, (Executor)this.mExecutor);
        }
        return Futures.transformAsync(this.mAppSearchSessionFuture, session -> Futures.transform((ListenableFuture)session.getByDocumentIdAsync(request), response -> (GenericDocument)response.getSuccesses().get(id), (Executor)this.mExecutor), (Executor)this.mExecutor);
    }

    @NonNull
    public ListenableFuture<GetSchemaResponse> getSchemaAsync() {
        if (this.mSearchType == 1) {
            return Futures.transformAsync(this.mGlobalSearchSessionFuture, session -> {
                if (!session.getFeatures().isFeatureSupported("GLOBAL_SEARCH_SESSION_GET_SCHEMA")) {
                    return Futures.immediateFailedFuture((Throwable)new UnsupportedOperationException());
                }
                return session.getSchemaAsync(this.mTargetPackageName, this.mTargetDatabase);
            }, (Executor)this.mExecutor);
        }
        return Futures.transformAsync(this.mAppSearchSessionFuture, session -> session.getSchemaAsync(), (Executor)this.mExecutor);
    }

    @Override
    public void close() {
        if (this.mSearchType == 1) {
            Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{this.mGlobalSearchSessionFuture}).call(() -> {
                ((GlobalSearchSession)Futures.getDone(this.mGlobalSearchSessionFuture)).close();
                return null;
            }, (Executor)this.mExecutor);
        } else {
            Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{this.mAppSearchSessionFuture}).call(() -> {
                ((AppSearchSession)Futures.getDone(this.mAppSearchSessionFuture)).close();
                return null;
            }, (Executor)this.mExecutor);
        }
    }

    @NonNull
    private ListenableFuture<AppSearchSession> initializeLocalStorageAsync(@NonNull String databaseName) {
        this.mAppSearchSessionFuture.setFuture(LocalStorage.createSearchSessionAsync((LocalStorage.SearchContext)new LocalStorage.SearchContext.Builder(this.mContext, databaseName).build()));
        return this.mAppSearchSessionFuture;
    }

    @NonNull
    @RequiresApi(value=31)
    private ListenableFuture<AppSearchSession> initializePlatformStorageAsync(@NonNull String databaseName) {
        this.mAppSearchSessionFuture.setFuture(PlatformStorage.createSearchSessionAsync((PlatformStorage.SearchContext)new PlatformStorage.SearchContext.Builder(this.mContext, databaseName).build()));
        return this.mAppSearchSessionFuture;
    }

    @NonNull
    @RequiresApi(value=31)
    private ListenableFuture<GlobalSearchSession> initializeGlobalSearchSessionAsync() {
        this.mGlobalSearchSessionFuture.setFuture(PlatformStorage.createGlobalSearchSessionAsync((PlatformStorage.GlobalSearchContext)new PlatformStorage.GlobalSearchContext.Builder(this.mContext).build()));
        return this.mGlobalSearchSessionFuture;
    }

    private static List<GenericDocument> convertResultsToGenericDocuments(List<SearchResult> results) {
        ArrayList<GenericDocument> docs = new ArrayList<GenericDocument>(results.size());
        for (SearchResult result : results) {
            docs.add(result.getGenericDocument());
        }
        return docs;
    }
}

