/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.view;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appsearch.app.GenericDocument;
import androidx.appsearch.app.SearchResults;
import androidx.appsearch.debugview.DebugAppSearchManager;
import androidx.appsearch.debugview.R;
import androidx.appsearch.debugview.model.DocumentListModel;
import androidx.appsearch.debugview.view.AppSearchDebugActivity;
import androidx.appsearch.debugview.view.DocumentListItemAdapter;
import androidx.appsearch.debugview.view.ScrollListener;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DocumentListFragment
extends Fragment {
    private static final String TAG = "DocumentListFragment";
    private TextView mLoadingView;
    private TextView mEmptyDocumentsView;
    private RecyclerView mDocumentListRecyclerView;
    private LinearLayoutManager mLinearLayoutManager;
    private DocumentListItemAdapter mDocumentListItemAdapter;
    private ListeningExecutorService mExecutor;
    private ListenableFuture<DebugAppSearchManager> mDebugAppSearchManager;
    private AppSearchDebugActivity mAppSearchDebugActivity;
    protected boolean mLoadingPage = false;
    @Nullable
    protected DocumentListModel mDocumentListModel;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_document_list, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mLoadingView = (TextView)this.getView().findViewById(R.id.loading_text_view);
        this.mEmptyDocumentsView = (TextView)this.getView().findViewById(R.id.empty_documents_text_view);
        this.mDocumentListRecyclerView = (RecyclerView)this.getView().findViewById(R.id.document_list_recycler_view);
        this.mAppSearchDebugActivity = (AppSearchDebugActivity)this.getActivity();
        this.mExecutor = this.mAppSearchDebugActivity.getBackgroundExecutor();
        this.mDebugAppSearchManager = this.mAppSearchDebugActivity.getDebugAppSearchManager();
        this.initDocumentListRecyclerView();
        Futures.addCallback(this.mDebugAppSearchManager, (FutureCallback)new FutureCallback<DebugAppSearchManager>(){

            public void onSuccess(DebugAppSearchManager debugAppSearchManager) {
                DocumentListFragment.this.readDocuments(debugAppSearchManager);
            }

            public void onFailure(@NonNull Throwable t) {
                Toast.makeText((Context)DocumentListFragment.this.getContext(), (CharSequence)("Failed to initialize AppSearch: " + t.getMessage()), (int)1).show();
                Log.e((String)DocumentListFragment.TAG, (String)"Failed to initialize AppSearch. Verify that the database name has been provided in the intent with key: databaseName", (Throwable)t);
            }
        }, (Executor)ContextCompat.getMainExecutor((Context)this.mAppSearchDebugActivity));
    }

    protected void readDocuments(@NonNull DebugAppSearchManager debugAppSearchManager) {
        this.mDocumentListModel = (DocumentListModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new DocumentListModel.DocumentListModelFactory(this.mExecutor, debugAppSearchManager)).get(DocumentListModel.class);
        if (this.mDocumentListModel.hasAdditionalPages()) {
            this.mDocumentListModel.getAllDocumentsSearchResults().observe((LifecycleOwner)this, results -> {
                this.mLoadingView.setVisibility(8);
                this.displayNextSearchResultsPage((SearchResults)results);
            });
        } else {
            this.mLoadingView.setVisibility(8);
            this.mDocumentListItemAdapter.setDocuments(this.mDocumentListModel.getAllLoadedDocuments());
        }
    }

    private void displayNextSearchResultsPage(final @NonNull SearchResults searchResults) {
        this.mDocumentListModel.addAdditionalResultsPage(searchResults).observe((LifecycleOwner)this, docs -> {
            this.mDocumentListItemAdapter.setDocuments((List<GenericDocument>)docs);
            if (docs.size() == 0) {
                this.mEmptyDocumentsView.setVisibility(0);
                this.mDocumentListRecyclerView.setVisibility(8);
            }
            this.mLoadingPage = false;
        });
        this.mDocumentListRecyclerView.addOnScrollListener((RecyclerView.OnScrollListener)new ScrollListener(this.mLinearLayoutManager){

            @Override
            public void loadNextPage() {
                DocumentListFragment.this.mLoadingPage = true;
                DocumentListFragment.this.mDocumentListModel.addAdditionalResultsPage(searchResults);
            }

            @Override
            public boolean isLoading() {
                return DocumentListFragment.this.mLoadingPage;
            }

            @Override
            public boolean hasAdditionalPages() {
                return DocumentListFragment.this.mDocumentListModel.hasAdditionalPages();
            }
        });
    }

    private void initDocumentListRecyclerView() {
        this.mLinearLayoutManager = new LinearLayoutManager((Context)this.mAppSearchDebugActivity);
        this.mLinearLayoutManager.setOrientation(1);
        this.mDocumentListItemAdapter = new DocumentListItemAdapter(Collections.emptyList(), this);
        this.mDocumentListRecyclerView.setAdapter((RecyclerView.Adapter)this.mDocumentListItemAdapter);
        this.mDocumentListRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLinearLayoutManager);
        DividerItemDecoration dividerItemDecoration = new DividerItemDecoration((Context)this.mAppSearchDebugActivity, this.mLinearLayoutManager.getOrientation());
        this.mDocumentListRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration);
    }
}

