/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.appsearch.app.GenericDocument;
import androidx.appsearch.debugview.R;
import androidx.appsearch.debugview.view.DocumentFragment;
import androidx.appsearch.debugview.view.DocumentListFragment;
import androidx.core.util.Preconditions;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DocumentListItemAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<GenericDocument> mDocuments;
    private DocumentListFragment mDocumentListFragment;

    DocumentListItemAdapter(@NonNull List<GenericDocument> documents, @NonNull DocumentListFragment documentListFragment) {
        this.mDocuments = (List)Preconditions.checkNotNull(documents);
        this.mDocumentListFragment = (DocumentListFragment)((Object)Preconditions.checkNotNull((Object)((Object)documentListFragment)));
    }

    public void setDocuments(@NonNull List<GenericDocument> documents) {
        this.mDocuments = (List)Preconditions.checkNotNull(documents);
        this.notifyDataSetChanged();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.adapter_document_list_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        String namespace = this.mDocuments.get(position).getNamespace();
        String id2 = this.mDocuments.get(position).getId();
        holder.getNamespaceLabel().setText((CharSequence)("Namespace: \"" + namespace + "\""));
        holder.getIdLabel().setText((CharSequence)("ID: \"" + id2 + "\""));
        holder.itemView.setOnClickListener(unusedView -> {
            DocumentFragment documentFragment = DocumentFragment.createDocumentFragment(namespace, id2);
            this.mDocumentListFragment.getActivity().getSupportFragmentManager().beginTransaction().replace(R.id.fragment_container, (Fragment)documentFragment).addToBackStack(null).commit();
        });
    }

    public int getItemCount() {
        return this.mDocuments.size();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView mNamespaceLabel;
        private final TextView mIdLabel;

        public ViewHolder(@NonNull View view) {
            super(view);
            Preconditions.checkNotNull((Object)view);
            this.mNamespaceLabel = (TextView)view.findViewById(R.id.doc_item_namespace);
            this.mIdLabel = (TextView)view.findViewById(R.id.doc_item_id);
        }

        @NonNull
        public TextView getNamespaceLabel() {
            return this.mNamespaceLabel;
        }

        @NonNull
        public TextView getIdLabel() {
            return this.mIdLabel;
        }
    }
}

