/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.appsearch.app.AppSearchSchema;
import androidx.appsearch.debugview.R;
import androidx.core.util.Preconditions;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SchemaTypeListItemAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private List<AppSearchSchema> mSchemaTypes;

    SchemaTypeListItemAdapter(@NonNull List<AppSearchSchema> schemaTypes) {
        this.mSchemaTypes = (List)Preconditions.checkNotNull(schemaTypes);
    }

    public void setSchemaTypes(@NonNull List<AppSearchSchema> schemaTypes) {
        this.mSchemaTypes = (List)Preconditions.checkNotNull(schemaTypes);
        this.notifyDataSetChanged();
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.adapter_schema_type_list_item, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        String schemaType = this.mSchemaTypes.get(position).getSchemaType();
        holder.getSchemaTypeLabel().setText((CharSequence)schemaType);
    }

    public int getItemCount() {
        return this.mSchemaTypes.size();
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView mSchemaTypeLabel;

        public ViewHolder(@NonNull View view) {
            super(view);
            Preconditions.checkNotNull((Object)view);
            this.mSchemaTypeLabel = (TextView)view.findViewById(R.id.schema_type_item_title);
        }

        @NonNull
        public TextView getSchemaTypeLabel() {
            return this.mSchemaTypeLabel;
        }
    }
}

