/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.model;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.appsearch.app.GenericDocument;
import androidx.appsearch.app.SearchResults;
import androidx.appsearch.debugview.DebugAppSearchManager;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DocumentListModel
extends ViewModel {
    private static final String TAG = "DocumentListModel";
    private final ExecutorService mExecutor;
    private final DebugAppSearchManager mDebugAppSearchManager;
    final MutableLiveData<List<GenericDocument>> mDocumentsLiveData = new MutableLiveData();
    final MutableLiveData<SearchResults> mDocumentsSearchResultsLiveData = new MutableLiveData();
    volatile boolean mHasAdditionalPages = true;

    public DocumentListModel(@NonNull ExecutorService executor, @NonNull DebugAppSearchManager debugAppSearchManager) {
        this.mExecutor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.mDebugAppSearchManager = (DebugAppSearchManager)Preconditions.checkNotNull((Object)debugAppSearchManager);
    }

    @NonNull
    public LiveData<SearchResults> getAllDocumentsSearchResults() {
        Futures.addCallback(this.mDebugAppSearchManager.getAllDocumentsSearchResultsAsync(), (FutureCallback)new FutureCallback<SearchResults>(){

            public void onSuccess(SearchResults result) {
                if (DocumentListModel.this.mDocumentsSearchResultsLiveData.getValue() == null) {
                    DocumentListModel.this.mDocumentsSearchResultsLiveData.postValue((Object)result);
                }
            }

            public void onFailure(@NonNull Throwable t) {
                Log.e((String)DocumentListModel.TAG, (String)"Failed to get all documents.", (Throwable)t);
            }
        }, (Executor)this.mExecutor);
        return this.mDocumentsSearchResultsLiveData;
    }

    @NonNull
    public LiveData<List<GenericDocument>> addAdditionalResultsPage(@NonNull SearchResults results) {
        Futures.addCallback(this.mDebugAppSearchManager.getNextPageAsync(results), (FutureCallback)new FutureCallback<List<GenericDocument>>(){

            public void onSuccess(List<GenericDocument> result) {
                if (DocumentListModel.this.mDocumentsLiveData.getValue() == null) {
                    DocumentListModel.this.mDocumentsLiveData.postValue(result);
                } else {
                    if (result.isEmpty()) {
                        DocumentListModel.this.mHasAdditionalPages = false;
                    }
                    ((List)DocumentListModel.this.mDocumentsLiveData.getValue()).addAll(result);
                    DocumentListModel.this.mDocumentsLiveData.postValue((Object)((List)DocumentListModel.this.mDocumentsLiveData.getValue()));
                }
            }

            public void onFailure(@NonNull Throwable t) {
                Log.e((String)DocumentListModel.TAG, (String)"Failed to get next page of documents.", (Throwable)t);
            }
        }, (Executor)this.mExecutor);
        return this.mDocumentsLiveData;
    }

    public boolean hasAdditionalPages() {
        return this.mHasAdditionalPages;
    }

    @NonNull
    public List<GenericDocument> getAllLoadedDocuments() {
        if (this.mDocumentsLiveData.getValue() == null) {
            return Collections.emptyList();
        }
        return (List)this.mDocumentsLiveData.getValue();
    }

    public static class DocumentListModelFactory
    extends ViewModelProvider.NewInstanceFactory {
        private final DebugAppSearchManager mDebugAppSearchManager;
        private final ListeningExecutorService mExecutorService;

        public DocumentListModelFactory(@NonNull ListeningExecutorService executor, @NonNull DebugAppSearchManager debugAppSearchManager) {
            this.mDebugAppSearchManager = debugAppSearchManager;
            this.mExecutorService = executor;
        }

        @NonNull
        public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
            if (modelClass == DocumentListModel.class) {
                return (T)((Object)new DocumentListModel((ExecutorService)this.mExecutorService, this.mDebugAppSearchManager));
            }
            throw new IllegalArgumentException("Expected class: DocumentListModel.");
        }
    }
}

