/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.model;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appsearch.app.GenericDocument;
import androidx.appsearch.debugview.DebugAppSearchManager;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DocumentModel
extends ViewModel {
    private static final String TAG = "AppSearchDocumentModel";
    private final ExecutorService mExecutor;
    private final DebugAppSearchManager mDebugAppSearchManager;
    final MutableLiveData<GenericDocument> mDocumentLiveData = new MutableLiveData();

    public DocumentModel(@NonNull ExecutorService executor, @NonNull DebugAppSearchManager debugAppSearchManager) {
        this.mExecutor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.mDebugAppSearchManager = (DebugAppSearchManager)Preconditions.checkNotNull((Object)debugAppSearchManager);
    }

    @NonNull
    public LiveData<GenericDocument> getDocument(final @NonNull String namespace, final @NonNull String id) {
        Futures.addCallback(this.mDebugAppSearchManager.getDocumentAsync(namespace, id), (FutureCallback)new FutureCallback<GenericDocument>(){

            public void onSuccess(GenericDocument result) {
                DocumentModel.this.mDocumentLiveData.postValue((Object)result);
            }

            public void onFailure(@Nullable Throwable t) {
                Log.e((String)DocumentModel.TAG, (String)("Failed to get document with namespace: " + namespace + " and id: " + id), (Throwable)t);
            }
        }, (Executor)this.mExecutor);
        return this.mDocumentLiveData;
    }

    public static class DocumentModelFactory
    extends ViewModelProvider.NewInstanceFactory {
        private final DebugAppSearchManager mDebugAppSearchManager;
        private final ListeningExecutorService mExecutorService;

        public DocumentModelFactory(@NonNull ListeningExecutorService executor, @NonNull DebugAppSearchManager debugAppSearchManager) {
            this.mDebugAppSearchManager = debugAppSearchManager;
            this.mExecutorService = executor;
        }

        @NonNull
        public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
            if (modelClass == DocumentModel.class) {
                return (T)((Object)new DocumentModel((ExecutorService)this.mExecutorService, this.mDebugAppSearchManager));
            }
            throw new IllegalArgumentException("Expected class: DocumentModel.");
        }
    }
}

