/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.model;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appsearch.app.AppSearchSchema;
import androidx.appsearch.app.GetSchemaResponse;
import androidx.appsearch.debugview.DebugAppSearchManager;
import androidx.core.util.Preconditions;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Transformations;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SchemaTypeListModel
extends ViewModel {
    private static final String TAG = "AppSearchSchemaTypeList";
    private final ExecutorService mExecutor;
    private final DebugAppSearchManager mDebugAppSearchManager;
    final MutableLiveData<GetSchemaResponse> mSchemaResponseMutableLiveData = new MutableLiveData();

    public SchemaTypeListModel(@NonNull ExecutorService executor, @NonNull DebugAppSearchManager debugAppSearchManager) {
        this.mExecutor = (ExecutorService)Preconditions.checkNotNull((Object)executor);
        this.mDebugAppSearchManager = (DebugAppSearchManager)Preconditions.checkNotNull((Object)debugAppSearchManager);
    }

    @NonNull
    public LiveData<List<AppSearchSchema>> getSchemaTypes() {
        return Transformations.map(this.getSchema(), input -> new ArrayList(input.getSchemas()));
    }

    @NonNull
    public LiveData<Integer> getSchemaVersion() {
        return Transformations.map(this.getSchema(), GetSchemaResponse::getVersion);
    }

    @NonNull
    private LiveData<GetSchemaResponse> getSchema() {
        Futures.addCallback(this.mDebugAppSearchManager.getSchemaAsync(), (FutureCallback)new FutureCallback<GetSchemaResponse>(){

            public void onSuccess(GetSchemaResponse result) {
                SchemaTypeListModel.this.mSchemaResponseMutableLiveData.postValue((Object)result);
            }

            public void onFailure(@Nullable Throwable t) {
                Log.e((String)SchemaTypeListModel.TAG, (String)"Failed to get schema.", (Throwable)t);
            }
        }, (Executor)this.mExecutor);
        return this.mSchemaResponseMutableLiveData;
    }

    public static class SchemaTypeListModelFactory
    extends ViewModelProvider.NewInstanceFactory {
        private final DebugAppSearchManager mDebugAppSearchManager;
        private final ListeningExecutorService mExecutorService;

        public SchemaTypeListModelFactory(@NonNull ListeningExecutorService executor, @NonNull DebugAppSearchManager debugAppSearchManager) {
            this.mDebugAppSearchManager = debugAppSearchManager;
            this.mExecutorService = executor;
        }

        @NonNull
        public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
            if (modelClass == SchemaTypeListModel.class) {
                return (T)((Object)new SchemaTypeListModel((ExecutorService)this.mExecutorService, this.mDebugAppSearchManager));
            }
            throw new IllegalArgumentException("Expected class: SchemaTypeListModel.");
        }
    }
}

