/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.view;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appsearch.app.AppSearchEnvironmentFactory;
import androidx.appsearch.debugview.DebugAppSearchManager;
import androidx.appsearch.debugview.R;
import androidx.appsearch.debugview.view.MenuFragment;
import androidx.appsearch.exceptions.AppSearchException;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class AppSearchDebugActivity
extends FragmentActivity {
    private static final String TAG = "AppSearchDebugActivity";
    public static final String TARGET_PACKAGE_NAME_INTENT_KEY = "targetPackageName";
    public static final String DB_INTENT_KEY = "databaseName";
    public static final String STORAGE_TYPE_INTENT_KEY = "storageType";
    public static final String SEARCH_TYPE_INTENT_KEY = "searchType";
    private String mDbName;
    private ListenableFuture<DebugAppSearchManager> mDebugAppSearchManager;
    private ListeningExecutorService mBackgroundExecutor;
    public static final int STORAGE_TYPE_LOCAL = 0;
    public static final int STORAGE_TYPE_PLATFORM = 1;
    public static final int SEARCH_TYPE_LOCAL = 0;
    public static final int SEARCH_TYPE_GLOBAL = 1;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_appsearchdebug);
        this.mBackgroundExecutor = MoreExecutors.listeningDecorator((ExecutorService)AppSearchEnvironmentFactory.getEnvironmentInstance().createCachedThreadPoolExecutor());
        this.mDbName = this.getIntent().getExtras().getString(DB_INTENT_KEY);
        String targetPackageName = this.getIntent().getExtras().getString(TARGET_PACKAGE_NAME_INTENT_KEY);
        int storageType = this.getIntent().getExtras().getInt(STORAGE_TYPE_INTENT_KEY);
        int searchType = this.getIntent().getExtras().getInt(SEARCH_TYPE_INTENT_KEY);
        try {
            this.mDebugAppSearchManager = DebugAppSearchManager.createAsync(this.getApplicationContext(), (ExecutorService)this.mBackgroundExecutor, this.mDbName, targetPackageName, storageType, searchType);
        }
        catch (AppSearchException e) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)("Failed to initialize AppSearch: " + e.getMessage()), (int)1).show();
            Log.e((String)TAG, (String)"Failed to initialize AppSearch.", (Throwable)e);
        }
        MenuFragment menuFragment = new MenuFragment();
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fragment_container, (Fragment)menuFragment).commit();
    }

    protected void onStop() {
        Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{this.mDebugAppSearchManager}).call(() -> {
            ((DebugAppSearchManager)Futures.getDone(this.mDebugAppSearchManager)).close();
            return null;
        }, (Executor)this.mBackgroundExecutor);
        super.onStop();
    }

    @NonNull
    public ListenableFuture<DebugAppSearchManager> getDebugAppSearchManager() {
        return this.mDebugAppSearchManager;
    }

    @NonNull
    public ListeningExecutorService getBackgroundExecutor() {
        return this.mBackgroundExecutor;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SearchType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StorageType {
    }
}

