/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.view;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appsearch.app.AppSearchSchema;
import androidx.appsearch.debugview.DebugAppSearchManager;
import androidx.appsearch.debugview.R;
import androidx.appsearch.debugview.model.SchemaTypeListModel;
import androidx.appsearch.debugview.view.AppSearchDebugActivity;
import androidx.appsearch.debugview.view.SchemaTypeListItemAdapter;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class SchemaTypeListFragment
extends Fragment {
    private static final String TAG = "AppSearchSchemaTypeFrag";
    private TextView mLoadingView;
    private TextView mEmptySchemaTypesView;
    private TextView mSchemaVersionView;
    private RecyclerView mSchemaTypeListRecyclerView;
    private LinearLayoutManager mLinearLayoutManager;
    private SchemaTypeListItemAdapter mSchemaTypeListItemAdapter;
    private ListeningExecutorService mExecutor;
    private ListenableFuture<DebugAppSearchManager> mDebugAppSearchManager;
    private AppSearchDebugActivity mAppSearchDebugActivity;
    @Nullable
    protected SchemaTypeListModel mSchemaTypeListModel;

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_schema_type_list, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        this.mLoadingView = (TextView)this.getView().findViewById(R.id.loading_schema_types_text_view);
        this.mEmptySchemaTypesView = (TextView)this.getView().findViewById(R.id.empty_schema_types_text_view);
        this.mSchemaTypeListRecyclerView = (RecyclerView)this.getView().findViewById(R.id.schema_type_list_recycler_view);
        this.mSchemaVersionView = (TextView)this.getView().findViewById(R.id.schema_version_view);
        this.mAppSearchDebugActivity = (AppSearchDebugActivity)this.getActivity();
        this.mExecutor = this.mAppSearchDebugActivity.getBackgroundExecutor();
        this.mDebugAppSearchManager = this.mAppSearchDebugActivity.getDebugAppSearchManager();
        this.initSchemaTypeListRecyclerView();
        Futures.addCallback(this.mDebugAppSearchManager, (FutureCallback)new FutureCallback<DebugAppSearchManager>(){

            public void onSuccess(DebugAppSearchManager debugAppSearchManager) {
                SchemaTypeListFragment.this.readSchema(debugAppSearchManager);
            }

            public void onFailure(@NonNull Throwable t) {
                Toast.makeText((Context)SchemaTypeListFragment.this.getContext(), (CharSequence)("Failed to initialize AppSearch: " + t.getMessage()), (int)1).show();
                Log.e((String)SchemaTypeListFragment.TAG, (String)"Failed to initialize AppSearch. Verify that the database name has been provided in the intent with key: databaseName", (Throwable)t);
            }
        }, (Executor)ContextCompat.getMainExecutor((Context)this.mAppSearchDebugActivity));
    }

    protected void readSchema(@NonNull DebugAppSearchManager debugAppSearchManager) {
        this.mSchemaTypeListModel = (SchemaTypeListModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new SchemaTypeListModel.SchemaTypeListModelFactory(this.mExecutor, debugAppSearchManager)).get(SchemaTypeListModel.class);
        this.mSchemaTypeListModel.getSchemaTypes().observe((LifecycleOwner)this, schemaTypeList -> {
            this.mLoadingView.setVisibility(8);
            if (schemaTypeList.size() == 0) {
                this.mEmptySchemaTypesView.setVisibility(0);
                this.mSchemaTypeListRecyclerView.setVisibility(8);
            } else {
                this.mSchemaTypeListItemAdapter.setSchemaTypes((List<AppSearchSchema>)schemaTypeList);
            }
        });
        this.mSchemaTypeListModel.getSchemaVersion().observe((LifecycleOwner)this, version -> {
            this.mSchemaVersionView.setText((CharSequence)this.getString(R.string.appsearch_schema_version, new Object[]{version}));
            this.mSchemaVersionView.setVisibility(0);
        });
    }

    private void initSchemaTypeListRecyclerView() {
        this.mLinearLayoutManager = new LinearLayoutManager((Context)this.mAppSearchDebugActivity);
        this.mLinearLayoutManager.setOrientation(1);
        this.mSchemaTypeListItemAdapter = new SchemaTypeListItemAdapter(Collections.emptyList());
        this.mSchemaTypeListRecyclerView.setAdapter((RecyclerView.Adapter)this.mSchemaTypeListItemAdapter);
        this.mSchemaTypeListRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLinearLayoutManager);
        DividerItemDecoration dividerItemDecoration = new DividerItemDecoration((Context)this.mAppSearchDebugActivity, this.mLinearLayoutManager.getOrientation());
        this.mSchemaTypeListRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration);
    }
}

