/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.view;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public abstract class ScrollListener
extends RecyclerView.OnScrollListener {
    private final LinearLayoutManager mLayoutManager;

    public ScrollListener(@NonNull LinearLayoutManager layoutManager) {
        this.mLayoutManager = (LinearLayoutManager)Preconditions.checkNotNull((Object)layoutManager);
    }

    public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
        boolean hasAdditionalRowsToFill;
        super.onScrolled(recyclerView, dx, dy);
        int itemsVisible = this.mLayoutManager.getChildCount();
        int totalItems = this.mLayoutManager.getItemCount();
        int firstItemInViewIndex = this.mLayoutManager.findFirstVisibleItemPosition();
        boolean bl = hasAdditionalRowsToFill = firstItemInViewIndex + itemsVisible >= totalItems;
        if (!this.isLoading() && this.hasAdditionalPages() && hasAdditionalRowsToFill && firstItemInViewIndex >= 0) {
            this.loadNextPage();
        }
    }

    public abstract void loadNextPage();

    public abstract boolean isLoading();

    public abstract boolean hasAdditionalPages();
}

