/*
 * Decompiled with CFR 0.152.
 */
package androidx.appsearch.debugview.view;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appsearch.debugview.DebugAppSearchManager;
import androidx.appsearch.debugview.R;
import androidx.appsearch.debugview.model.DocumentModel;
import androidx.appsearch.debugview.view.AppSearchDebugActivity;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DocumentFragment
extends Fragment {
    private static final String TAG = "AppSearchDocumentFrag";
    private static final String ARG_NAMESPACE = "document_namespace";
    private static final String ARG_ID = "document_id";
    private String mNamespace;
    private String mId;
    private ListeningExecutorService mExecutor;
    private ListenableFuture<DebugAppSearchManager> mDebugAppSearchManager;
    private DocumentModel mDocumentModel;

    @NonNull
    public static DocumentFragment createDocumentFragment(@NonNull String namespace, @NonNull String id2) {
        DocumentFragment documentFragment = new DocumentFragment();
        Bundle args = new Bundle();
        args.putString(ARG_NAMESPACE, namespace);
        args.putString(ARG_ID, id2);
        documentFragment.setArguments(args);
        return documentFragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mId = this.getArguments().getString(ARG_ID);
            this.mNamespace = this.getArguments().getString(ARG_NAMESPACE);
        }
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_document, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mExecutor = ((AppSearchDebugActivity)this.getActivity()).getBackgroundExecutor();
        this.mDebugAppSearchManager = ((AppSearchDebugActivity)this.getActivity()).getDebugAppSearchManager();
        Futures.addCallback(this.mDebugAppSearchManager, (FutureCallback)new FutureCallback<DebugAppSearchManager>(){

            public void onSuccess(DebugAppSearchManager debugAppSearchManager) {
                DocumentFragment.this.displayDocument(debugAppSearchManager);
            }

            public void onFailure(@NonNull Throwable t) {
                Toast.makeText((Context)DocumentFragment.this.getContext(), (CharSequence)("Failed to initialize AppSearch: " + t.getMessage()), (int)1).show();
                Log.e((String)DocumentFragment.TAG, (String)"Failed to initialize AppSearch. Verify that the database name has been provided in the intent with key: databaseName", (Throwable)t);
            }
        }, (Executor)ContextCompat.getMainExecutor((Context)this.getActivity()));
    }

    protected void displayDocument(@NonNull DebugAppSearchManager debugAppSearchManager) {
        this.mDocumentModel = (DocumentModel)new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new DocumentModel.DocumentModelFactory(this.mExecutor, debugAppSearchManager)).get(DocumentModel.class);
        this.mDocumentModel.getDocument(this.mNamespace, this.mId).observe((LifecycleOwner)this, document -> {
            TextView documentView = (TextView)this.getView().findViewById(R.id.document_string);
            documentView.setText((CharSequence)document.toString());
        });
    }
}

