/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.app.Instrumentation;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.util.JsonWriter;
import androidx.annotation.VisibleForTesting;
import androidx.benchmark.Arguments;
import androidx.benchmark.BenchmarkState;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.IsolationActivity;
import androidx.benchmark.MemInfo;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J#\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0001\u00a2\u0006\u0002\b\u0015J\f\u0010\u0016\u001a\u00020\u0017*\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0014\u0010\u0019\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\f\u001a\u00020\u0005H\u0002J\u0014\u0010\u001a\u001a\u00020\u0017*\u00020\u00172\u0006\u0010\f\u001a\u00020\u0005H\u0002R,\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u00068\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Landroidx/benchmark/ResultWriter;", "", "()V", "reports", "Ljava/util/ArrayList;", "Landroidx/benchmark/BenchmarkState$Report;", "Lkotlin/collections/ArrayList;", "reports$annotations", "getReports$benchmark_common_release", "()Ljava/util/ArrayList;", "appendReport", "", "report", "getParams", "", "", "testName", "writeReport", "file", "Ljava/io/File;", "", "writeReport$benchmark_common_release", "buildInfoObject", "Landroid/util/JsonWriter;", "metricsObject", "paramsObject", "reportObject", "benchmark-common_release"})
public final class ResultWriter {
    @NotNull
    private static final ArrayList<BenchmarkState.Report> reports;
    public static final ResultWriter INSTANCE;

    @VisibleForTesting
    public static /* synthetic */ void reports$annotations() {
    }

    @NotNull
    public final ArrayList<BenchmarkState.Report> getReports$benchmark_common_release() {
        return reports;
    }

    public final void appendReport(@NotNull BenchmarkState.Report report) {
        Intrinsics.checkParameterIsNotNull((Object)report, (String)"report");
        reports.add(report);
        if (Arguments.INSTANCE.getOutputEnable()) {
            File file;
            Instrumentation instrumentation = InstrumentationRegistry.getInstrumentation();
            Intrinsics.checkExpressionValueIsNotNull((Object)instrumentation, (String)"InstrumentationRegistry.getInstrumentation()");
            Context context = instrumentation.getTargetContext();
            if (context == null) {
                Intrinsics.throwNpe();
            }
            String packageName = context.getPackageName();
            String string = Arguments.INSTANCE.getAdditionalTestOutputDir();
            if (string != null) {
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                file = new File(it);
            } else {
                file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
            }
            File filePath = file;
            File file2 = new File(filePath, packageName + "-benchmarkData.json");
            this.writeReport$benchmark_common_release(file2, (List<BenchmarkState.Report>)reports);
        }
    }

    @VisibleForTesting
    public final void writeReport$benchmark_common_release(@NotNull File file, @NotNull List<BenchmarkState.Report> reports) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull(reports, (String)"reports");
        File file2 = file;
        boolean bl = false;
        boolean bl2 = false;
        File $this$run = file2;
        boolean bl3 = false;
        if (!$this$run.exists()) {
            File file3 = $this$run.getParentFile();
            if (file3 != null) {
                file3.mkdirs();
            }
            try {
                $this$run.createNewFile();
            }
            catch (IOException exception) {
                throw (Throwable)new IOException("Failed to create file for benchmark report. Make sure the\ninstrumentation argument additionalOutputDir is set to a writable\ndirectory on device. If using a version of Android Gradle Plugin that\ndoesn't support additionalOutputDir, ensure your app's manifest file\nenables legacy storage behavior by adding the application attribute:\nandroid:requestLegacyExternalStorage=\"true\"", exception);
            }
        }
        File file4 = $this$run;
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl4 = false;
        Object object = file4;
        boolean bl5 = false;
        Object object2 = object;
        boolean bl6 = false;
        object2 = new FileOutputStream((File)object2);
        bl6 = false;
        object = new OutputStreamWriter((OutputStream)object2, charset);
        bl5 = false;
        BufferedWriter bufferedWriter = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
        Writer writer = bufferedWriter;
        JsonWriter writer2 = new JsonWriter(writer);
        writer2.setIndent("    ");
        writer2.beginObject();
        JsonWriter jsonWriter = writer2.name("context").beginObject().name("build");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"writer.name(\"context\").b\u2026           .name(\"build\")");
        INSTANCE.buildInfoObject(jsonWriter).name("cpuCoreCount").value((Number)CpuInfo.INSTANCE.getCoreDirs().size()).name("cpuLocked").value(CpuInfo.INSTANCE.getLocked()).name("cpuMaxFreqHz").value(CpuInfo.INSTANCE.getMaxFreqHz()).name("memTotalBytes").value(MemInfo.INSTANCE.getMemTotalBytes()).name("sustainedPerformanceModeEnabled").value(IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release());
        writer2.endObject();
        writer2.name("benchmarks").beginArray();
        Iterable $this$forEach$iv = reports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BenchmarkState.Report it = (BenchmarkState.Report)element$iv;
            boolean bl7 = false;
            INSTANCE.reportObject(writer2, it);
        }
        writer2.endArray();
        writer2.endObject();
        writer2.flush();
        writer2.close();
    }

    private final JsonWriter buildInfoObject(@NotNull JsonWriter $this$buildInfoObject) {
        $this$buildInfoObject.beginObject().name("device").value(Build.DEVICE).name("fingerprint").value(Build.FINGERPRINT).name("model").value(Build.MODEL).name("version").beginObject().name("sdk").value((Number)Build.VERSION.SDK_INT).endObject();
        JsonWriter jsonWriter = $this$buildInfoObject.endObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"endObject()");
        return jsonWriter;
    }

    private final JsonWriter reportObject(@NotNull JsonWriter $this$reportObject, BenchmarkState.Report report) {
        JsonWriter jsonWriter = $this$reportObject.beginObject().name("name").value(report.getTestName()).name("params");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"beginObject()\n          \u2026          .name(\"params\")");
        JsonWriter jsonWriter2 = this.paramsObject(jsonWriter, report).name("className").value(report.getClassName()).name("totalRunTimeNs").value(report.getTotalRunTimeNs()).name("metrics");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter2, (String)"beginObject()\n          \u2026         .name(\"metrics\")");
        this.metricsObject(jsonWriter2, report).name("warmupIterations").value((Number)report.getWarmupIterations()).name("repeatIterations").value((Number)report.getRepeatIterations()).name("thermalThrottleSleepSeconds").value(report.getThermalThrottleSleepSeconds());
        JsonWriter jsonWriter3 = $this$reportObject.endObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter3, (String)"endObject()");
        return jsonWriter3;
    }

    private final JsonWriter paramsObject(@NotNull JsonWriter $this$paramsObject, BenchmarkState.Report report) {
        $this$paramsObject.beginObject();
        Map<String, String> $this$forEach$iv = this.getParams(report.getTestName());
        boolean $i$f$forEach = false;
        Map<String, String> map = $this$forEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> it = element$iv = iterator.next();
            boolean bl2 = false;
            $this$paramsObject.name(it.getKey()).value(it.getValue());
        }
        JsonWriter jsonWriter = $this$paramsObject.endObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"endObject()");
        return jsonWriter;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getParams(String testName) {
        int parameterStrStart = StringsKt.indexOf$default((CharSequence)testName, (char)'[', (int)0, (boolean)false, (int)6, null);
        int parameterStrEnd = StringsKt.lastIndexOf$default((CharSequence)testName, (char)']', (int)0, (boolean)false, (int)6, null);
        HashMap params = new HashMap();
        if (parameterStrStart >= 0 && parameterStrEnd >= 0) {
            String string = testName;
            int n = parameterStrStart + 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, parameterStrEnd);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String paramListString = string3;
            Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)paramListString, (String[])new String[]{","}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String value;
                String key;
                int separatorIndex;
                int $this$indexOfFirst$iv2;
                int n2;
                int n3;
                int n4;
                String paramString;
                block7: {
                    paramString = (String)element$iv;
                    boolean bl2 = false;
                    CharSequence $this$indexOfFirst$iv2 = paramString;
                    boolean $i$f$indexOfFirst = false;
                    n4 = 0;
                    n3 = $this$indexOfFirst$iv2.length();
                    while (n4 < n3) {
                        void index$iv;
                        char it = $this$indexOfFirst$iv2.charAt((int)index$iv);
                        boolean bl3 = false;
                        if (it == ':' || it == '=') {
                            n2 = index$iv;
                            break block7;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                if (1 > ($this$indexOfFirst$iv2 = (separatorIndex = n2)) || paramString.length() - 1 <= $this$indexOfFirst$iv2) continue;
                String $i$f$indexOfFirst = paramString;
                n4 = 0;
                n3 = 0;
                String string4 = $i$f$indexOfFirst;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(n4, separatorIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string5 = paramString;
                n3 = separatorIndex + 1;
                boolean bl4 = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring(n3), (String)"(this as java.lang.String).substring(startIndex)");
                ((Map)params).put(key, value);
            }
        }
        return params;
    }

    private final JsonWriter metricsObject(@NotNull JsonWriter $this$metricsObject, BenchmarkState.Report report) {
        $this$metricsObject.beginObject();
        $this$metricsObject.name("timeNs").beginObject().name("minimum").value(report.getStats().getMin()).name("maximum").value(report.getStats().getMax()).name("median").value(report.getStats().getMedian());
        $this$metricsObject.name("runs").beginArray();
        Iterable $this$forEach$iv = report.getData();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            long it = ((Number)element$iv).longValue();
            boolean bl = false;
            $this$metricsObject.value(it);
        }
        $this$metricsObject.endArray();
        $this$metricsObject.endObject();
        JsonWriter jsonWriter = $this$metricsObject.endObject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonWriter, (String)"endObject()");
        return jsonWriter;
    }

    private ResultWriter() {
    }

    static {
        ResultWriter resultWriter;
        INSTANCE = resultWriter = new ResultWriter();
        reports = new ArrayList();
    }
}

