/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Debug;
import androidx.benchmark.MetricCapture;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Landroidx/benchmark/AllocationCountCapture;", "Landroidx/benchmark/MetricCapture;", "()V", "currentPausedStarted", "", "currentTotalPaused", "name", "", "getName", "()Ljava/lang/String;", "capturePaused", "", "captureResumed", "captureStart", "captureStop", "", "benchmark-common_release"})
public final class AllocationCountCapture
extends MetricCapture {
    @NotNull
    private final String name;
    private int currentPausedStarted;
    private int currentTotalPaused;

    public AllocationCountCapture() {
        this.name = "allocationCount";
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void captureStart() {
        this.currentTotalPaused = 0;
        Debug.startAllocCounting();
    }

    @Override
    public long captureStop() {
        Debug.stopAllocCounting();
        return Debug.getGlobalAllocCount() - this.currentTotalPaused;
    }

    @Override
    public void capturePaused() {
        this.currentPausedStarted = Debug.getGlobalAllocCount();
    }

    @Override
    public void captureResumed() {
        AllocationCountCapture allocationCountCapture = this;
        allocationCountCapture.currentTotalPaused += Debug.getGlobalAllocCount() - this.currentPausedStarted;
    }
}

