/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import androidx.annotation.RestrictTo;
import androidx.benchmark.MetricResult;
import androidx.benchmark.Stats;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u000bH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00c6\u0003JU\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00062\b\b\u0002\u0010\r\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0003J\t\u0010%\u001a\u00020\u000bH\u00d6\u0001J\t\u0010&\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0010\u0010\f\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006'"}, d2={"Landroidx/benchmark/BenchmarkResult;", "", "className", "", "testName", "totalRunTimeNs", "", "metrics", "", "Landroidx/benchmark/MetricResult;", "repeatIterations", "", "thermalThrottleSleepSeconds", "warmupIterations", "(Ljava/lang/String;Ljava/lang/String;JLjava/util/List;IJI)V", "getClassName", "()Ljava/lang/String;", "getMetrics", "()Ljava/util/List;", "getRepeatIterations", "()I", "getTestName", "getWarmupIterations", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "getStats", "Landroidx/benchmark/Stats;", "which", "hashCode", "toString", "benchmark-common_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class BenchmarkResult {
    @NotNull
    private final String className;
    @NotNull
    private final String testName;
    @JvmField
    public final long totalRunTimeNs;
    @NotNull
    private final List<MetricResult> metrics;
    private final int repeatIterations;
    @JvmField
    public final long thermalThrottleSleepSeconds;
    private final int warmupIterations;

    public BenchmarkResult(@NotNull String className, @NotNull String testName, long totalRunTimeNs, @NotNull List<MetricResult> metrics, int repeatIterations, long thermalThrottleSleepSeconds, int warmupIterations) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        this.className = className;
        this.testName = testName;
        this.totalRunTimeNs = totalRunTimeNs;
        this.metrics = metrics;
        this.repeatIterations = repeatIterations;
        this.thermalThrottleSleepSeconds = thermalThrottleSleepSeconds;
        this.warmupIterations = warmupIterations;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final String getTestName() {
        return this.testName;
    }

    @NotNull
    public final List<MetricResult> getMetrics() {
        return this.metrics;
    }

    public final int getRepeatIterations() {
        return this.repeatIterations;
    }

    public final int getWarmupIterations() {
        return this.warmupIterations;
    }

    @NotNull
    public final Stats getStats(@NotNull String which) {
        Object element$iv2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)which, (String)"which");
            Iterable $this$first$iv = this.metrics;
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                MetricResult it = (MetricResult)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getStats().getName(), (Object)which)) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return ((MetricResult)element$iv2).getStats();
    }

    @NotNull
    public final String component1() {
        return this.className;
    }

    @NotNull
    public final String component2() {
        return this.testName;
    }

    public final long component3() {
        return this.totalRunTimeNs;
    }

    @NotNull
    public final List<MetricResult> component4() {
        return this.metrics;
    }

    public final int component5() {
        return this.repeatIterations;
    }

    public final long component6() {
        return this.thermalThrottleSleepSeconds;
    }

    public final int component7() {
        return this.warmupIterations;
    }

    @NotNull
    public final BenchmarkResult copy(@NotNull String className, @NotNull String testName, long totalRunTimeNs, @NotNull List<MetricResult> metrics, int repeatIterations, long thermalThrottleSleepSeconds, int warmupIterations) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)testName, (String)"testName");
        Intrinsics.checkNotNullParameter(metrics, (String)"metrics");
        return new BenchmarkResult(className, testName, totalRunTimeNs, metrics, repeatIterations, thermalThrottleSleepSeconds, warmupIterations);
    }

    public static /* synthetic */ BenchmarkResult copy$default(BenchmarkResult benchmarkResult, String string, String string2, long l, List list, int n, long l2, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            string = benchmarkResult.className;
        }
        if ((n3 & 2) != 0) {
            string2 = benchmarkResult.testName;
        }
        if ((n3 & 4) != 0) {
            l = benchmarkResult.totalRunTimeNs;
        }
        if ((n3 & 8) != 0) {
            list = benchmarkResult.metrics;
        }
        if ((n3 & 0x10) != 0) {
            n = benchmarkResult.repeatIterations;
        }
        if ((n3 & 0x20) != 0) {
            l2 = benchmarkResult.thermalThrottleSleepSeconds;
        }
        if ((n3 & 0x40) != 0) {
            n2 = benchmarkResult.warmupIterations;
        }
        return benchmarkResult.copy(string, string2, l, list, n, l2, n2);
    }

    @NotNull
    public String toString() {
        return "BenchmarkResult(className=" + this.className + ", testName=" + this.testName + ", totalRunTimeNs=" + this.totalRunTimeNs + ", metrics=" + this.metrics + ", repeatIterations=" + this.repeatIterations + ", thermalThrottleSleepSeconds=" + this.thermalThrottleSleepSeconds + ", warmupIterations=" + this.warmupIterations + ')';
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = result * 31 + this.testName.hashCode();
        result = result * 31 + Long.hashCode(this.totalRunTimeNs);
        result = result * 31 + ((Object)this.metrics).hashCode();
        result = result * 31 + Integer.hashCode(this.repeatIterations);
        result = result * 31 + Long.hashCode(this.thermalThrottleSleepSeconds);
        result = result * 31 + Integer.hashCode(this.warmupIterations);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BenchmarkResult)) {
            return false;
        }
        BenchmarkResult benchmarkResult = (BenchmarkResult)other;
        if (!Intrinsics.areEqual((Object)this.className, (Object)benchmarkResult.className)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.testName, (Object)benchmarkResult.testName)) {
            return false;
        }
        if (this.totalRunTimeNs != benchmarkResult.totalRunTimeNs) {
            return false;
        }
        if (!Intrinsics.areEqual(this.metrics, benchmarkResult.metrics)) {
            return false;
        }
        if (this.repeatIterations != benchmarkResult.repeatIterations) {
            return false;
        }
        if (this.thermalThrottleSleepSeconds != benchmarkResult.thermalThrottleSleepSeconds) {
            return false;
        }
        return this.warmupIterations == benchmarkResult.warmupIterations;
    }
}

