/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Landroidx/benchmark/CpuInfo;", "", "()V", "TAG", "", "coreDirs", "", "Landroidx/benchmark/CpuInfo$CoreDir;", "getCoreDirs", "()Ljava/util/List;", "locked", "", "getLocked", "()Z", "maxFreqHz", "", "getMaxFreqHz", "()J", "isCpuLocked", "readFileTextOrNull", "path", "CoreDir", "benchmark-common_release"})
public final class CpuInfo {
    @NotNull
    public static final CpuInfo INSTANCE;
    @NotNull
    private static final String TAG = "Benchmark";
    @NotNull
    private static final List<CoreDir> coreDirs;
    private static final boolean locked;
    private static final long maxFreqHz;

    private CpuInfo() {
    }

    @NotNull
    public final List<CoreDir> getCoreDirs() {
        return coreDirs;
    }

    public final boolean getLocked() {
        return locked;
    }

    public final long getMaxFreqHz() {
        return maxFreqHz;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCpuLocked(@NotNull List<CoreDir> coreDirs) {
        boolean bl;
        block15: {
            boolean bl2;
            boolean $i$f$any;
            Iterable $this$any$iv;
            List onlineCores;
            block14: {
                boolean bl3;
                block13: {
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter(coreDirs, (String)"coreDirs");
                    Iterable $this$filter$iv = coreDirs;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        CoreDir it = (CoreDir)element$iv$iv;
                        boolean bl4 = false;
                        if (!it.getOnline()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    onlineCores = (List)destination$iv$iv;
                    $this$any$iv = onlineCores;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            CoreDir it = (CoreDir)element$iv;
                            boolean bl5 = false;
                            if (!(!Intrinsics.areEqual((Object)CollectionsKt.maxOrNull((Iterable)it.getAvailableFreqs()), (Object)CollectionsKt.maxOrNull((Iterable)((CoreDir)onlineCores.get(0)).getAvailableFreqs())))) continue;
                            bl3 = true;
                            break block13;
                        }
                        bl3 = false;
                    }
                }
                if (bl3) {
                    Log.d((String)TAG, (String)"Clocks not locked: cores with different max frequencies");
                    return false;
                }
                $this$any$iv = onlineCores;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CoreDir it = (CoreDir)element$iv;
                        boolean bl6 = false;
                        if (!(it.getCurrentMinFreq() != ((CoreDir)onlineCores.get(0)).getCurrentMinFreq())) continue;
                        bl2 = true;
                        break block14;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                Log.d((String)TAG, (String)"Clocks not locked: cores with different current min freq");
                return false;
            }
            $this$any$iv = onlineCores;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CoreDir it = (CoreDir)element$iv;
                    boolean bl7 = false;
                    Integer n = (Integer)CollectionsKt.minOrNull((Iterable)it.getAvailableFreqs());
                    int n2 = it.getCurrentMinFreq();
                    if (!(n != null && n == n2)) continue;
                    bl = true;
                    break block15;
                }
                bl = false;
            }
        }
        if (bl) {
            Log.d((String)TAG, (String)"Clocks not locked: online cores with min freq == min avail freq");
            return false;
        }
        return true;
    }

    private final String readFileTextOrNull(String path) {
        try {
            String string;
            File file = new File(path);
            boolean bl = false;
            boolean bl2 = false;
            File $this$readFileTextOrNull_u24lambda_u2d10 = file;
            boolean bl3 = false;
            if ($this$readFileTextOrNull_u24lambda_u2d10.exists()) {
                String string2 = FilesKt.readText$default((File)$this$readFileTextOrNull_u24lambda_u2d10, null, (int)1, null);
                boolean bl4 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            } else {
                string = null;
            }
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        long l;
        Object e$iv;
        Object v8;
        void $this$maxByOrNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        Collection destination$iv$iv;
        Iterable $this$map$iv;
        List list;
        INSTANCE = new CpuInfo();
        File cpuDir = new File("/sys/devices/system/cpu");
        Object object = cpuDir.list(1.INSTANCE);
        if (object == null) {
            list = null;
        } else {
            String[] stringArray = object;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv;
            int n = ((void)iterator).length;
            for (int i = 0; i < n; ++i) {
                long l2;
                int n2;
                List list2;
                Collection<Integer> collection;
                Collection<Integer> collection2;
                String element$iv$iv;
                boolean bl;
                Iterable iterable;
                Collection<Integer> collection3;
                void it;
                Iterator item$iv$iv;
                Iterator iterator2 = item$iv$iv = iterator[i];
                Collection collection4 = destination$iv$iv;
                boolean bl2 = false;
                String path = cpuDir.getPath() + '/' + it;
                boolean bl3 = !Intrinsics.areEqual((Object)INSTANCE.readFileTextOrNull(Intrinsics.stringPlus((String)path, (Object)"/online")), (Object)"0");
                Object object2 = INSTANCE.readFileTextOrNull(Intrinsics.stringPlus((String)path, (Object)"/cpufreq/scaling_available_frequencies"));
                if (object2 == null) {
                    collection3 = null;
                } else {
                    Object object3 = (CharSequence)object2;
                    Regex regex = new Regex("\\s+");
                    int n3 = 0;
                    boolean bl4 = false;
                    iterable = regex.split((CharSequence)object3, n3);
                    if (iterable == null) {
                        collection3 = null;
                    } else {
                        void $this$filterTo$iv$iv2;
                        void $this$filter$iv2;
                        object3 = iterable;
                        bl = bl3;
                        boolean $i$f$filter = false;
                        void var21_34 = $this$filter$iv2;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterTo = false;
                        Iterator iterator3 = $this$filterTo$iv$iv2.iterator();
                        while (iterator3.hasNext()) {
                            String it2 = element$iv$iv = iterator3.next();
                            boolean bl5 = false;
                            CharSequence charSequence = it2;
                            boolean bl6 = false;
                            boolean bl7 = !StringsKt.isBlank((CharSequence)charSequence);
                            if (!bl7) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        collection2 = (List)destination$iv$iv2;
                        bl3 = bl;
                        collection3 = collection = collection2;
                    }
                }
                if (collection == null) {
                    list2 = null;
                } else {
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    iterable = collection;
                    bl = bl3;
                    boolean $i$f$map2 = false;
                    void $i$f$filter = $this$map$iv2;
                    Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void it3;
                        element$iv$iv = (String)item$iv$iv2;
                        collection2 = destination$iv$iv3;
                        boolean bl8 = false;
                        Integer n4 = Integer.parseInt((String)it3);
                        collection2.add(n4);
                    }
                    collection2 = (List)destination$iv$iv3;
                    bl3 = bl;
                    object2 = collection2;
                    list2 = CollectionsKt.sorted((Iterable)((Iterable)object2));
                }
                Object object4 = list2;
                Object object5 = object4 == null ? CollectionsKt.listOf((Object)-1) : object4;
                object4 = INSTANCE.readFileTextOrNull(Intrinsics.stringPlus((String)path, (Object)"/cpufreq/scaling_min_freq"));
                if (object4 == null) {
                    n2 = -1;
                } else {
                    int n5;
                    object2 = object4;
                    boolean bl9 = false;
                    n2 = n5 = Integer.parseInt((String)object2);
                }
                object4 = INSTANCE.readFileTextOrNull(Intrinsics.stringPlus((String)path, (Object)"/cpufreq/cpuinfo_max_freq"));
                if (object4 == null) {
                    l2 = -1L;
                } else {
                    long l3;
                    object2 = object4;
                    boolean bl10 = false;
                    l2 = l3 = Long.parseLong((String)object2);
                }
                long l4 = l2;
                int n6 = n2;
                List list3 = object5;
                boolean bl11 = bl3;
                CoreDir coreDir = new CoreDir(bl11, list3, n6, l4);
                collection4.add(coreDir);
            }
            list = (List)destination$iv$iv;
        }
        List list4 = list;
        coreDirs = list4 == null ? CollectionsKt.emptyList() : list4;
        $this$map$iv = coreDirs;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CoreDir it = (CoreDir)element$iv$iv;
            boolean bl = false;
            if (!(it.getMaxFreqKhz() != -1L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v8 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v8 = maxElem$iv;
            } else {
                CoreDir it = (CoreDir)maxElem$iv;
                boolean bl = false;
                long maxValue$iv = it.getMaxFreqKhz();
                do {
                    e$iv = iterator$iv.next();
                    CoreDir it4 = (CoreDir)e$iv;
                    $i$a$-maxByOrNull-CpuInfo$4 = false;
                    long v$iv = it4.getMaxFreqKhz();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v8 = maxElem$iv;
            }
        }
        object = v8;
        list4 = object == null ? null : Long.valueOf(((CoreDir)object).getMaxFreqKhz());
        maxFreqHz = list4 == null ? -1L : (l = (Long)((Object)list4) * (long)1000);
        locked = INSTANCE.isCpuLocked(coreDirs);
        Iterable $this$forEachIndexed$iv = coreDirs;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void coreDir;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            e$iv = (CoreDir)item$iv;
            int index = n;
            boolean bl12 = false;
            Log.d((String)TAG, (String)("cpu" + index + ' ' + coreDir));
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J7\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Landroidx/benchmark/CpuInfo$CoreDir;", "", "online", "", "availableFreqs", "", "", "currentMinFreq", "maxFreqKhz", "", "(ZLjava/util/List;IJ)V", "getAvailableFreqs", "()Ljava/util/List;", "getCurrentMinFreq", "()I", "getMaxFreqKhz", "()J", "getOnline", "()Z", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "toString", "", "benchmark-common_release"})
    public static final class CoreDir {
        private final boolean online;
        @NotNull
        private final List<Integer> availableFreqs;
        private final int currentMinFreq;
        private final long maxFreqKhz;

        public CoreDir(boolean online, @NotNull List<Integer> availableFreqs, int currentMinFreq, long maxFreqKhz) {
            Intrinsics.checkNotNullParameter(availableFreqs, (String)"availableFreqs");
            this.online = online;
            this.availableFreqs = availableFreqs;
            this.currentMinFreq = currentMinFreq;
            this.maxFreqKhz = maxFreqKhz;
        }

        public final boolean getOnline() {
            return this.online;
        }

        @NotNull
        public final List<Integer> getAvailableFreqs() {
            return this.availableFreqs;
        }

        public final int getCurrentMinFreq() {
            return this.currentMinFreq;
        }

        public final long getMaxFreqKhz() {
            return this.maxFreqKhz;
        }

        public final boolean component1() {
            return this.online;
        }

        @NotNull
        public final List<Integer> component2() {
            return this.availableFreqs;
        }

        public final int component3() {
            return this.currentMinFreq;
        }

        public final long component4() {
            return this.maxFreqKhz;
        }

        @NotNull
        public final CoreDir copy(boolean online, @NotNull List<Integer> availableFreqs, int currentMinFreq, long maxFreqKhz) {
            Intrinsics.checkNotNullParameter(availableFreqs, (String)"availableFreqs");
            return new CoreDir(online, availableFreqs, currentMinFreq, maxFreqKhz);
        }

        public static /* synthetic */ CoreDir copy$default(CoreDir coreDir, boolean bl, List list, int n, long l, int n2, Object object) {
            if ((n2 & 1) != 0) {
                bl = coreDir.online;
            }
            if ((n2 & 2) != 0) {
                list = coreDir.availableFreqs;
            }
            if ((n2 & 4) != 0) {
                n = coreDir.currentMinFreq;
            }
            if ((n2 & 8) != 0) {
                l = coreDir.maxFreqKhz;
            }
            return coreDir.copy(bl, list, n, l);
        }

        @NotNull
        public String toString() {
            return "CoreDir(online=" + this.online + ", availableFreqs=" + this.availableFreqs + ", currentMinFreq=" + this.currentMinFreq + ", maxFreqKhz=" + this.maxFreqKhz + ')';
        }

        public int hashCode() {
            int n = this.online ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result = n;
            result = result * 31 + ((Object)this.availableFreqs).hashCode();
            result = result * 31 + Integer.hashCode(this.currentMinFreq);
            result = result * 31 + Long.hashCode(this.maxFreqKhz);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CoreDir)) {
                return false;
            }
            CoreDir coreDir = (CoreDir)other;
            if (this.online != coreDir.online) {
                return false;
            }
            if (!Intrinsics.areEqual(this.availableFreqs, coreDir.availableFreqs)) {
                return false;
            }
            if (this.currentMinFreq != coreDir.currentMinFreq) {
                return false;
            }
            return this.maxFreqKhz == coreDir.maxFreqKhz;
        }
    }
}

