/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;
import androidx.benchmark.Arguments;
import androidx.benchmark.CpuInfo;
import androidx.benchmark.IsolationActivity;
import androidx.benchmark.MethodSamplingSimpleperf;
import androidx.test.platform.app.InstrumentationRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012J\u0017\u0010\u0013\u001a\u00020\u0006*\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u0011\u0010\u0016\u001a\u00020\u0006*\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Landroidx/benchmark/Errors;", "", "()V", "MINIMUM_BATTERY_PERCENT", "", "PREFIX", "", "getPREFIX", "()Ljava/lang/String;", "TAG", "UNSUPPRESSED_WARNING_MESSAGE", "isDeviceRooted", "", "isEmulator", "()Z", "warningString", "acquireWarningStringForLogging", "throwIfError", "", "toDisplayString", "", "toDisplayString$benchmark_common_release", "trimMarginWrapNewlines", "trimMarginWrapNewlines$benchmark_common_release", "benchmark-common_release"})
public final class Errors {
    @NotNull
    public static final Errors INSTANCE;
    @NotNull
    private static final String TAG = "Benchmark";
    @NotNull
    private static final String PREFIX;
    @Nullable
    private static final String UNSUPPRESSED_WARNING_MESSAGE;
    @Nullable
    private static String warningString;
    private static final int MINIMUM_BATTERY_PERCENT = 25;
    private static final boolean isEmulator;
    private static final boolean isDeviceRooted;

    private Errors() {
    }

    @NotNull
    public final String trimMarginWrapNewlines$benchmark_common_release(@NotNull String $this$trimMarginWrapNewlines) {
        Intrinsics.checkNotNullParameter((Object)$this$trimMarginWrapNewlines, (String)"<this>");
        return '\n' + StringsKt.trimMargin$default((String)$this$trimMarginWrapNewlines, null, (int)1, null) + " \n";
    }

    @NotNull
    public final String toDisplayString$benchmark_common_release(@NotNull Set<String> $this$toDisplayString) {
        Intrinsics.checkNotNullParameter($this$toDisplayString, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)CollectionsKt.toList((Iterable)$this$toDisplayString)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String getPREFIX() {
        return PREFIX;
    }

    @Nullable
    public final String acquireWarningStringForLogging() {
        String ret = warningString;
        warningString = null;
        return ret;
    }

    public final boolean isEmulator() {
        return isEmulator;
    }

    public final void throwIfError() {
        if (!Arguments.INSTANCE.getDryRunMode$benchmark_common_release() && UNSUPPRESSED_WARNING_MESSAGE != null) {
            throw new AssertionError((Object)UNSUPPRESSED_WARNING_MESSAGE);
        }
        if (Arguments.INSTANCE.getError$benchmark_common_release() != null) {
            throw new AssertionError((Object)Arguments.INSTANCE.getError$benchmark_common_release());
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    static {
        block24: {
            block25: {
                Errors.INSTANCE = new Errors();
                var0 /* !! */  = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)var0 /* !! */ , (String)"FINGERPRINT");
                if (StringsKt.startsWith$default((String)var0 /* !! */ , (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                var0 /* !! */  = Build.FINGERPRINT;
                Intrinsics.checkNotNullExpressionValue((Object)var0 /* !! */ , (String)"FINGERPRINT");
                if (StringsKt.startsWith$default((String)var0 /* !! */ , (String)"unknown", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                var0 /* !! */  = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)var0 /* !! */ , (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)((CharSequence)var0 /* !! */ ), (CharSequence)"google_sdk", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                var0 /* !! */  = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)var0 /* !! */ , (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)((CharSequence)var0 /* !! */ ), (CharSequence)"Emulator", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                var0 /* !! */  = Build.MODEL;
                Intrinsics.checkNotNullExpressionValue((Object)var0 /* !! */ , (String)"MODEL");
                if (StringsKt.contains$default((CharSequence)((CharSequence)var0 /* !! */ ), (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                var0 /* !! */  = Build.MANUFACTURER;
                Intrinsics.checkNotNullExpressionValue((Object)var0 /* !! */ , (String)"MANUFACTURER");
                if (StringsKt.contains$default((CharSequence)((CharSequence)var0 /* !! */ ), (CharSequence)"Genymotion", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                var0 /* !! */  = Build.BRAND;
                Intrinsics.checkNotNullExpressionValue((Object)var0 /* !! */ , (String)"BRAND");
                if (!StringsKt.startsWith$default((String)var0 /* !! */ , (String)"generic", (boolean)false, (int)2, null)) break block25;
                var0 /* !! */  = Build.DEVICE;
                Intrinsics.checkNotNullExpressionValue((Object)var0 /* !! */ , (String)"DEVICE");
                if (StringsKt.startsWith$default((String)var0 /* !! */ , (String)"generic", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            }
            if (Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT)) lbl-1000:
            // 8 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            Errors.isEmulator = v0;
            var0 /* !! */  = new String[]{"/system/app/Superuser.apk", "/sbin/su", "/system/bin/su", "/system/xbin/su", "/data/local/xbin/su", "/data/local/bin/su", "/system/sd/xbin/su", "/system/bin/failsafe/su", "/data/local/su", "/su/bin/su"};
            $this$any$iv /* !! */  = var0 /* !! */ ;
            $i$f$any = false;
            var2_3 /* !! */  = $this$any$iv /* !! */ ;
            var3_4 = var2_3 /* !! */ .length;
            for (var4_6 = 0; var4_6 < var3_4; ++var4_6) {
                it = element$iv = var2_3 /* !! */ [var4_6];
                $i$a$-any-Errors$isDeviceRooted$1 = false;
                if (!new File(it).exists()) continue;
                v1 = true;
                break block24;
            }
            v1 = false;
        }
        Errors.isDeviceRooted = v1;
        context = InstrumentationRegistry.getInstrumentation().getTargetContext();
        appInfo = context.getApplicationInfo();
        warningPrefix = "";
        warningString = "";
        var4_7 = Arguments.INSTANCE.getProfiler$benchmark_common_release();
        if (!Intrinsics.areEqual((Object)(var4_7 == null ? null : Boolean.valueOf(var4_7.getRequiresDebuggable())), (Object)true) && (appInfo.flags & 2) != 0) {
            warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"DEBUGGABLE_");
            warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Debuggable Benchmark\n                |    Benchmark is running with debuggable=true, which drastically reduces\n                |    runtime performance in order to support debugging features. Run\n                |    benchmarks with debuggable=false. Debuggable affects execution speed\n                |    in ways that mean benchmark improvements might not carry over to a\n                |    real user's experience (or even regress release performance).\n            "));
        }
        if (Errors.isEmulator) {
            warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"EMULATOR_");
            warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Running on Emulator\n                |    Benchmark is running on an emulator, which is not representative of\n                |    real user devices. Use a physical device to benchmark. Emulator\n                |    benchmark improvements might not carry over to a real user's\n                |    experience (or even regress real device performance).\n            "));
        }
        var4_7 = Build.FINGERPRINT;
        Intrinsics.checkNotNullExpressionValue((Object)var4_7, (String)"FINGERPRINT");
        if (StringsKt.contains$default((CharSequence)((CharSequence)var4_7), (CharSequence)":eng/", (boolean)false, (int)2, null)) {
            warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"ENG-BUILD_");
            warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Running on Eng Build\n                |    Benchmark is running on device flashed with a '-eng' build. Eng builds\n                |    of the platform drastically reduce performance to enable testing\n                |    changes quickly. For this reason they should not be used for\n                |    benchmarking. Use a '-user' or '-userdebug' system image.\n            "));
        }
        if (Intrinsics.areEqual((Object)(arguments = InstrumentationRegistry.getArguments()).get("coverage"), (Object)"true")) {
            warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"CODE-COVERAGE_");
            warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Code coverage enabled\n                |    Benchmark is running with code coverage enabled, which typically alters the dex\n                |    in a way that can affect performance. Ensure that code coverage is disabled by\n                |    setting testCoverageEnabled to false in the buildType your benchmarks run in.\n            "));
        }
        if (Errors.isDeviceRooted && !CpuInfo.INSTANCE.getLocked()) {
            warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"UNLOCKED_");
            warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Unlocked CPU clocks\n                |    Benchmark appears to be running on a rooted device with unlocked CPU\n                |    clocks. Unlocked CPU clocks can lead to inconsistent results due to\n                |    dynamic frequency scaling, and thermal throttling. On a rooted device,\n                |    lock your device clocks to a stable frequency with `./gradlew lockClocks`\n            "));
        }
        if (!CpuInfo.INSTANCE.getLocked() && IsolationActivity.Companion.isSustainedPerformanceModeSupported$benchmark_common_release() && !IsolationActivity.Companion.getSustainedPerformanceModeInUse$benchmark_common_release()) {
            warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"UNSUSTAINED-ACTIVITY-MISSING_");
            warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Cannot use SustainedPerformanceMode without IsolationActivity\n                |    Benchmark running on device that supports Window.setSustainedPerformanceMode,\n                |    but not launching IsolationActivity via the AndroidBenchmarkRunner. This\n                |    Activity is required to limit CPU clock max frequency, to prevent thermal\n                |    throttling. To fix this, add the following to your benchmark module-level\n                |    build.gradle:\n                |        android.defaultConfig.testInstrumentationRunner\n                |            = \"androidx.benchmark.junit4.AndroidBenchmarkRunner\"\n            "));
        } else if (IsolationActivity.Companion.getSingleton$benchmark_common_release().get() == null) {
            warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"ACTIVITY-MISSING_");
            warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Not using IsolationActivity via AndroidBenchmarkRunner\n                |    AndroidBenchmarkRunner should be used to isolate benchmarks from interference\n                |    from other visible apps. To fix this, add the following to your module-level\n                |    build.gradle:\n                |        android.defaultConfig.testInstrumentationRunner\n                |            = \"androidx.benchmark.junit4.AndroidBenchmarkRunner\"\n            "));
        }
        if (Intrinsics.areEqual((Object)Arguments.INSTANCE.getProfiler$benchmark_common_release(), (Object)MethodSamplingSimpleperf.INSTANCE)) {
            if (Build.VERSION.SDK_INT < 28) {
                warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"SIMPLEPERF_");
                warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                    |ERROR: Cannot use Simpleperf on this device's API level (" + Build.VERSION.SDK_INT + ")\n                    |    Simpleperf prior to API 28 (P) requires AOT compilation, and isn't \n                    |    currently supported by the benchmark library.\n                "));
            } else if (Build.VERSION.SDK_INT == 28 && !Errors.isDeviceRooted) {
                warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"SIMPLEPERF_");
                warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                    |ERROR: Cannot use Simpleperf on this device's API level (" + Build.VERSION.SDK_INT + ")\n                    |    without root. Simpleperf on API 28 (P) can only be used on a rooted device,\n                    |    or when the APK is debuggable. Debuggable performance measurements should\n                    |    be avoided, due to measurement inaccuracy.\n                "));
            } else if (Build.VERSION.SDK_INT >= 29 && !context.getApplicationInfo().isProfileableByShell()) {
                warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"SIMPLEPERF_");
                warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                    |ERROR: Apk must be profileable to use simpleperf.\n                    |    ensure you put <profileable android:shell=\"true\"/> within the\n                    |    <application ...> tag of your benchmark module\n                "));
            }
        }
        if (($i$a$-any-Errors$isDeviceRooted$1 = context.registerReceiver(null, filter = new IntentFilter("android.intent.action.BATTERY_CHANGED"))) == null) {
            v2 = 100;
        } else {
            var9_13 /* !! */  = $i$a$-any-Errors$isDeviceRooted$1;
            var10_16 = false;
            var11_19 = false;
            $this$_init__u24lambda_u2d1 = var9_13 /* !! */ ;
            $i$a$-run-Errors$batteryPercent$1 = false;
            level = $this$_init__u24lambda_u2d1.getIntExtra("level", 100);
            scale = $this$_init__u24lambda_u2d1.getIntExtra("scale", 100);
            v2 = batteryPercent = (var8_33 = level * 100 / scale);
        }
        if (batteryPercent < 25) {
            warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"LOW-BATTERY_");
            warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Device has low battery (" + batteryPercent + "%)\n                |    When battery is low, devices will often reduce performance (e.g. disabling big\n                |    cores) to save remaining battery. This occurs even when they are plugged in.\n                |    Wait for your battery to charge to at least 25%.\n                |    Currently at " + batteryPercent + "%.\n            "));
        }
        if (Arguments.INSTANCE.getProfiler$benchmark_common_release() != null) {
            profilerName = Arguments.INSTANCE.getProfiler$benchmark_common_release().getClass().getSimpleName();
            warningPrefix = Intrinsics.stringPlus((String)warningPrefix, (Object)"PROFILED_");
            warningString = Intrinsics.stringPlus((String)warningString, (Object)Errors.INSTANCE.trimMarginWrapNewlines$benchmark_common_release("\n                |WARNING: Using profiler=" + profilerName + ", results will be affected.\n            "));
        }
        Errors.PREFIX = warningPrefix;
        profilerName = warningString;
        var8_33 = 0;
        if (profilerName.length() > 0) {
            Errors.warningString = warningString;
            profilerName = new String[]{"\n"};
            $this$map$iv = StringsKt.split$default((CharSequence)warningString, (String[])profilerName, (boolean)false, (int)0, (int)6, null);
            $i$f$map = false;
            var9_13 /* !! */  = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (E item$iv$iv : $this$mapTo$iv$iv) {
                level = (String)item$iv$iv;
                var19_35 = destination$iv$iv;
                $i$a$-map-Errors$1 = false;
                var20_36 = Log.w((String)"Benchmark", (String)it);
                var19_35.add(var20_36);
            }
            (List)destination$iv$iv;
        }
        $i$f$map /* !! */  = new char[]{'_'};
        $i$f$map /* !! */  = (char[])StringsKt.split$default((CharSequence)Errors.PREFIX, (char[])$i$f$map /* !! */ , (boolean)false, (int)0, (int)6, null);
        $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            $i$a$-filter-Errors$warningSet$1 = false;
            var17_38 = it;
            var18_39 = false;
            v3 = var17_38.length() > 0;
            if (!v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        warningSet = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        alwaysSuppressed = SetsKt.setOf((Object)"PROFILED");
        neverSuppressed = SetsKt.setOf((Object)"SIMPLEPERF");
        suppressedWarnings = SetsKt.minus((Set)SetsKt.plus(Arguments.INSTANCE.getSuppressedErrors(), (Iterable)alwaysSuppressed), (Iterable)neverSuppressed);
        unsuppressedWarningSet = SetsKt.minus((Set)warningSet, (Iterable)suppressedWarnings);
        var12_23 = unsuppressedWarningSet;
        var13_27 = false;
        Errors.UNSUPPRESSED_WARNING_MESSAGE = var12_23.isEmpty() == false != false ? StringsKt.trimMargin$default((String)("\n                |ERRORS (not suppressed): " + Errors.INSTANCE.toDisplayString$benchmark_common_release(unsuppressedWarningSet) + "\n                |(Suppressed errors: " + Errors.INSTANCE.toDisplayString$benchmark_common_release(Arguments.INSTANCE.getSuppressedErrors()) + ")\n                |" + warningString + "\n                |While you can suppress these errors (turning them into warnings)\n                |PLEASE NOTE THAT EACH SUPPRESSED ERROR COMPROMISES ACCURACY\n                |\n                |// Sample suppression, in a benchmark module's build.gradle:\n                |android {\n                |    defaultConfig {\n                |        // Enable measuring on an emulator, or devices with low battery\n                |        testInstrumentationRunnerArguments[\"androidx.benchmark.suppressErrors\"] = \"EMULATOR,LOW-BATTERY\"\n                |    }\n                |}\n            "), null, (int)1, null) : (String)null;
    }
}

