/*
 * Decompiled with CFR 0.152.
 */
package androidx.benchmark;

import android.os.Build;
import android.os.Debug;
import android.util.Log;
import androidx.benchmark.Arguments;
import androidx.benchmark.InstrumentationResults;
import androidx.benchmark.Outputs;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\b\u0010\u0006\u001a\u00020\u0001H\u0000\u00a8\u0006\u0007"}, d2={"startRuntimeMethodTracing", "", "traceFileName", "", "sampled", "", "stopRuntimeMethodTracing", "benchmark-common_release"})
public final class ProfilerKt {
    public static final void startRuntimeMethodTracing(@NotNull String traceFileName, boolean sampled) {
        Intrinsics.checkNotNullParameter((Object)traceFileName, (String)"traceFileName");
        String path = Outputs.INSTANCE.testOutputFile(traceFileName).getAbsolutePath();
        Log.d((String)"Benchmark", (String)Intrinsics.stringPlus((String)"Profiling output file: ", (Object)path));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        InstrumentationResults.reportAdditionalFileToCopy$default(InstrumentationResults.INSTANCE, "profiling_trace", path, false, 4, null);
        int bufferSize = 0x1000000;
        if (sampled && Build.VERSION.SDK_INT >= 21) {
            Debug.startMethodTracingSampling((String)path, (int)bufferSize, (int)Arguments.INSTANCE.getProfilerSampleFrequency$benchmark_common_release());
        } else {
            Debug.startMethodTracing((String)path, (int)bufferSize, (int)0);
        }
    }

    public static final void stopRuntimeMethodTracing() {
        Debug.stopMethodTracing();
    }
}

